/*
 * Decompiled with CFR 0.152.
 */
package engineer.nightowl.sonos.api.resource;

import engineer.nightowl.sonos.api.SonosApiClient;
import engineer.nightowl.sonos.api.domain.SonosPlayMode;
import engineer.nightowl.sonos.api.domain.SonosPlaybackStatus;
import engineer.nightowl.sonos.api.domain.SonosSuccess;
import engineer.nightowl.sonos.api.exception.SonosApiClientException;
import engineer.nightowl.sonos.api.exception.SonosApiError;
import engineer.nightowl.sonos.api.resource.SubscribableResource;
import java.util.HashMap;

public class PlaybackResource
extends SubscribableResource {
    public PlaybackResource(SonosApiClient apiClient) {
        super(apiClient);
    }

    @Override
    String getSubscriptionPath() {
        return "/v1/groups/%s/playback/subscription";
    }

    public SonosPlaybackStatus getPlaybackStatus(String clientToken, String groupId) throws SonosApiClientException, SonosApiError {
        return this.getFromApi(SonosPlaybackStatus.class, clientToken, String.format("/v1/groups/%s/playback", groupId));
    }

    public SonosSuccess loadLineIn(String clientToken, String groupId, String deviceId, Boolean playOnCompletion) throws SonosApiClientException, SonosApiError {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        if (deviceId != null) {
            payload.put("deviceId", deviceId);
        }
        if (playOnCompletion != null) {
            payload.put("playOnCompletion", playOnCompletion);
        }
        return this.postToApi(SonosSuccess.class, clientToken, String.format("/v1/groups/%s/playback/lineIn", groupId), payload);
    }

    public SonosSuccess play(String clientToken, String groupId) throws SonosApiClientException, SonosApiError {
        return this.postToApi(SonosSuccess.class, clientToken, String.format("/v1/groups/%s/playback/play", groupId));
    }

    public SonosSuccess pause(String clientToken, String groupId) throws SonosApiClientException, SonosApiError {
        return this.postToApi(SonosSuccess.class, clientToken, String.format("/v1/groups/%s/playback/pause", groupId));
    }

    public SonosSuccess seek(String clientToken, String groupId, String itemId, Integer positionMillis) throws SonosApiClientException, SonosApiError {
        this.validateNotNull(positionMillis);
        HashMap<String, Object> payload = new HashMap<String, Object>();
        if (itemId != null) {
            payload.put("itemId", itemId);
        }
        payload.put("positionMillis", positionMillis);
        return this.postToApi(SonosSuccess.class, clientToken, String.format("/v1/groups/%s/playback/seek", groupId), payload);
    }

    public SonosSuccess seekRelative(String clientToken, String groupId, String itemId, Integer deltaMillis) throws SonosApiClientException, SonosApiError {
        this.validateNotNull(deltaMillis);
        HashMap<String, Object> payload = new HashMap<String, Object>();
        if (itemId != null) {
            payload.put("itemId", itemId);
        }
        payload.put("positionMillis", deltaMillis);
        return this.postToApi(SonosSuccess.class, clientToken, String.format("/v1/groups/%s/playback/seekRelative", groupId), payload);
    }

    public SonosSuccess setPlayModes(String clientToken, String groupId, SonosPlayMode playMode) throws SonosApiClientException, SonosApiError {
        this.validateNotNull(playMode);
        HashMap<String, SonosPlayMode> payload = new HashMap<String, SonosPlayMode>();
        payload.put("playModes", playMode);
        return this.postToApi(SonosSuccess.class, clientToken, String.format("/v1/groups/%s/playback/playMode", groupId), payload);
    }

    public SonosSuccess skipToNextTrack(String clientToken, String groupId) throws SonosApiClientException, SonosApiError {
        return this.postToApi(SonosSuccess.class, clientToken, String.format("/v1/groups/%s/playback/skipToNextTrack", groupId));
    }

    public SonosSuccess skipToPreviousTrack(String clientToken, String groupId) throws SonosApiClientException, SonosApiError {
        return this.postToApi(SonosSuccess.class, clientToken, String.format("/v1/groups/%s/playback/skipToPreviousTrack", groupId));
    }

    public SonosSuccess togglePlayPause(String clientToken, String groupId) throws SonosApiClientException, SonosApiError {
        return this.postToApi(SonosSuccess.class, clientToken, String.format("/v1/groups/%s/playback/togglePlayPause", groupId));
    }
}

