/*
 * Decompiled with CFR 0.152.
 */
package engineer.nightowl.sonos.api;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public class SonosApiConfiguration {
    private String applicationId;
    private String apiKey;
    private String apiSecret;
    private String authBaseUrl;
    private String controlBaseUrl;
    private Boolean clientSideValidationEnabled;

    public SonosApiConfiguration() {
        this.loadDefaults();
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public void setApiSecret(String apiSecret) {
        this.apiSecret = apiSecret;
    }

    public String getAuthBaseUrl() {
        return this.authBaseUrl;
    }

    public void setAuthBaseUrl(String authBaseUrl) {
        this.authBaseUrl = authBaseUrl;
    }

    public String getControlBaseUrl() {
        return this.controlBaseUrl;
    }

    public void setControlBaseUrl(String controlBaseUrl) {
        this.controlBaseUrl = controlBaseUrl;
    }

    public Boolean isClientSideValidationEnabled() {
        return this.clientSideValidationEnabled;
    }

    public void setClientSideValidationEnabled(Boolean clientSideValidationEnabled) {
        this.clientSideValidationEnabled = clientSideValidationEnabled;
    }

    public void loadDefaults() {
        this.setAuthBaseUrl("api.sonos.com");
        this.setControlBaseUrl("api.ws.sonos.com/control/api");
        this.setClientSideValidationEnabled(Boolean.TRUE);
    }

    public Header getAuthorizationHeader() {
        byte[] authBytes = String.join((CharSequence)":", this.getApiKey(), this.getApiSecret()).getBytes();
        String authBase64 = Base64.encodeBase64String((byte[])authBytes);
        String headerValue = String.join((CharSequence)" ", "Basic", authBase64);
        return new BasicHeader("Authorization", headerValue);
    }

    public String toString() {
        return "SonosApiConfiguration{applicationId='" + this.applicationId + "', apiKey='" + this.apiKey + "', apiSecret='" + this.apiSecret + "', authBaseUrl='" + this.authBaseUrl + "', controlBaseUrl='" + this.controlBaseUrl + "', clientSideValidationEnabled=" + this.clientSideValidationEnabled + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SonosApiConfiguration that = (SonosApiConfiguration)o;
        return new EqualsBuilder().append((Object)this.applicationId, (Object)that.applicationId).append((Object)this.apiKey, (Object)that.apiKey).append((Object)this.apiSecret, (Object)that.apiSecret).append((Object)this.authBaseUrl, (Object)that.authBaseUrl).append((Object)this.controlBaseUrl, (Object)that.controlBaseUrl).append((Object)this.clientSideValidationEnabled, (Object)that.clientSideValidationEnabled).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.applicationId).append((Object)this.apiKey).append((Object)this.apiSecret).append((Object)this.authBaseUrl).append((Object)this.controlBaseUrl).append((Object)this.clientSideValidationEnabled).toHashCode();
    }
}

