/*
 * Decompiled with CFR 0.152.
 */
package engineer.nightowl.sonos.api.resource;

import engineer.nightowl.sonos.api.SonosApiClient;
import engineer.nightowl.sonos.api.SonosApiConfiguration;
import engineer.nightowl.sonos.api.domain.SonosToken;
import engineer.nightowl.sonos.api.exception.SonosApiClientException;
import engineer.nightowl.sonos.api.exception.SonosApiError;
import engineer.nightowl.sonos.api.resource.BaseResource;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.SecureRandom;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;

public class AuthorizeResource
extends BaseResource {
    public AuthorizeResource(SonosApiClient apiClient) {
        super(apiClient);
    }

    public URI getAuthorizeCodeUri(String redirectUri, String state) throws URISyntaxException {
        SonosApiConfiguration configuration = this.apiClient.getConfiguration();
        URIBuilder uri = new URIBuilder();
        uri.setScheme("https");
        uri.setHost(configuration.getAuthBaseUrl());
        uri.setPath("/login/v3/oauth");
        uri.setParameter("client_id", configuration.getApiKey());
        uri.setParameter("redirect_uri", redirectUri);
        uri.setParameter("response_type", "code");
        uri.setParameter("scope", "playback-control-all");
        if (state != null) {
            uri.setParameter("state", state);
        }
        return uri.build();
    }

    public URI getAuthorizeCodeUri(String redirectUri) throws URISyntaxException {
        return this.getAuthorizeCodeUri(redirectUri, null);
    }

    public SonosToken createToken(String redirectUri, String authorizeCode) throws SonosApiClientException, SonosApiError {
        SonosApiConfiguration configuration = this.apiClient.getConfiguration();
        URIBuilder uri = new URIBuilder();
        uri.setScheme("https");
        uri.setHost(configuration.getAuthBaseUrl());
        uri.setPath("/login/v3/oauth/access");
        BasicNameValuePair redirectUriParameter = new BasicNameValuePair("redirect_uri", redirectUri);
        BasicNameValuePair code = new BasicNameValuePair("code", authorizeCode);
        BasicNameValuePair grantType = new BasicNameValuePair("grant_type", "authorization_code");
        HttpPost request = new HttpPost();
        ArrayList<BasicNameValuePair> postParameters = new ArrayList<BasicNameValuePair>();
        postParameters.add(redirectUriParameter);
        postParameters.add(code);
        postParameters.add(grantType);
        try {
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(postParameters));
        }
        catch (UnsupportedEncodingException e) {
            throw new SonosApiClientException("Unable to generate auth request content", e);
        }
        request.setHeader(configuration.getAuthorizationHeader());
        try {
            request.setURI(uri.build());
        }
        catch (URISyntaxException e) {
            throw new SonosApiClientException("Invalid URI built", e);
        }
        return this.callApi((HttpUriRequest)request, SonosToken.class);
    }

    public SonosToken refreshToken(String refreshToken) throws SonosApiClientException, SonosApiError {
        SonosApiConfiguration configuration = this.apiClient.getConfiguration();
        URIBuilder uri = new URIBuilder();
        uri.setScheme("https");
        uri.setHost(configuration.getAuthBaseUrl());
        uri.setPath("/login/v3/oauth/access");
        HttpPost request = new HttpPost();
        BasicNameValuePair refreshTokenParameter = new BasicNameValuePair("refresh_token", refreshToken);
        BasicNameValuePair grantType = new BasicNameValuePair("grant_type", "refresh_token");
        ArrayList<BasicNameValuePair> postParameters = new ArrayList<BasicNameValuePair>();
        postParameters.add(refreshTokenParameter);
        postParameters.add(grantType);
        try {
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(postParameters));
        }
        catch (UnsupportedEncodingException e) {
            throw new SonosApiClientException("Unable to generate auth request content", e);
        }
        request.setHeader(configuration.getAuthorizationHeader());
        try {
            request.setURI(uri.build());
        }
        catch (URISyntaxException e) {
            throw new SonosApiClientException("Invalid URI built", e);
        }
        return this.callApi((HttpUriRequest)request, SonosToken.class);
    }

    public String generateStateValue() {
        return new BigInteger(130, new SecureRandom()).toString(32);
    }
}

