/*
 * Decompiled with CFR 0.152.
 */
package engineer.nightowl.sonos.api.resource;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import engineer.nightowl.sonos.api.SonosApiClient;
import engineer.nightowl.sonos.api.SonosApiConfiguration;
import engineer.nightowl.sonos.api.enums.SonosType;
import engineer.nightowl.sonos.api.exception.SonosApiClientException;
import engineer.nightowl.sonos.api.exception.SonosApiError;
import engineer.nightowl.sonos.api.specs.Validatable;
import engineer.nightowl.sonos.api.util.SonosUtilityHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BaseResource {
    private static final ObjectMapper OM = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    static final String SONOS_TYPE_HEADER = "X-Sonos-Type";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    SonosApiClient apiClient;

    BaseResource(SonosApiClient apiClient) {
        this.apiClient = apiClient;
    }

    <T> T callApi(HttpUriRequest request, Class<T> type) throws SonosApiClientException, SonosApiError {
        Object responseContent;
        String sonosDeclaredClassName;
        byte[] bytes;
        CloseableHttpResponse response;
        this.logger.debug("Sending request to {}", (Object)request.getURI());
        try {
            response = this.apiClient.getHttpClient().execute(request);
        }
        catch (IOException e) {
            throw new SonosApiClientException("Error interrogating Sonos API", e);
        }
        if (401 == response.getStatusLine().getStatusCode()) {
            throw new SonosApiClientException("Invalid token");
        }
        try (InputStream stream = response.getEntity().getContent();){
            bytes = IOUtils.toByteArray((InputStream)stream);
        }
        catch (IOException ioe) {
            throw new SonosApiClientException("Unable to convert response body", ioe);
        }
        this.logger.debug("Raw response from API: {}", (Object)new String(bytes));
        SonosType sonosDeclaredClass = this.getTypeFromHeader(response);
        String string = sonosDeclaredClassName = sonosDeclaredClass == null ? null : sonosDeclaredClass.getClazz().getSimpleName();
        if (sonosDeclaredClassName == null || sonosDeclaredClassName.equals(type.getSimpleName())) {
            try {
                return type.cast(OM.readValue(bytes, Class.forName(type.getName())));
            }
            catch (IOException | ClassNotFoundException e) {
                String msg = String.format("Unexpected error converting response to %s (Sonos declared %s)", type.getSimpleName(), sonosDeclaredClassName);
                throw new SonosApiClientException(msg, e);
            }
        }
        try {
            responseContent = OM.readValue(bytes, sonosDeclaredClass.getClazz());
        }
        catch (IOException e) {
            throw new SonosApiClientException("Unable to parse error response from Sonos", e);
        }
        if (SonosType.getErrorTypes().contains((Object)sonosDeclaredClass)) {
            throw (SonosApiError)sonosDeclaredClass.getClazz().cast(responseContent);
        }
        String mismatchMsg = String.format("Sonos declared %s as the response type, but the integration requested %s", sonosDeclaredClassName, type.getSimpleName());
        throw new SonosApiClientException(mismatchMsg);
    }

    SonosType getTypeFromHeader(CloseableHttpResponse response) throws SonosApiClientException {
        String headerValue;
        Header header;
        if (response != null && (header = response.getFirstHeader(SONOS_TYPE_HEADER)) != null && !SonosUtilityHelper.isEmpty(header.getValue()) && !"none".equalsIgnoreCase(headerValue = header.getValue())) {
            try {
                return SonosType.valueOf(headerValue);
            }
            catch (IllegalArgumentException iae) {
                String msg = String.format("Unexpected return type [%s] - please raise a bug", headerValue);
                throw new SonosApiClientException(msg, iae);
            }
        }
        return null;
    }

    <T> T getFromApi(Class<T> returnType, String token, String path) throws SonosApiClientException, SonosApiError {
        HttpGet request = this.getGetRequest(token, path);
        return this.callApi((HttpUriRequest)request, returnType);
    }

    <T> T deleteFromApi(Class<T> returnType, String token, String path) throws SonosApiClientException, SonosApiError {
        HttpDelete request = this.getDeleteRequest(token, path);
        return this.callApi((HttpUriRequest)request, returnType);
    }

    <T> T postToApi(Class<T> returnType, String token, String path) throws SonosApiClientException, SonosApiError {
        return this.postToApi(returnType, token, path, null);
    }

    <T, U> T postToApi(Class<T> returnType, String token, String path, U content) throws SonosApiClientException, SonosApiError {
        HttpPost request = this.getPostRequest(token, path);
        Boolean validationEnabled = this.apiClient.getConfiguration().isClientSideValidationEnabled();
        if (validationEnabled.booleanValue() && content instanceof Validatable) {
            ((Validatable)content).validate();
        }
        if (!SonosUtilityHelper.isEmpty(content)) {
            StringEntity requestContent;
            try {
                String json = OM.writeValueAsString(content);
                requestContent = new StringEntity(json, ContentType.APPLICATION_JSON);
            }
            catch (JsonProcessingException e) {
                throw new SonosApiClientException("Unable to convert POST request parameters", e);
            }
            request.setEntity((HttpEntity)requestContent);
        }
        return this.callApi((HttpUriRequest)request, returnType);
    }

    <T extends HttpRequestBase> T getStandardRequest(Class<T> requestType, String token, String path) throws SonosApiClientException {
        HttpRequestBase request;
        try {
            request = (HttpRequestBase)requestType.newInstance();
        }
        catch (Exception e) {
            throw new SonosApiClientException("Unable to create class " + requestType.getSimpleName(), e);
        }
        SonosApiConfiguration configuration = this.apiClient.getConfiguration();
        URIBuilder uri = new URIBuilder();
        uri.setScheme("https");
        uri.setHost(configuration.getControlBaseUrl());
        uri.setPath(path);
        request.setHeader("Authorization", String.format("Bearer %s", token));
        try {
            request.setURI(uri.build());
        }
        catch (URISyntaxException e) {
            throw new SonosApiClientException("Invalid URI built", e);
        }
        return (T)request;
    }

    HttpGet getGetRequest(String token, String path) throws SonosApiClientException {
        return this.getStandardRequest(HttpGet.class, token, path);
    }

    HttpDelete getDeleteRequest(String token, String path) throws SonosApiClientException {
        return this.getStandardRequest(HttpDelete.class, token, path);
    }

    HttpPost getPostRequest(String token, String path) throws SonosApiClientException {
        return this.getStandardRequest(HttpPost.class, token, path);
    }

    void validateNotNull(Object o) throws SonosApiClientException {
        this.validateNotNull(o, null);
    }

    void validateNotNull(Object o, String fieldName) throws SonosApiClientException {
        if (SonosUtilityHelper.isEmpty(o)) {
            StringBuilder sb = new StringBuilder().append("Missing required parameter");
            if (fieldName != null) {
                sb.append(" - (").append(fieldName).append(")");
            }
            throw new SonosApiClientException(sb.toString());
        }
    }
}

