/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.classpath;

import es.prodevelop.pui9.classpath.IClasspathFinder;
import es.prodevelop.pui9.classpath.PuiClassLoaderUtils;
import es.prodevelop.pui9.components.PuiApplicationContext;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.WebApplicationContext;

public class NoUrlClassloaderClasspathFinder
implements IClasspathFinder {
    public List<File> getClasspath() {
        ArrayList<File> classpath = new ArrayList<File>();
        if (PuiClassLoaderUtils.getClassLoader() instanceof URLClassLoader) {
            return classpath;
        }
        WebApplicationContext webAppContext = (WebApplicationContext)PuiApplicationContext.getInstance().getAppContext();
        webAppContext.getServletContext();
        ServletContext servletContext = webAppContext.getServletContext();
        if (servletContext == null) {
            return Collections.emptyList();
        }
        Set jarList = servletContext.getResourcePaths("/WEB-INF/lib");
        if (ObjectUtils.isEmpty((Object)jarList)) {
            return classpath;
        }
        for (String jar : jarList) {
            jar = servletContext.getRealPath(jar);
            File file = new File(jar);
            String extension = FilenameUtils.getExtension((String)jar);
            if (!file.exists() || !file.canRead() || (!file.isFile() || !extension.equalsIgnoreCase("jar")) && !file.isDirectory()) continue;
            classpath.add(file);
        }
        return classpath;
    }
}

