/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.controller;

import es.prodevelop.pui9.annotations.PuiFunctionality;
import es.prodevelop.pui9.controller.AbstractPuiController;
import es.prodevelop.pui9.controller.IPuiCommonController;
import es.prodevelop.pui9.eventlistener.event.DeleteEvent;
import es.prodevelop.pui9.eventlistener.event.ExportEvent;
import es.prodevelop.pui9.eventlistener.event.GetEvent;
import es.prodevelop.pui9.eventlistener.event.InsertEvent;
import es.prodevelop.pui9.eventlistener.event.ListEvent;
import es.prodevelop.pui9.eventlistener.event.PatchEvent;
import es.prodevelop.pui9.eventlistener.event.PuiEvent;
import es.prodevelop.pui9.eventlistener.event.TemplateEvent;
import es.prodevelop.pui9.eventlistener.event.UpdateEvent;
import es.prodevelop.pui9.exceptions.PuiServiceDeleteException;
import es.prodevelop.pui9.exceptions.PuiServiceGetException;
import es.prodevelop.pui9.exceptions.PuiServiceInsertException;
import es.prodevelop.pui9.exceptions.PuiServiceNewException;
import es.prodevelop.pui9.exceptions.PuiServiceUpdateException;
import es.prodevelop.pui9.export.DataExporterRegistry;
import es.prodevelop.pui9.file.FileDownload;
import es.prodevelop.pui9.login.PuiUserSession;
import es.prodevelop.pui9.model.dao.interfaces.ITableDao;
import es.prodevelop.pui9.model.dao.interfaces.IViewDao;
import es.prodevelop.pui9.model.dao.registry.DaoRegistry;
import es.prodevelop.pui9.model.dto.interfaces.IDto;
import es.prodevelop.pui9.model.dto.interfaces.INullTable;
import es.prodevelop.pui9.model.dto.interfaces.INullView;
import es.prodevelop.pui9.model.dto.interfaces.ITableDto;
import es.prodevelop.pui9.model.dto.interfaces.IViewDto;
import es.prodevelop.pui9.search.ExportRequest;
import es.prodevelop.pui9.search.IPuiSearchAdapter;
import es.prodevelop.pui9.search.SearchRequest;
import es.prodevelop.pui9.search.SearchResponse;
import es.prodevelop.pui9.service.interfaces.IService;
import es.prodevelop.pui9.service.registry.ServiceRegistry;
import es.prodevelop.pui9.services.exceptions.PuiServiceConcurrencyException;
import es.prodevelop.pui9.services.exceptions.PuiServiceExportException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;

public abstract class AbstractCommonController<TPK extends ITableDto, T extends TPK, V extends IViewDto, DAO extends ITableDao<TPK, T>, VDAO extends IViewDao<V>, S extends IService<TPK, T, V, DAO, VDAO>>
extends AbstractPuiController
implements IPuiCommonController<TPK, T, V> {
    public static final String DTO_HASH_HEADER = "dtohash";
    @Autowired
    private DaoRegistry daoRegistry;
    @Autowired
    private ServiceRegistry serviceRegistry;
    @Autowired
    private IPuiSearchAdapter puiSearchAdapter;
    @Autowired
    private S service;
    private Boolean hasRelatedTable = null;
    private Boolean hasRelatedView = null;

    public void afterPropertiesSet() throws Exception {
        String modelId = this.getModelId();
        this.daoRegistry.registerModelDaos(modelId, this.getService().getTableDtoPkClass(), this.getService().getTableDtoClass(), this.getService().getViewDtoClass(), this.getService().getTableDao().getClass(), this.getService().getViewDao().getClass());
        this.serviceRegistry.registerModelService(modelId, this.getService().getClass());
    }

    protected String getModelId() {
        RequestMapping rm = this.getClass().getAnnotation(RequestMapping.class);
        if (rm == null) {
            return null;
        }
        String[] value = rm.value();
        if (value.length == 0) {
            return null;
        }
        String modelId = value[0].replace("/", "");
        return modelId;
    }

    protected DaoRegistry getDaoRegistry() {
        return this.daoRegistry;
    }

    public S getService() {
        return this.service;
    }

    protected DAO getTableDao() {
        return (DAO)this.service.getTableDao();
    }

    protected VDAO getViewDao() {
        return (VDAO)this.service.getViewDao();
    }

    @Override
    @PuiFunctionality(id="insert", value="getInsertFunctionality")
    @Operation(summary="The Template for creating a new element", description="Get the template for creating a new element")
    @GetMapping(value={"/template"}, produces={"application/json"})
    public T template() throws PuiServiceNewException {
        ITableDto dto = this.getService().getNew();
        this.fireEventTemplate(dto);
        return (T)dto;
    }

    @Override
    @PuiFunctionality(id="get", value="getGetFunctionality")
    @Operation(summary="Obtain an element", description="Get the element that matches the given PK")
    @GetMapping(value={"/get"}, produces={"application/json"})
    public T get(@Parameter(description="The PK of the element", required=true) TPK dtoPk) throws PuiServiceGetException {
        ITableDto dto = this.getService().getByPk(dtoPk);
        this.getResponse().setHeader(DTO_HASH_HEADER, String.valueOf(dto.hashCode()));
        this.fireEventGet(dto);
        return (T)dto;
    }

    @Override
    @PuiFunctionality(id="insert", value="getInsertFunctionality")
    @Operation(summary="Insert a new element", description="Insert a new element into the database")
    @PostMapping(value={"/insert"}, consumes={"application/json"}, produces={"application/json"})
    public T insert(@Parameter(description="The data of the element", required=true) @RequestBody T dto) throws PuiServiceInsertException {
        this.getService().insert(dto);
        this.fireEventInsert(dto);
        return dto;
    }

    @Override
    @PuiFunctionality(id="update", value="getUpdateFunctionality")
    @Operation(summary="Update an element", description="Update an existing element in the database")
    @PutMapping(value={"/update"}, consumes={"application/json"}, produces={"application/json"})
    public T update(@Parameter(description="The full data of the element be updated, including non changed values", required=true) @RequestBody T dto, @Parameter(description="The old dto hash for concurrency check", in=ParameterIn.QUERY) @RequestHeader(value="dtohash", required=false) String dtoHash) throws PuiServiceGetException, PuiServiceUpdateException, PuiServiceConcurrencyException {
        ITableDto pk = dto.createPk();
        ITableDto oldDto = this.getService().getByPk(pk, PuiUserSession.getSessionLanguage());
        if (!ObjectUtils.isEmpty((Object)dtoHash) && !Objects.equals(String.valueOf(oldDto.hashCode()), dtoHash)) {
            throw new PuiServiceConcurrencyException();
        }
        this.getService().update(dto);
        this.fireEventUpdate(oldDto, dto);
        return dto;
    }

    @Override
    @PuiFunctionality(id="update", value="getUpdateFunctionality")
    @Operation(summary="Patch some attributes of an element", description="Update only part of an existing element in the database")
    @PatchMapping(value={"/patch"}, consumes={"application/json"}, produces={"application/json"})
    public T patch(@Parameter(description="The PK of the element", required=true, in=ParameterIn.QUERY) TPK dtoPk, @Parameter(description="", required=true) @RequestBody Map<String, Object> properties) throws PuiServiceGetException, PuiServiceUpdateException {
        ITableDto oldDto = this.getService().getByPk(dtoPk, PuiUserSession.getSessionLanguage());
        ITableDto dto = this.getService().patch(dtoPk, properties);
        this.fireEventPatch(dtoPk, oldDto, properties);
        return (T)dto;
    }

    @Override
    @PuiFunctionality(id="delete", value="getDeleteFunctionality")
    @Operation(summary="Delete an element", description="Delete an element from the database")
    @DeleteMapping(value={"/delete"}, produces={"application/json"})
    public TPK delete(@Parameter(description="The PK of the element to be deleted", required=true, in=ParameterIn.QUERY) TPK dtoPk) throws PuiServiceGetException, PuiServiceDeleteException {
        ITableDto dto = this.getService().getByPk(dtoPk, PuiUserSession.getSessionLanguage());
        if (dto == null) {
            return null;
        }
        ITableDto deletedDtoPk = this.getService().delete(dtoPk);
        this.fireEventDelete(dto);
        return (TPK)deletedDtoPk;
    }

    @Override
    @PuiFunctionality(id="list", value="getListFunctionality")
    @Operation(summary="List the data from the view", description="List all the elements that accomplish the given condition")
    @PostMapping(value={"/list"}, consumes={"application/json"}, produces={"application/json"})
    public SearchResponse<V> list(@Parameter(description="The searching parameters") @RequestBody(required=false) SearchRequest req) throws PuiServiceGetException {
        if (this.puiSearchAdapter == null) {
            return SearchResponse.builder().build();
        }
        if (req == null) {
            req = SearchRequest.builder().build();
        }
        req.setModel(this.getModelId());
        req.setDtoClass(this.getViewDao().getDtoClass());
        req.setFromClient(Boolean.valueOf(true));
        SearchResponse res = this.puiSearchAdapter.search(req);
        this.fireEventList(req, (SearchResponse<IDto>)res);
        return res;
    }

    @Override
    @PuiFunctionality(id="list", value="getListFunctionality")
    @Operation(summary="List the data of a table", description="List all the elements that accomplish the given condition")
    @PostMapping(value={"/list"}, consumes={"application/json"}, produces={"application/json"})
    public SearchResponse<T> listFromTable(@Parameter(description="The searching parameters") @RequestBody(required=false) SearchRequest req) throws PuiServiceGetException {
        if (this.puiSearchAdapter == null) {
            return SearchResponse.builder().build();
        }
        if (req == null) {
            req = SearchRequest.builder().build();
        }
        req.setModel(this.getModelId());
        req.setDtoClass(this.getTableDao().getDtoClass());
        req.setFromClient(Boolean.valueOf(true));
        SearchResponse res = this.puiSearchAdapter.search(req);
        this.fireEventList(req, (SearchResponse<IDto>)res);
        return res;
    }

    @Override
    @PuiFunctionality(id="export", value="getExportFunctionality")
    @Operation(summary="Export the grid data", description="Export the current grid data")
    @PostMapping(value={"/export"}, consumes={"application/json"}, produces={"application/octet-stream"})
    public FileDownload export(@RequestBody(required=false) ExportRequest req) throws PuiServiceExportException {
        if (req == null) {
            req = ExportRequest.builder().build();
        }
        req.setModel(this.getModelId());
        req.setFromClient(Boolean.valueOf(true));
        if (this.allowListFromTable()) {
            req.setDtoClass(this.getTableDao().getDtoClass());
        } else {
            req.setDtoClass(this.getViewDao().getDtoClass());
        }
        FileDownload fd = DataExporterRegistry.getSingleton().getExporter(req.getExportType()).export(req);
        this.fireEventExport(req, fd);
        return fd;
    }

    @Override
    public boolean allowGet() {
        return this.hasRelatedTable();
    }

    @Override
    public boolean allowTemplate() {
        return this.allowInsert();
    }

    @Override
    public boolean allowInsert() {
        return this.hasRelatedTable();
    }

    @Override
    public boolean allowUpdate() {
        return this.hasRelatedTable();
    }

    @Override
    public boolean allowPatch() {
        return this.allowUpdate();
    }

    @Override
    public boolean allowDelete() {
        return this.hasRelatedTable();
    }

    @Override
    public boolean allowList() {
        return this.hasRelatedView();
    }

    @Override
    public boolean allowListFromTable() {
        return false;
    }

    @Override
    public boolean allowExport() {
        return this.allowList() || this.allowListFromTable();
    }

    protected void fireEventGet(T dto) {
        this.getEventLauncher().fireAsync((PuiEvent)new GetEvent(dto));
    }

    protected void fireEventTemplate(T dto) {
        this.getEventLauncher().fireAsync((PuiEvent)new TemplateEvent(dto));
    }

    protected void fireEventInsert(T dto) {
        this.getEventLauncher().fireAsync((PuiEvent)new InsertEvent(dto));
    }

    protected void fireEventUpdate(T oldDto, T dto) {
        this.getEventLauncher().fireAsync((PuiEvent)new UpdateEvent(dto, oldDto));
    }

    protected void fireEventPatch(TPK dtoPk, T oldDto, Map<String, Object> properties) {
        this.getEventLauncher().fireAsync((PuiEvent)new PatchEvent(dtoPk, oldDto, properties));
    }

    protected void fireEventDelete(T dto) {
        this.getEventLauncher().fireAsync((PuiEvent)new DeleteEvent(dto));
    }

    protected void fireEventList(SearchRequest req, SearchResponse<? extends IDto> res) {
        this.getEventLauncher().fireAsync((PuiEvent)new ListEvent(req, res));
    }

    protected void fireEventExport(ExportRequest req, FileDownload fd) {
        this.getEventLauncher().fireAsync((PuiEvent)new ExportEvent(req, fd));
    }

    private Boolean hasRelatedTable() {
        if (this.hasRelatedTable == null) {
            this.hasRelatedTable = this.hasRelatedEntity(INullTable.class);
        }
        return this.hasRelatedTable;
    }

    private Boolean hasRelatedView() {
        if (this.hasRelatedView == null) {
            this.hasRelatedView = this.hasRelatedEntity(INullView.class);
        }
        return this.hasRelatedView;
    }

    private <FEC extends IDto> Boolean hasRelatedEntity(Class<FEC> fakeEntityClass) {
        Class entityDtoClass = null;
        try {
            Type superClass = this.getClass();
            while (superClass instanceof Class && ((Class)superClass).getSuperclass().equals(((Class)superClass).getGenericSuperclass())) {
                superClass = ((Class)superClass).getSuperclass();
            }
            superClass = ((Class)superClass).getGenericSuperclass();
            for (Type type : ((ParameterizedType)superClass).getActualTypeArguments()) {
                if (!(type instanceof Class) || !fakeEntityClass.isAssignableFrom((Class)type)) continue;
                entityDtoClass = (Class)type;
                break;
            }
        }
        catch (Exception e1) {
            try {
                for (TypeVariable<Class<?>> typevar : this.getClass().getTypeParameters()) {
                    for (Type type : typevar.getBounds()) {
                        if (!(type instanceof Class) || !fakeEntityClass.isAssignableFrom((Class)type)) continue;
                        entityDtoClass = (Class)type;
                    }
                }
            }
            catch (Exception e2) {
                return false;
            }
        }
        return entityDtoClass == null || !fakeEntityClass.isAssignableFrom(entityDtoClass);
    }
}

