/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.data.converters;

import es.prodevelop.pui9.data.converters.IPuiGenericConverter;
import es.prodevelop.pui9.json.GsonSingleton;
import es.prodevelop.pui9.model.dto.DtoFactory;
import es.prodevelop.pui9.model.dto.DtoRegistry;
import es.prodevelop.pui9.model.dto.interfaces.IDto;
import java.util.Collections;
import java.util.Set;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;

public class DtoConverter
implements IPuiGenericConverter {
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(String.class, IDto.class));
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        try {
            Class clazz = targetType.getType();
            Class dtoClass = null;
            if (clazz.isInterface()) {
                dtoClass = DtoFactory.getClassFromInterface((Class)clazz);
                if (dtoClass == null && (dtoClass = DtoRegistry.getDtoImplementation((Class)clazz)) == null) {
                    return null;
                }
            } else {
                dtoClass = clazz;
            }
            String val = source.toString();
            return GsonSingleton.getSingleton().getGson().fromJson(val, dtoClass);
        }
        catch (Exception e) {
            return null;
        }
    }
}

