/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.interceptors;

import es.prodevelop.pui9.components.PuiApplicationContext;
import es.prodevelop.pui9.lang.LanguageThreadLocal;
import es.prodevelop.pui9.login.IPuiApiKeyLogin;
import es.prodevelop.pui9.login.IPuiOpenapiLogin;
import es.prodevelop.pui9.login.IPuiSessionContext;
import es.prodevelop.pui9.login.PuiUserSession;
import es.prodevelop.pui9.mvc.configuration.IPuiRequestMappingHandlerMapping;
import es.prodevelop.pui9.services.exceptions.PuiServiceNoSessionException;
import es.prodevelop.pui9.services.exceptions.PuiServiceNotAllowedException;
import es.prodevelop.pui9.services.exceptions.PuiServiceUserNotAuthenticatedException;
import es.prodevelop.pui9.services.exceptions.PuiServiceUserSessionTimeoutException;
import es.prodevelop.pui9.utils.PuiLanguage;
import es.prodevelop.pui9.utils.PuiLanguageUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.ObjectUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class PuiInterceptor
implements HandlerInterceptor {
    protected final Logger logger = LogManager.getLogger(this.getClass());

    protected IPuiSessionContext getPuiSessionContext() {
        return (IPuiSessionContext)PuiApplicationContext.getInstance().getBean(IPuiSessionContext.class);
    }

    protected IPuiApiKeyLogin getPuiApiKeyLogin() {
        return (IPuiApiKeyLogin)PuiApplicationContext.getInstance().getBean(IPuiApiKeyLogin.class);
    }

    protected IPuiOpenapiLogin getPuiOpenapiLogin() {
        return (IPuiOpenapiLogin)PuiApplicationContext.getInstance().getBean(IPuiOpenapiLogin.class);
    }

    protected IPuiRequestMappingHandlerMapping getPuiRequestMapping() {
        return (IPuiRequestMappingHandlerMapping)PuiApplicationContext.getInstance().getBean(IPuiRequestMappingHandlerMapping.class);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        this.cleanContextData();
        PuiLanguage lang = this.getLanguage(request);
        this.setLanguageToThreadLocal(lang);
        boolean accept = false;
        if (this.getPuiRequestMapping().isWebServiceSecured(handler)) {
            if (this.isApiKeyRequest(request, handler)) {
                this.getPuiApiKeyLogin().initSession(request, handler);
            } else if (this.isSessionRequiredRequest(handler)) {
                if (this.isOpenapiRequest(request)) {
                    this.getPuiOpenapiLogin().initSession(request);
                } else {
                    this.setContextSession(request);
                }
            } else {
                throw new PuiServiceNotAllowedException();
            }
            this.checkUserPermission(handler);
            this.setLanguageToCurrentSession(lang);
            accept = true;
        } else {
            accept = true;
        }
        return accept;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return;
        }
        if (this.getPuiRequestMapping().isWebServiceSecured(handler) && this.isSessionRequiredRequest(handler)) {
            if (this.isOpenapiRequest(request)) {
                this.getPuiOpenapiLogin().finishSession();
            } else {
                this.cleanContextData();
            }
        }
        LanguageThreadLocal.getSingleton().removeData();
    }

    protected boolean isApiKeyRequest(HttpServletRequest request, Object handler) {
        return this.getPuiApiKeyLogin() != null && this.getPuiApiKeyLogin().isApiKeyRequest(request, handler);
    }

    protected boolean isSessionRequiredRequest(Object handler) {
        return this.getPuiRequestMapping().isWebServiceSessionRequired(handler);
    }

    protected boolean isOpenapiRequest(HttpServletRequest request) {
        return this.getPuiOpenapiLogin() != null && this.getPuiOpenapiLogin().isOpenapiRequest(request);
    }

    protected void setContextSession(HttpServletRequest request) throws PuiServiceNoSessionException, PuiServiceUserSessionTimeoutException, PuiServiceUserNotAuthenticatedException {
        if (this.getPuiSessionContext() != null) {
            this.getPuiSessionContext().setContextSession(request.getHeader("Authorization"));
        }
    }

    protected void cleanContextData() {
        if (this.getPuiSessionContext() != null) {
            this.getPuiSessionContext().removeContextSession();
        }
        LanguageThreadLocal.getSingleton().removeData();
    }

    protected void checkUserPermission(Object handler) throws PuiServiceNotAllowedException {
        String functionality = this.getPuiRequestMapping().getWebServiceFunctionality(handler);
        boolean hasFunctionality = false;
        if (ObjectUtils.isEmpty((Object)functionality)) {
            hasFunctionality = true;
        } else {
            boolean bl = hasFunctionality = PuiUserSession.getCurrentSession().getFunctionalities().stream().filter(func -> func.equals(functionality)).count() > 0L;
        }
        if (!hasFunctionality) {
            throw new PuiServiceNotAllowedException();
        }
    }

    protected PuiLanguage getLanguage(HttpServletRequest request) {
        PuiLanguage lang = this.getLanguageForRequest(request);
        if (lang == null) {
            lang = PuiLanguage.DEFAULT_LANG;
        }
        return lang;
    }

    protected void setLanguageToThreadLocal(PuiLanguage lang) {
        LanguageThreadLocal.getSingleton().setData(lang);
    }

    protected void setLanguageToCurrentSession(PuiLanguage lang) {
        PuiUserSession.getCurrentSession().setLanguage(lang);
    }

    protected PuiLanguage getLanguageForRequest(HttpServletRequest request) {
        PuiLanguage lang = this.getLanguageFromUrlParameter(request);
        if (lang == null) {
            lang = this.getLanguageFromHeaders(request);
        }
        if (lang == null) {
            lang = this.getLanguageFromLoggedUser();
        }
        if (lang == null) {
            lang = this.getLanguageFromDB();
        }
        return lang;
    }

    protected PuiLanguage getLanguageFromUrlParameter(HttpServletRequest request) {
        String lang = request.getParameter("lang");
        return PuiLanguageUtils.existLanguage((String)lang) ? new PuiLanguage(lang) : null;
    }

    protected PuiLanguage getLanguageFromHeaders(HttpServletRequest request) {
        String lang = request.getHeader("lang");
        if (PuiLanguageUtils.existLanguage((String)lang)) {
            return new PuiLanguage(lang);
        }
        Locale locale = request.getLocale();
        if (PuiLanguageUtils.existLanguage((Locale)locale)) {
            return new PuiLanguage(locale);
        }
        return null;
    }

    protected PuiLanguage getLanguageFromLoggedUser() {
        PuiUserSession userSession = PuiUserSession.getCurrentSession();
        if (userSession != null) {
            return PuiLanguageUtils.existLanguage((PuiLanguage)userSession.getLanguage()) ? userSession.getLanguage() : null;
        }
        return null;
    }

    protected PuiLanguage getLanguageFromDB() {
        return PuiLanguageUtils.getDefaultLanguage();
    }
}

