/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.spring.configuration;

import es.prodevelop.pui9.beans.IPuiInitDestroyBean;
import es.prodevelop.pui9.controller.AbstractPuiController;
import es.prodevelop.pui9.cypher.PuiCypherData;
import es.prodevelop.pui9.interceptors.PuiInterceptor;
import es.prodevelop.pui9.spring.configuration.annotations.PuiSpringConfiguration;
import es.prodevelop.pui9.threads.PuiBackgroundExecutors;
import es.prodevelop.pui9.utils.PuiDateUtil;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.springframework.context.annotation.Bean;
import org.springframework.jndi.JndiTemplate;
import org.springframework.web.servlet.HandlerInterceptor;

@PuiSpringConfiguration
public abstract class AbstractAppSpringConfiguration
implements IPuiInitDestroyBean {
    private List<Class<? extends AbstractPuiController>> overridedPuiControllers;

    protected AbstractAppSpringConfiguration() {
        this.setServerTimeZone();
    }

    private void setServerTimeZone() {
        TimeZone.setDefault(TimeZone.getTimeZone(PuiDateUtil.utcZone));
    }

    public void destroy() throws Exception {
        PuiBackgroundExecutors.getSingleton().destroy();
    }

    @Bean
    public HandlerInterceptor actionInterceptor() {
        return this.getHandlerInterceptor();
    }

    @Bean
    public DataSource dataSource() throws NamingException {
        return this.createDataSource();
    }

    protected DataSource createDataSource() throws NamingException {
        try {
            String jndiName = this.getJndiName();
            if (jndiName != null) {
                JndiTemplate jndi = new JndiTemplate();
                return (DataSource)jndi.lookup(jndiName);
            }
            return null;
        }
        catch (NamingException e) {
            return null;
        }
    }

    @Bean
    public PuiCypherData puiCypherData() {
        return this.getPuiCypherData();
    }

    public List<Class<? extends AbstractPuiController>> getOverridedPuiControllers() {
        if (this.overridedPuiControllers == null) {
            this.overridedPuiControllers = this.fillOverridedPuiControllers();
        }
        return this.overridedPuiControllers;
    }

    protected PuiInterceptor getHandlerInterceptor() {
        return new PuiInterceptor();
    }

    protected abstract String getJndiName();

    protected abstract PuiCypherData getPuiCypherData();

    protected List<Class<? extends AbstractPuiController>> fillOverridedPuiControllers() {
        return Collections.emptyList();
    }
}

