/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.spring.configuration;

import es.prodevelop.pui9.exceptions.PuiException;
import es.prodevelop.pui9.exceptions.PuiExceptionDto;
import jakarta.servlet.ServletException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;

@ControllerAdvice
public class PuiExceptionHandler {
    private Logger logger = LogManager.getLogger(this.getClass());

    @ExceptionHandler(value={Exception.class})
    private PuiExceptionDto handlePuiExceptionDto(Exception ex, WebRequest request) {
        PuiExceptionDto errorDto;
        boolean shouldLog = true;
        Exception realException = ex;
        if (!(realException instanceof PuiException) && realException.getCause() instanceof PuiException) {
            realException = (Exception)ex.getCause();
        }
        if (realException instanceof PuiException) {
            PuiException pe = (PuiException)realException;
            errorDto = pe.asTransferObject();
            shouldLog = pe.shouldLog();
            errorDto.withClassName(((PuiException)realException).getClassName());
        } else {
            errorDto = new PuiException((Throwable)realException).asTransferObject();
        }
        String url = "";
        if (request instanceof ServletWebRequest) {
            ServletWebRequest swr = (ServletWebRequest)request;
            url = swr.getRequest().getRequestURI();
        }
        errorDto.withUrl(url);
        HttpStatus status = HttpStatus.resolve((int)errorDto.getStatusCode());
        if (status != null) {
            errorDto.withStatusCode(status.value());
        }
        errorDto.withErrorClassName(ex.getClass().getName());
        if (shouldLog) {
            if (realException instanceof ServletException) {
                String message = realException.getMessage() + " (url: {})";
                this.logger.error(message, (Object)url, (Object)realException);
            } else {
                this.logger.error(realException.toString(), (Throwable)realException);
            }
        }
        if (HttpStatus.INTERNAL_SERVER_ERROR.equals((Object)status)) {
            request.setAttribute("jakarta.servlet.error.exception", (Object)realException, 0);
        }
        return errorDto;
    }
}

