/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.spring.configuration;

import es.prodevelop.pui9.data.converters.IPuiConverter;
import es.prodevelop.pui9.data.converters.IPuiGenericConverter;
import es.prodevelop.pui9.data.converters.PuiGsonHttpMessageConverter;
import es.prodevelop.pui9.spring.configuration.AbstractAppSpringConfiguration;
import es.prodevelop.pui9.spring.configuration.IPuiCorsHandler;
import es.prodevelop.pui9.spring.configuration.IPuiResourceHandler;
import es.prodevelop.pui9.spring.configuration.annotations.PuiSpringConfiguration;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.support.ConversionServiceFactoryBean;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.validation.Validator;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import org.springframework.web.servlet.mvc.method.pui9.PuiExceptionHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.pui9.PuiIDtoArgumentResolver;
import org.springframework.web.servlet.mvc.method.pui9.PuiRequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.pui9.PuiRequestMappingHandlerMapping;
import org.springframework.web.servlet.resource.ResourceUrlProvider;

@PuiSpringConfiguration
@ComponentScan(basePackages={"es.prodevelop.pui9"})
public class PuiRootSpringConfiguration
extends WebMvcConfigurationSupport {
    @Autowired
    private AbstractAppSpringConfiguration appConfig;
    @Autowired(required=false)
    private Optional<List<IPuiResourceHandler>> resourceHandlers;

    @Bean
    public PuiRequestMappingHandlerMapping requestMappingHandlerMapping(@Qualifier(value="mvcContentNegotiationManager") ContentNegotiationManager contentNegotiationManager, @Qualifier(value="mvcConversionService") FormattingConversionService conversionService, @Qualifier(value="mvcResourceUrlProvider") ResourceUrlProvider resourceUrlProvider) {
        return (PuiRequestMappingHandlerMapping)super.requestMappingHandlerMapping(contentNegotiationManager, conversionService, resourceUrlProvider);
    }

    @Bean
    public PuiRequestMappingHandlerAdapter requestMappingHandlerAdapter(@Qualifier(value="mvcContentNegotiationManager") ContentNegotiationManager contentNegotiationManager, @Qualifier(value="mvcConversionService") FormattingConversionService conversionService, @Qualifier(value="mvcValidator") Validator validator) {
        return (PuiRequestMappingHandlerAdapter)super.requestMappingHandlerAdapter(contentNegotiationManager, conversionService, validator);
    }

    protected PuiRequestMappingHandlerMapping createRequestMappingHandlerMapping() {
        return new PuiRequestMappingHandlerMapping();
    }

    protected PuiRequestMappingHandlerAdapter createRequestMappingHandlerAdapter() {
        return new PuiRequestMappingHandlerAdapter(this.getMessageConverters());
    }

    protected PuiExceptionHandlerExceptionResolver createExceptionHandlerExceptionResolver() {
        return new PuiExceptionHandlerExceptionResolver(this.getMessageConverters());
    }

    protected void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add((HandlerMethodArgumentResolver)new PuiIDtoArgumentResolver());
    }

    protected void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(this.appConfig.actionInterceptor()).addPathPatterns(new String[]{"/**"});
    }

    protected void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add(0, (HttpMessageConverter<?>)new PuiGsonHttpMessageConverter());
    }

    protected void addFormatters(FormatterRegistry registry) {
        for (GenericConverter genericConverter : this.getPuiGenericConverters()) {
            registry.addConverter(genericConverter);
        }
        for (Converter converter : this.getPuiConverters()) {
            registry.addConverter(converter);
        }
    }

    protected void addResourceHandlers(ResourceHandlerRegistry registry) {
        if (this.resourceHandlers.isPresent()) {
            this.resourceHandlers.get().forEach(rh -> rh.addResourceHandler(registry));
        }
    }

    protected void addViewControllers(ViewControllerRegistry registry) {
        if (this.resourceHandlers.isPresent()) {
            this.resourceHandlers.get().forEach(rh -> rh.addViewControllers(registry));
        }
    }

    protected void addCorsMappings(CorsRegistry registry) {
        Reflections ref = new Reflections("es.prodevelop", new Scanner[0]);
        Set corsHandlerClasses = ref.getSubTypesOf(IPuiCorsHandler.class);
        corsHandlerClasses.removeIf(tac -> tac.isInterface() || Modifier.isAbstract(tac.getModifiers()));
        corsHandlerClasses.stream().map(chc -> {
            try {
                Constructor construct = chc.getConstructor(new Class[0]);
                return (IPuiCorsHandler)construct.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                return null;
            }
        }).filter(Objects::nonNull).forEach(ch -> ch.addCorsMapping(registry));
    }

    @Bean
    public ConversionServiceFactoryBean conversionService() {
        HashSet<GenericConverter> converters = new HashSet<GenericConverter>();
        converters.addAll(this.getPuiGenericConverters());
        ConversionServiceFactoryBean conversionService = new ConversionServiceFactoryBean();
        conversionService.setConverters(converters);
        return conversionService;
    }

    private List<Converter> getPuiConverters() {
        Reflections ref = new Reflections("es.prodevelop", new Scanner[0]);
        Set convertersClasses = ref.getSubTypesOf(IPuiConverter.class);
        convertersClasses.removeIf(tac -> tac.isInterface() || Modifier.isAbstract(tac.getModifiers()));
        return convertersClasses.stream().map(tac -> {
            try {
                Constructor construct = tac.getConstructor(new Class[0]);
                return (Converter)construct.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<GenericConverter> getPuiGenericConverters() {
        Reflections ref = new Reflections("es.prodevelop", new Scanner[0]);
        Set convertersClasses = ref.getSubTypesOf(IPuiGenericConverter.class);
        convertersClasses.removeIf(tac -> tac.isInterface() || Modifier.isAbstract(tac.getModifiers()));
        return convertersClasses.stream().map(tac -> {
            try {
                Constructor construct = tac.getConstructor(new Class[0]);
                return (GenericConverter)construct.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

