/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.spring.configuration;

import es.prodevelop.pui9.spring.configuration.AbstractAppSpringConfiguration;
import es.prodevelop.pui9.spring.configuration.PuiRootSpringConfiguration;
import es.prodevelop.pui9.spring.configuration.annotations.PuiSpringConfiguration;
import jakarta.servlet.Filter;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.ServletRegistration;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.springframework.context.annotation.Bean;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;
import org.springframework.web.servlet.support.AbstractAnnotationConfigDispatcherServletInitializer;

@PuiSpringConfiguration
public class PuiWebApplicationSpringConfiguration
extends AbstractAnnotationConfigDispatcherServletInitializer {
    private static final String TMP_FOLDER = "/tmp";
    private static final long MAX_UPLOAD_FILE_SIZE = 0x1400000L;
    private static final long MAX_UPLOAD_TOTAL_SIZE = 0x6400000L;
    private static final int MAX_UPLOAD_THRESHOLD_SIZE = 0x400000;

    protected Class<?>[] getRootConfigClasses() {
        Reflections ref = new Reflections("es.prodevelop.pui9.spring.config", new Scanner[0]);
        Set set = ref.getSubTypesOf(AbstractAppSpringConfiguration.class);
        if (set.isEmpty()) {
            throw new NoClassDefFoundError("No application Config available under package 'es.prodevelop.pui9.spring.config'");
        }
        Optional<Class> opt = set.stream().filter(config -> !Modifier.isAbstract(config.getModifiers()) && !Modifier.isInterface(config.getModifiers())).findFirst();
        if (!opt.isPresent()) {
            throw new NoClassDefFoundError("No assignable application PUI9 Configuration class available under package 'es.prodevelop.pui9.spring.config'");
        }
        return new Class[]{opt.get(), PuiRootSpringConfiguration.class};
    }

    protected Class<?>[] getServletConfigClasses() {
        return Collections.emptyList().toArray(new Class[0]);
    }

    protected String[] getServletMappings() {
        return new String[]{"/*"};
    }

    protected Filter[] getServletFilters() {
        return new Filter[]{new CharacterEncodingFilter(StandardCharsets.UTF_8.name(), true, true)};
    }

    protected void customizeRegistration(ServletRegistration.Dynamic registration) {
        registration.setMultipartConfig(new MultipartConfigElement(TMP_FOLDER, 0x1400000L, 0x6400000L, 0x400000));
    }

    @Bean
    public StandardServletMultipartResolver multipartResolver() {
        return new StandardServletMultipartResolver();
    }
}

