/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.spring.listeners;

import es.prodevelop.pui9.components.PuiApplicationContext;
import es.prodevelop.pui9.messages.AbstractPuiMessages;
import es.prodevelop.pui9.spring.configuration.AbstractAppSpringConfiguration;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.reflections.Reflections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

@Component
public class PuiOnApplicationRefreshListener {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    private AbstractAppSpringConfiguration appConfig;

    @EventListener
    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (!Objects.equals(event.getApplicationContext(), PuiApplicationContext.getInstance().getAppContext())) {
            return;
        }
        this.loadMessages();
        this.logger.info("PUI9 Application context refresh finished");
        this.logger.debug("You can register an *EventListener* for *ContextRefreshedEvent* to perform some initial actions on your application");
    }

    private void loadMessages() {
        ArrayList<String> packageScan = new ArrayList<String>();
        packageScan.add("es.prodevelop");
        ComponentScan componentScan = ClassUtils.getUserClass((Object)this.appConfig).getAnnotation(ComponentScan.class);
        if (componentScan != null) {
            packageScan.addAll(Arrays.asList(componentScan.basePackages()));
        }
        new Reflections(packageScan.toArray()).getSubTypesOf(AbstractPuiMessages.class).forEach(pm -> {
            try {
                pm.getMethod("getSingleton", new Class[0]).invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
        });
    }
}

