/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.pui9;

import es.prodevelop.pui9.model.dto.DtoFactory;
import es.prodevelop.pui9.model.dto.interfaces.IDto;
import jakarta.servlet.ServletRequest;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.annotation.ModelAttributeMethodProcessor;

public class PuiIDtoArgumentResolver
extends ModelAttributeMethodProcessor {
    public PuiIDtoArgumentResolver() {
        super(false);
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return IDto.class.isAssignableFrom(parameter.getParameterType()) && parameter.getParameterType().isInterface();
    }

    protected Object createAttribute(String attributeName, MethodParameter parameter, WebDataBinderFactory binderFactory, NativeWebRequest webRequest) throws Exception {
        MethodParameter nestedParameter = parameter.nestedIfOptional();
        Class clazz = nestedParameter.getNestedParameterType();
        Object attribute = DtoFactory.createInstanceFromInterface((Class)clazz);
        if (parameter != nestedParameter) {
            attribute = Optional.of(attribute);
        }
        return attribute;
    }

    protected void bindRequestParameters(WebDataBinder binder, NativeWebRequest request) {
        ServletRequest servletRequest = (ServletRequest)request.getNativeRequest(ServletRequest.class);
        Assert.state((servletRequest != null ? 1 : 0) != 0, (String)"No ServletRequest");
        ServletRequestDataBinder servletBinder = (ServletRequestDataBinder)binder;
        servletBinder.bind(servletRequest);
    }
}

