/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.pui9;

import com.google.gson.JsonObject;
import es.prodevelop.pui9.components.PuiApplicationContext;
import es.prodevelop.pui9.eventlistener.PuiEventLauncher;
import es.prodevelop.pui9.eventlistener.event.EndpointConsumedEvent;
import es.prodevelop.pui9.eventlistener.event.PuiEvent;
import es.prodevelop.pui9.exceptions.PuiExceptionDto;
import es.prodevelop.pui9.file.FileDownload;
import es.prodevelop.pui9.utils.IPuiObject;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.http.ContentDisposition;
import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.mvc.method.annotation.AbstractMessageConverterMethodProcessor;

public class PuiObjectsMethodProcessor
extends AbstractMessageConverterMethodProcessor {
    private List<Class<?>> supportedTypes = new ArrayList();
    private Map<Class<?>, Boolean> supportedTypeCache;
    private PuiEventLauncher eventLauncher;

    public PuiObjectsMethodProcessor(List<HttpMessageConverter<?>> converters) {
        super(converters);
        this.supportedTypes.add(IPuiObject.class);
        this.supportedTypes.add(Collection.class);
        this.supportedTypes.add(Map.class);
        this.supportedTypes.add(JsonObject.class);
        this.supportedTypeCache = new LinkedHashMap();
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        Class type = returnType.getParameterType();
        if (!this.supportedTypeCache.containsKey(type)) {
            boolean supported = Boolean.FALSE;
            for (Class<?> supportedType : this.supportedTypes) {
                if (!supportedType.isAssignableFrom(type)) continue;
                supported = Boolean.TRUE;
                break;
            }
            if (!supported) {
                supported = BeanUtils.isSimpleProperty((Class)type) || Void.class.equals((Object)type) || Void.TYPE.equals(type);
            }
            this.supportedTypeCache.put(type, supported);
        }
        return this.supportedTypeCache.get(type);
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        mavContainer.setRequestHandled(true);
        ServletServerHttpRequest inputMessage = this.createInputMessage(webRequest);
        ServletServerHttpResponse outputMessage = this.createOutputMessage(webRequest);
        if (returnValue instanceof FileDownload) {
            byte[] content;
            FileDownload fd = (FileDownload)returnValue;
            Optional mimeTypeOptional = MediaTypeFactory.getMediaType((String)fd.getFilename());
            outputMessage.getHeaders().setContentType(mimeTypeOptional.orElse(MediaType.APPLICATION_OCTET_STREAM));
            ContentDisposition cd = fd.getDownloadable() != false ? ContentDisposition.builder((String)"attachment").filename(fd.getFilename()).build() : ContentDisposition.builder((String)"inline").build();
            outputMessage.getHeaders().setContentDisposition(cd);
            try {
                content = fd.getFile() != null ? FileCopyUtils.copyToByteArray((File)fd.getFile()) : (fd.getInputStream() != null ? FileCopyUtils.copyToByteArray((InputStream)fd.getInputStream()) : new byte[]{});
            }
            catch (Exception e) {
                content = new byte[]{};
            }
            outputMessage.getHeaders().setContentLength((long)content.length);
            returnValue = content;
        } else {
            if (returnValue instanceof PuiExceptionDto) {
                PuiExceptionDto ex = (PuiExceptionDto)returnValue;
                outputMessage.getServletResponse().setStatus(ex.getStatusCode());
                outputMessage.getHeaders().setContentType(MediaType.APPLICATION_JSON);
            }
            outputMessage.getHeaders().setAcceptCharset(Collections.singletonList(StandardCharsets.UTF_8));
        }
        inputMessage.getServletRequest().setAttribute("request_output_body", returnValue);
        try {
            this.getPuiEventLauncher().fireAsync((PuiEvent)new EndpointConsumedEvent(inputMessage.getServletRequest()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.writeWithMessageConverters(returnValue, returnType, inputMessage, outputMessage);
        outputMessage.flush();
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return false;
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        return null;
    }

    private PuiEventLauncher getPuiEventLauncher() {
        if (this.eventLauncher == null) {
            this.eventLauncher = (PuiEventLauncher)PuiApplicationContext.getInstance().getBean(PuiEventLauncher.class);
        }
        return this.eventLauncher;
    }
}

