/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.pui9;

import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdviceAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.pui9.PuiObjectsMethodProcessor;

@Component
public class PuiRequestMappingHandlerAdapter
extends RequestMappingHandlerAdapter {
    private List<HttpMessageConverter<?>> converters;

    public PuiRequestMappingHandlerAdapter(List<HttpMessageConverter<?>> converters) {
        this.converters = converters;
    }

    public void afterPropertiesSet() {
        this.setRequestBodyAdvice(Arrays.asList(new RequestBodyAdviceAdapter(){

            public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
                return true;
            }

            public Object afterBodyRead(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
                HttpServletRequest req = PuiRequestMappingHandlerAdapter.this.getCurrentRequest();
                if (req != null) {
                    req.setAttribute("request_input_body", body);
                }
                return body;
            }
        }));
        super.afterPropertiesSet();
        ArrayList<PuiObjectsMethodProcessor> handlers = new ArrayList<PuiObjectsMethodProcessor>();
        handlers.add(new PuiObjectsMethodProcessor(this.converters));
        handlers.addAll(this.getReturnValueHandlers());
        this.setReturnValueHandlers(handlers);
    }

    private HttpServletRequest getCurrentRequest() {
        Optional<HttpServletRequest> opt = Optional.ofNullable(RequestContextHolder.getRequestAttributes()).filter(ServletRequestAttributes.class::isInstance).map(ServletRequestAttributes.class::cast).map(ServletRequestAttributes::getRequest);
        return opt.isPresent() ? opt.get() : null;
    }
}

