/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.pui9;

import es.prodevelop.pui9.annotations.PuiFunctionality;
import es.prodevelop.pui9.annotations.PuiNoSessionRequired;
import es.prodevelop.pui9.annotations.PuiRemoveMapping;
import es.prodevelop.pui9.components.PuiApplicationContext;
import es.prodevelop.pui9.controller.IPuiCommonController;
import es.prodevelop.pui9.mvc.configuration.IPuiRequestMappingHandlerMapping;
import es.prodevelop.pui9.mvc.configuration.PuiControllersInfo;
import es.prodevelop.pui9.spring.configuration.AbstractAppSpringConfiguration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Component
public class PuiRequestMappingHandlerMapping
extends RequestMappingHandlerMapping
implements IPuiRequestMappingHandlerMapping {
    private Map<Class<?>, IPuiCommonController> cacheControllersBeans;
    private Map<String, PuiControllersInfo> mapControllerInfo;
    private Map<Object, Boolean> cacheHandlerSessionRequired = new LinkedHashMap<Object, Boolean>();
    private Map<Object, String> cacheHandlerUserFunctionality = new LinkedHashMap<Object, String>();
    @Autowired
    private AbstractAppSpringConfiguration appConfig;

    protected void initHandlerMethods() {
        this.cacheControllersBeans = new LinkedHashMap();
        super.initHandlerMethods();
        this.cacheControllersBeans.clear();
    }

    public void registerNewMapping(Object handler) {
        this.detectHandlerMethods(handler);
    }

    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        PuiCommonActionEnum action;
        RequestMappingInfo info = super.getMappingForMethod(method, handlerType);
        if (info == null) {
            return info;
        }
        if (this.appConfig.getOverridedPuiControllers().contains(handlerType)) {
            return null;
        }
        if (method.isAnnotationPresent(PuiRemoveMapping.class)) {
            return null;
        }
        if (!IPuiCommonController.class.isAssignableFrom(handlerType)) {
            return info;
        }
        IPuiCommonController beanController = this.cacheControllersBeans.get(handlerType);
        if (beanController == null) {
            try {
                beanController = (IPuiCommonController)handlerType.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.cacheControllersBeans.put(handlerType, beanController);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                return null;
            }
        }
        if ((action = PuiCommonActionEnum.getByName(method.getName())) == null) {
            return info;
        }
        boolean allowAction = false;
        switch (action.ordinal()) {
            case 0: {
                allowAction = beanController.allowGet();
                break;
            }
            case 1: {
                allowAction = beanController.allowTemplate();
                break;
            }
            case 2: {
                allowAction = beanController.allowInsert();
                break;
            }
            case 3: {
                allowAction = beanController.allowUpdate();
                break;
            }
            case 4: {
                allowAction = beanController.allowPatch();
                break;
            }
            case 5: {
                allowAction = beanController.allowDelete();
                break;
            }
            case 6: {
                allowAction = beanController.allowList();
                break;
            }
            case 7: {
                allowAction = beanController.allowListFromTable();
                break;
            }
            case 8: {
                allowAction = beanController.allowExport();
            }
        }
        return allowAction ? info : null;
    }

    public synchronized Map<String, PuiControllersInfo> getUrlsAndFunctionalitiesByController() {
        if (this.mapControllerInfo == null) {
            this.mapControllerInfo = new LinkedHashMap<String, PuiControllersInfo>();
            for (Map.Entry entry : this.getHandlerMethods().entrySet()) {
                String[] parts;
                String path;
                RequestMappingInfo mappingInfo = (RequestMappingInfo)entry.getKey();
                HandlerMethod handlerMethod = (HandlerMethod)entry.getValue();
                if (this.isOpenApiRequest(handlerMethod) || ObjectUtils.isEmpty((Object)(path = (String)mappingInfo.getPatternValues().iterator().next())) || (parts = StringUtils.split((String)path, (String)"/")).length == 0) continue;
                String controller = parts[0];
                String endpoint = null;
                for (int i = parts.length; i > 0 && endpoint == null || endpoint.contains("{"); --i) {
                    endpoint = parts[i - 1];
                }
                if (!this.mapControllerInfo.containsKey(controller)) {
                    this.mapControllerInfo.put(controller, new PuiControllersInfo(controller));
                }
                this.mapControllerInfo.get(controller).addUrl(endpoint, path);
                PuiFunctionality funcAnn = (PuiFunctionality)handlerMethod.getMethodAnnotation(PuiFunctionality.class);
                if (funcAnn == null || this.mapControllerInfo.get(controller).existFunctionality(funcAnn.id())) continue;
                String val = funcAnn.value();
                String functionality = null;
                Class controllerClass = handlerMethod.getBeanType();
                Method funcMethod = null;
                do {
                    try {
                        funcMethod = controllerClass.getDeclaredMethod(val, new Class[0]);
                    }
                    catch (NoSuchMethodException | NullPointerException | SecurityException exception) {
                        // empty catch block
                    }
                } while (funcMethod == null && (controllerClass = controllerClass.getSuperclass()) != null);
                if (funcMethod != null) {
                    try {
                        funcMethod.setAccessible(true);
                        Object controllerObj = handlerMethod.getBean();
                        Object object = handlerMethod.getBean();
                        if (object instanceof String) {
                            String bean = (String)object;
                            controllerObj = PuiApplicationContext.getInstance().getAppContext().getBean(bean);
                        }
                        if ((functionality = (String)funcMethod.invoke(controllerObj, new Object[0])) == null) {
                            functionality = "";
                        }
                        funcMethod.setAccessible(false);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        continue;
                    }
                }
                if (functionality == null) {
                    functionality = val;
                }
                this.mapControllerInfo.get(controller).addFunctionality(funcAnn.id(), functionality);
            }
        }
        return this.mapControllerInfo;
    }

    public boolean isWebServiceSecured(Object handler) {
        return this.isWebServiceSessionRequired(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWebServiceSessionRequired(Object handler) {
        HandlerMethod hm;
        if (handler instanceof HandlerMethod && this.isOpenApiRequest(hm = (HandlerMethod)handler)) {
            return false;
        }
        Map<Object, Boolean> map = this.cacheHandlerSessionRequired;
        synchronized (map) {
            if (!this.cacheHandlerSessionRequired.containsKey(handler)) {
                if (!(handler instanceof HandlerMethod)) {
                    this.cacheHandlerSessionRequired.put(handler, false);
                } else {
                    HandlerMethod hm2 = (HandlerMethod)handler;
                    Method method = hm2.getMethod();
                    PuiNoSessionRequired annotation = method.getAnnotation(PuiNoSessionRequired.class);
                    if (annotation != null) {
                        this.cacheHandlerSessionRequired.put(hm2, false);
                    } else {
                        for (Class clazz = hm2.getBeanType(); clazz != null; clazz = clazz.getSuperclass()) {
                            annotation = clazz.getAnnotation(PuiNoSessionRequired.class);
                            if (annotation == null) continue;
                            this.cacheHandlerSessionRequired.put(hm2, false);
                            break;
                        }
                        if (!this.cacheHandlerSessionRequired.containsKey(hm2)) {
                            this.cacheHandlerSessionRequired.put(hm2, true);
                        }
                    }
                }
            }
        }
        return this.cacheHandlerSessionRequired.get(handler);
    }

    public synchronized String getWebServiceFunctionality(Object handler) {
        if (!this.cacheHandlerUserFunctionality.containsKey(handler)) {
            if (!(handler instanceof HandlerMethod)) {
                this.cacheHandlerUserFunctionality.put(handler, null);
            } else {
                HandlerMethod hm = (HandlerMethod)handler;
                Method method = hm.getMethod();
                PuiFunctionality puiFunctionality = method.getAnnotation(PuiFunctionality.class);
                if (puiFunctionality == null) {
                    this.cacheHandlerUserFunctionality.put(hm, null);
                } else if (!puiFunctionality.check()) {
                    this.cacheHandlerUserFunctionality.put(hm, null);
                } else {
                    String functionality = puiFunctionality.value();
                    Class<?> clazz = method.getDeclaringClass();
                    Method funcMethod = null;
                    do {
                        try {
                            funcMethod = clazz.getDeclaredMethod(functionality, new Class[0]);
                        }
                        catch (NoSuchMethodException | NullPointerException | SecurityException exception) {
                            // empty catch block
                        }
                    } while (funcMethod == null && (clazz = clazz.getSuperclass()) != null);
                    if (funcMethod != null) {
                        try {
                            funcMethod.setAccessible(true);
                            functionality = (String)funcMethod.invoke(hm.getBean(), new Object[0]);
                            funcMethod.setAccessible(false);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                            functionality = null;
                        }
                    }
                    this.cacheHandlerUserFunctionality.put(hm, functionality);
                }
            }
        }
        return this.cacheHandlerUserFunctionality.get(handler);
    }

    private boolean isOpenApiRequest(HandlerMethod handlerMethod) {
        return handlerMethod.getBeanType().getName().contains("org.springdoc");
    }

    private static enum PuiCommonActionEnum {
        get,
        template,
        insert,
        update,
        patch,
        delete,
        list,
        listFromTable,
        export;


        public static PuiCommonActionEnum getByName(String name) {
            if (ObjectUtils.isEmpty((Object)name)) {
                return null;
            }
            for (PuiCommonActionEnum e : PuiCommonActionEnum.values()) {
                if (!e.name().equals(name)) continue;
                return e;
            }
            return null;
        }
    }
}

