/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.classpath;

import es.prodevelop.pui9.classpath.IClasspathFinder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class PuiClasspathFinderRegistry {
    private static PuiClasspathFinderRegistry instance;
    private List<IClasspathFinder> classpathFinders = new ArrayList<IClasspathFinder>();

    public static PuiClasspathFinderRegistry getInstance() {
        if (instance == null) {
            instance = new PuiClasspathFinderRegistry();
        }
        return instance;
    }

    private PuiClasspathFinderRegistry() {
    }

    public List<File> getClasspath() {
        if (this.classpathFinders.isEmpty()) {
            Set set = new Reflections("es.prodevelop.pui9", new Scanner[0]).getSubTypesOf(IClasspathFinder.class);
            for (Class clazz : set) {
                try {
                    IClasspathFinder cpf = (IClasspathFinder)clazz.newInstance();
                    this.classpathFinders.add(cpf);
                }
                catch (IllegalAccessException | InstantiationException reflectiveOperationException) {}
            }
        }
        for (IClasspathFinder finder : this.classpathFinders) {
            List<File> list = finder.getClasspath();
            if (list == null || list.isEmpty()) continue;
            return list;
        }
        return Collections.emptyList();
    }
}

