/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.HashMap;

public class CsvReader {
    public static final int ESCAPE_MODE_DOUBLED = 1;
    public static final int ESCAPE_MODE_BACKSLASH = 2;
    private Reader inputStream;
    private UserSettings userSettings;
    private boolean useCustomRecordDelimiter;
    private DataBuffer dataBuffer;
    private ColumnBuffer columnBuffer;
    private RawRecordBuffer rawBuffer;
    private boolean[] isQualified;
    private String rawRecord;
    private HeadersHolder headersHolder;
    private boolean startedColumn;
    private boolean startedWithQualifier;
    private boolean hasMoreData;
    private char lastLetter;
    private boolean hasReadNextLine;
    private int columnsCount;
    private long currentRecord;
    private String[] values;
    private boolean closed;

    public CsvReader(String fileName, char delimiter, Charset charset) throws FileNotFoundException {
        if (fileName == null) {
            throw new IllegalArgumentException("Parameter fileName can not be null.");
        }
        if (charset == null) {
            throw new IllegalArgumentException("Parameter charset can not be null.");
        }
        if (!new File(fileName).exists()) {
            throw new FileNotFoundException("File " + fileName + " does not exist.");
        }
        this.inputStream = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), charset), 4096);
        this.init(delimiter);
    }

    public CsvReader(String fileName, char delimiter) throws FileNotFoundException {
        this(fileName, delimiter, StandardCharsets.UTF_8);
    }

    public CsvReader(String fileName) throws FileNotFoundException {
        this(fileName, Letters.SEMICOLON.code);
    }

    public CsvReader(Reader inputStream, char delimiter) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Parameter inputStream can not be null.");
        }
        this.inputStream = inputStream;
        this.init(delimiter);
    }

    public CsvReader(Reader inputStream) {
        this(inputStream, Letters.SEMICOLON.code);
    }

    public CsvReader(InputStream inputStream, char delimiter, Charset charset) {
        this(new InputStreamReader(inputStream, charset), delimiter);
    }

    public CsvReader(InputStream inputStream, Charset charset) {
        this(new InputStreamReader(inputStream, charset));
    }

    public CsvReader(InputStream inputStream, Charset charset, boolean guessSeparator) {
        this(new InputStreamReader(inputStream, charset));
        if (guessSeparator) {
            Letters delimiter = null;
            try {
                this.readHeaders();
                if (this.getHeaderCount() == 0) {
                    return;
                }
                for (Letters letter : Letters.values()) {
                    if (this.getHeaders()[0].indexOf(letter.code) < 0) continue;
                    delimiter = letter;
                    break;
                }
                if (delimiter == null) {
                    delimiter = Letters.SEMICOLON;
                }
                this.close();
                inputStream.reset();
                this.inputStream = new InputStreamReader(inputStream, charset);
                this.init(delimiter.code);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void init(char delimiter) {
        this.userSettings = new UserSettings();
        this.useCustomRecordDelimiter = false;
        this.dataBuffer = new DataBuffer();
        this.columnBuffer = new ColumnBuffer();
        this.rawBuffer = new RawRecordBuffer();
        this.rawRecord = "";
        this.headersHolder = new HeadersHolder();
        this.startedColumn = false;
        this.startedWithQualifier = false;
        this.hasMoreData = true;
        this.lastLetter = '\u0000';
        this.hasReadNextLine = false;
        this.columnsCount = 0;
        this.currentRecord = 0L;
        this.values = new String[10];
        this.isQualified = new boolean[this.values.length];
        this.closed = false;
        this.userSettings.Delimiter = delimiter;
    }

    public boolean getCaptureRawRecord() {
        return this.userSettings.CaptureRawRecord;
    }

    public void setCaptureRawRecord(boolean captureRawRecord) {
        this.userSettings.CaptureRawRecord = captureRawRecord;
    }

    public String getRawRecord() {
        return this.rawRecord;
    }

    public boolean getTrimWhitespace() {
        return this.userSettings.TrimWhitespace;
    }

    public void setTrimWhitespace(boolean trimWhitespace) {
        this.userSettings.TrimWhitespace = trimWhitespace;
    }

    public char getDelimiter() {
        return this.userSettings.Delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.userSettings.Delimiter = delimiter;
    }

    public char getRecordDelimiter() {
        return this.userSettings.RecordDelimiter;
    }

    public void setRecordDelimiter(char recordDelimiter) {
        this.useCustomRecordDelimiter = true;
        this.userSettings.RecordDelimiter = recordDelimiter;
    }

    public char getTextQualifier() {
        return this.userSettings.TextQualifier;
    }

    public void setTextQualifier(char textQualifier) {
        this.userSettings.TextQualifier = textQualifier;
    }

    public boolean getUseTextQualifier() {
        return this.userSettings.UseTextQualifier;
    }

    public void setUseTextQualifier(boolean useTextQualifier) {
        this.userSettings.UseTextQualifier = useTextQualifier;
    }

    public char getComment() {
        return this.userSettings.Comment;
    }

    public void setComment(char comment) {
        this.userSettings.Comment = comment;
    }

    public boolean getUseComments() {
        return this.userSettings.UseComments;
    }

    public void setUseComments(boolean useComments) {
        this.userSettings.UseComments = useComments;
    }

    public int getEscapeMode() {
        return this.userSettings.EscapeMode;
    }

    public void setEscapeMode(int escapeMode) throws IllegalArgumentException {
        if (escapeMode != 1 && escapeMode != 2) {
            throw new IllegalArgumentException("Parameter escapeMode must be a valid value.");
        }
        this.userSettings.EscapeMode = escapeMode;
    }

    public boolean getSkipEmptyRecords() {
        return this.userSettings.SkipEmptyRecords;
    }

    public void setSkipEmptyRecords(boolean skipEmptyRecords) {
        this.userSettings.SkipEmptyRecords = skipEmptyRecords;
    }

    public boolean getSafetySwitch() {
        return this.userSettings.SafetySwitch;
    }

    public void setSafetySwitch(boolean safetySwitch) {
        this.userSettings.SafetySwitch = safetySwitch;
    }

    public int getColumnCount() {
        return this.columnsCount;
    }

    public long getCurrentRecord() {
        return this.currentRecord - 1L;
    }

    public int getHeaderCount() {
        return this.headersHolder.Length;
    }

    public String[] getHeaders() throws IOException {
        this.checkClosed();
        if (this.headersHolder.Headers == null) {
            return null;
        }
        String[] clone = new String[this.headersHolder.Length];
        System.arraycopy(this.headersHolder.Headers, 0, clone, 0, this.headersHolder.Length);
        return clone;
    }

    public void setHeaders(String[] headers) {
        this.headersHolder.Headers = headers;
        this.headersHolder.IndexByName.clear();
        this.headersHolder.Length = headers != null ? headers.length : 0;
        for (int i = 0; i < this.headersHolder.Length; ++i) {
            this.headersHolder.IndexByName.put(headers[i], new Integer(i));
        }
    }

    public String[] getValues() throws IOException {
        this.checkClosed();
        String[] clone = new String[this.columnsCount];
        System.arraycopy(this.values, 0, clone, 0, this.columnsCount);
        return clone;
    }

    public String get(int columnIndex) throws IOException {
        this.checkClosed();
        if (columnIndex > -1 && columnIndex < this.columnsCount) {
            return this.values[columnIndex];
        }
        return "";
    }

    public String get(String headerName) throws IOException {
        this.checkClosed();
        return this.get(this.getIndex(headerName));
    }

    public static CsvReader parse(String data) {
        if (data == null) {
            throw new IllegalArgumentException("Parameter data can not be null.");
        }
        return new CsvReader(new StringReader(data));
    }

    public boolean readRecord() throws IOException {
        this.checkClosed();
        this.columnsCount = 0;
        this.rawBuffer.Position = 0;
        this.dataBuffer.LineStart = this.dataBuffer.Position;
        this.hasReadNextLine = false;
        if (this.hasMoreData) {
            do {
                if (this.dataBuffer.Position == this.dataBuffer.Count) {
                    this.checkDataLength();
                    continue;
                }
                this.startedWithQualifier = false;
                char currentLetter = this.dataBuffer.Buffer[this.dataBuffer.Position];
                if (this.userSettings.UseTextQualifier && currentLetter == this.userSettings.TextQualifier) {
                    this.lastLetter = currentLetter;
                    this.startedColumn = true;
                    this.dataBuffer.ColumnStart = this.dataBuffer.Position + 1;
                    this.startedWithQualifier = true;
                    boolean lastLetterWasQualifier = false;
                    char escapeChar = this.userSettings.TextQualifier;
                    if (this.userSettings.EscapeMode == 2) {
                        escapeChar = Letters.BACKSLASH.code;
                    }
                    boolean eatingTrailingJunk = false;
                    boolean lastLetterWasEscape = false;
                    boolean readingComplexEscape = false;
                    int escape = 1;
                    int escapeLength = 0;
                    char escapeValue = '\u0000';
                    ++this.dataBuffer.Position;
                    do {
                        if (this.dataBuffer.Position == this.dataBuffer.Count) {
                            this.checkDataLength();
                            continue;
                        }
                        currentLetter = this.dataBuffer.Buffer[this.dataBuffer.Position];
                        if (eatingTrailingJunk) {
                            this.dataBuffer.ColumnStart = this.dataBuffer.Position + 1;
                            if (currentLetter == this.userSettings.Delimiter) {
                                this.endColumn();
                            } else if (!this.useCustomRecordDelimiter && (currentLetter == Letters.CR.code || currentLetter == Letters.LF.code) || this.useCustomRecordDelimiter && currentLetter == this.userSettings.RecordDelimiter) {
                                this.endColumn();
                                this.endRecord();
                            }
                        } else if (readingComplexEscape) {
                            ++escapeLength;
                            switch (escape) {
                                case 1: {
                                    escapeValue = (char)(escapeValue * 16);
                                    escapeValue = (char)(escapeValue + CsvReader.hexToDec(currentLetter));
                                    if (escapeLength != 4) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                                case 2: {
                                    escapeValue = (char)(escapeValue * 8);
                                    escapeValue = (char)(escapeValue + (char)(currentLetter - 48));
                                    if (escapeLength != 3) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                                case 3: {
                                    escapeValue = (char)(escapeValue * 10);
                                    escapeValue = (char)(escapeValue + (char)(currentLetter - 48));
                                    if (escapeLength != 3) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                                case 4: {
                                    escapeValue = (char)(escapeValue * 16);
                                    escapeValue = (char)(escapeValue + CsvReader.hexToDec(currentLetter));
                                    if (escapeLength != 2) break;
                                    readingComplexEscape = false;
                                }
                            }
                            if (!readingComplexEscape) {
                                this.appendLetter(escapeValue);
                            } else {
                                this.dataBuffer.ColumnStart = this.dataBuffer.Position + 1;
                            }
                        } else if (currentLetter == this.userSettings.TextQualifier) {
                            if (lastLetterWasEscape) {
                                lastLetterWasEscape = false;
                                lastLetterWasQualifier = false;
                            } else {
                                this.updateCurrentValue();
                                if (this.userSettings.EscapeMode == 1) {
                                    lastLetterWasEscape = true;
                                }
                                lastLetterWasQualifier = true;
                            }
                        } else if (this.userSettings.EscapeMode == 2 && lastLetterWasEscape) {
                            switch (currentLetter) {
                                case 'n': {
                                    this.appendLetter(Letters.LF.code);
                                    break;
                                }
                                case 'r': {
                                    this.appendLetter(Letters.CR.code);
                                    break;
                                }
                                case 't': {
                                    this.appendLetter(Letters.TAB.code);
                                    break;
                                }
                                case 'b': {
                                    this.appendLetter(Letters.BACKSPACE.code);
                                    break;
                                }
                                case 'f': {
                                    this.appendLetter(Letters.FORM_FEED.code);
                                    break;
                                }
                                case 'e': {
                                    this.appendLetter(Letters.ESCAPE.code);
                                    break;
                                }
                                case 'v': {
                                    this.appendLetter(Letters.VERTICAL_TAB.code);
                                    break;
                                }
                                case 'a': {
                                    this.appendLetter(Letters.ALERT.code);
                                    break;
                                }
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': {
                                    escape = 2;
                                    readingComplexEscape = true;
                                    escapeLength = 1;
                                    escapeValue = (char)(currentLetter - 48);
                                    this.dataBuffer.ColumnStart = this.dataBuffer.Position + 1;
                                    break;
                                }
                                case 'D': 
                                case 'O': 
                                case 'U': 
                                case 'X': 
                                case 'd': 
                                case 'o': 
                                case 'u': 
                                case 'x': {
                                    switch (currentLetter) {
                                        case 'U': 
                                        case 'u': {
                                            escape = 1;
                                            break;
                                        }
                                        case 'X': 
                                        case 'x': {
                                            escape = 4;
                                            break;
                                        }
                                        case 'O': 
                                        case 'o': {
                                            escape = 2;
                                            break;
                                        }
                                        case 'D': 
                                        case 'd': {
                                            escape = 3;
                                        }
                                    }
                                    readingComplexEscape = true;
                                    escapeLength = 0;
                                    escapeValue = '\u0000';
                                    this.dataBuffer.ColumnStart = this.dataBuffer.Position + 1;
                                    break;
                                }
                            }
                            lastLetterWasEscape = false;
                        } else if (currentLetter == escapeChar) {
                            this.updateCurrentValue();
                            lastLetterWasEscape = true;
                        } else if (lastLetterWasQualifier) {
                            if (currentLetter == this.userSettings.Delimiter) {
                                this.endColumn();
                            } else if (!this.useCustomRecordDelimiter && (currentLetter == Letters.CR.code || currentLetter == Letters.LF.code) || this.useCustomRecordDelimiter && currentLetter == this.userSettings.RecordDelimiter) {
                                this.endColumn();
                                this.endRecord();
                            } else {
                                this.dataBuffer.ColumnStart = this.dataBuffer.Position + 1;
                                eatingTrailingJunk = true;
                            }
                            lastLetterWasQualifier = false;
                        }
                        this.lastLetter = currentLetter;
                        if (!this.startedColumn) continue;
                        ++this.dataBuffer.Position;
                        if (!this.userSettings.SafetySwitch || this.dataBuffer.Position - this.dataBuffer.ColumnStart + this.columnBuffer.Position <= 100000) continue;
                        this.close();
                        throw new IOException("Maximum column length of 100,000 exceeded in column " + NumberFormat.getIntegerInstance().format(this.columnsCount) + " in record " + NumberFormat.getIntegerInstance().format(this.currentRecord) + ". Set the SafetySwitch property to false if you're expecting column lengths greater than 100,000 characters to avoid this error.");
                    } while (this.hasMoreData && this.startedColumn);
                } else if (currentLetter == this.userSettings.Delimiter) {
                    this.lastLetter = currentLetter;
                    this.endColumn();
                } else if (this.useCustomRecordDelimiter && currentLetter == this.userSettings.RecordDelimiter) {
                    if (this.startedColumn || this.columnsCount > 0 || !this.userSettings.SkipEmptyRecords) {
                        this.endColumn();
                        this.endRecord();
                    } else {
                        this.dataBuffer.LineStart = this.dataBuffer.Position + 1;
                    }
                    this.lastLetter = currentLetter;
                } else if (!(this.useCustomRecordDelimiter || currentLetter != Letters.CR.code && currentLetter != Letters.LF.code)) {
                    if (this.startedColumn || this.columnsCount > 0 || !this.userSettings.SkipEmptyRecords && (currentLetter == Letters.CR.code || this.lastLetter != Letters.CR.code)) {
                        this.endColumn();
                        this.endRecord();
                    } else {
                        this.dataBuffer.LineStart = this.dataBuffer.Position + 1;
                    }
                    this.lastLetter = currentLetter;
                } else if (this.userSettings.UseComments && this.columnsCount == 0 && currentLetter == this.userSettings.Comment) {
                    this.lastLetter = currentLetter;
                    this.skipLine();
                } else if (this.userSettings.TrimWhitespace && (currentLetter == Letters.SPACE.code || currentLetter == Letters.TAB.code)) {
                    this.startedColumn = true;
                    this.dataBuffer.ColumnStart = this.dataBuffer.Position + 1;
                } else {
                    this.startedColumn = true;
                    this.dataBuffer.ColumnStart = this.dataBuffer.Position;
                    boolean lastLetterWasBackslash = false;
                    boolean readingComplexEscape = false;
                    int escape = 1;
                    int escapeLength = 0;
                    char escapeValue = '\u0000';
                    boolean firstLoop = true;
                    do {
                        if (!firstLoop && this.dataBuffer.Position == this.dataBuffer.Count) {
                            this.checkDataLength();
                            continue;
                        }
                        if (!firstLoop) {
                            currentLetter = this.dataBuffer.Buffer[this.dataBuffer.Position];
                        }
                        if (!this.userSettings.UseTextQualifier && this.userSettings.EscapeMode == 2 && currentLetter == Letters.BACKSLASH.code) {
                            if (lastLetterWasBackslash) {
                                lastLetterWasBackslash = false;
                            } else {
                                this.updateCurrentValue();
                                lastLetterWasBackslash = true;
                            }
                        } else if (readingComplexEscape) {
                            ++escapeLength;
                            switch (escape) {
                                case 1: {
                                    escapeValue = (char)(escapeValue * 16);
                                    escapeValue = (char)(escapeValue + CsvReader.hexToDec(currentLetter));
                                    if (escapeLength != 4) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                                case 2: {
                                    escapeValue = (char)(escapeValue * 8);
                                    escapeValue = (char)(escapeValue + (char)(currentLetter - 48));
                                    if (escapeLength != 3) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                                case 3: {
                                    escapeValue = (char)(escapeValue * 10);
                                    escapeValue = (char)(escapeValue + (char)(currentLetter - 48));
                                    if (escapeLength != 3) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                                case 4: {
                                    escapeValue = (char)(escapeValue * 16);
                                    escapeValue = (char)(escapeValue + CsvReader.hexToDec(currentLetter));
                                    if (escapeLength != 2) break;
                                    readingComplexEscape = false;
                                }
                            }
                            if (!readingComplexEscape) {
                                this.appendLetter(escapeValue);
                            } else {
                                this.dataBuffer.ColumnStart = this.dataBuffer.Position + 1;
                            }
                        } else if (this.userSettings.EscapeMode == 2 && lastLetterWasBackslash) {
                            switch (currentLetter) {
                                case 'n': {
                                    this.appendLetter(Letters.LF.code);
                                    break;
                                }
                                case 'r': {
                                    this.appendLetter(Letters.CR.code);
                                    break;
                                }
                                case 't': {
                                    this.appendLetter(Letters.TAB.code);
                                    break;
                                }
                                case 'b': {
                                    this.appendLetter(Letters.BACKSPACE.code);
                                    break;
                                }
                                case 'f': {
                                    this.appendLetter(Letters.FORM_FEED.code);
                                    break;
                                }
                                case 'e': {
                                    this.appendLetter(Letters.ESCAPE.code);
                                    break;
                                }
                                case 'v': {
                                    this.appendLetter(Letters.VERTICAL_TAB.code);
                                    break;
                                }
                                case 'a': {
                                    this.appendLetter(Letters.ALERT.code);
                                    break;
                                }
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': {
                                    escape = 2;
                                    readingComplexEscape = true;
                                    escapeLength = 1;
                                    escapeValue = (char)(currentLetter - 48);
                                    this.dataBuffer.ColumnStart = this.dataBuffer.Position + 1;
                                    break;
                                }
                                case 'D': 
                                case 'O': 
                                case 'U': 
                                case 'X': 
                                case 'd': 
                                case 'o': 
                                case 'u': 
                                case 'x': {
                                    switch (currentLetter) {
                                        case 'U': 
                                        case 'u': {
                                            escape = 1;
                                            break;
                                        }
                                        case 'X': 
                                        case 'x': {
                                            escape = 4;
                                            break;
                                        }
                                        case 'O': 
                                        case 'o': {
                                            escape = 2;
                                            break;
                                        }
                                        case 'D': 
                                        case 'd': {
                                            escape = 3;
                                        }
                                    }
                                    readingComplexEscape = true;
                                    escapeLength = 0;
                                    escapeValue = '\u0000';
                                    this.dataBuffer.ColumnStart = this.dataBuffer.Position + 1;
                                    break;
                                }
                            }
                            lastLetterWasBackslash = false;
                        } else if (currentLetter == this.userSettings.Delimiter) {
                            this.endColumn();
                        } else if (!this.useCustomRecordDelimiter && (currentLetter == Letters.CR.code || currentLetter == Letters.LF.code) || this.useCustomRecordDelimiter && currentLetter == this.userSettings.RecordDelimiter) {
                            this.endColumn();
                            this.endRecord();
                        }
                        this.lastLetter = currentLetter;
                        firstLoop = false;
                        if (!this.startedColumn) continue;
                        ++this.dataBuffer.Position;
                        if (!this.userSettings.SafetySwitch || this.dataBuffer.Position - this.dataBuffer.ColumnStart + this.columnBuffer.Position <= 100000) continue;
                        this.close();
                        throw new IOException("Maximum column length of 100,000 exceeded in column " + NumberFormat.getIntegerInstance().format(this.columnsCount) + " in record " + NumberFormat.getIntegerInstance().format(this.currentRecord) + ". Set the SafetySwitch property to false if you're expecting column lengths greater than 100,000 characters to avoid this error.");
                    } while (this.hasMoreData && this.startedColumn);
                }
                if (!this.hasMoreData) continue;
                ++this.dataBuffer.Position;
            } while (this.hasMoreData && !this.hasReadNextLine);
            if (this.startedColumn || this.lastLetter == this.userSettings.Delimiter) {
                this.endColumn();
                this.endRecord();
            }
        }
        this.rawRecord = this.userSettings.CaptureRawRecord ? (this.hasMoreData ? (this.rawBuffer.Position == 0 ? new String(this.dataBuffer.Buffer, this.dataBuffer.LineStart, this.dataBuffer.Position - this.dataBuffer.LineStart - 1) : new String(this.rawBuffer.Buffer, 0, this.rawBuffer.Position) + new String(this.dataBuffer.Buffer, this.dataBuffer.LineStart, this.dataBuffer.Position - this.dataBuffer.LineStart - 1)) : new String(this.rawBuffer.Buffer, 0, this.rawBuffer.Position)) : "";
        return this.hasReadNextLine;
    }

    private void checkDataLength() throws IOException {
        this.updateCurrentValue();
        if (this.userSettings.CaptureRawRecord && this.dataBuffer.Count > 0) {
            if (this.rawBuffer.Buffer.length - this.rawBuffer.Position < this.dataBuffer.Count - this.dataBuffer.LineStart) {
                int newLength = this.rawBuffer.Buffer.length + Math.max(this.dataBuffer.Count - this.dataBuffer.LineStart, this.rawBuffer.Buffer.length);
                char[] holder = new char[newLength];
                System.arraycopy(this.rawBuffer.Buffer, 0, holder, 0, this.rawBuffer.Position);
                this.rawBuffer.Buffer = holder;
            }
            System.arraycopy(this.dataBuffer.Buffer, this.dataBuffer.LineStart, this.rawBuffer.Buffer, this.rawBuffer.Position, this.dataBuffer.Count - this.dataBuffer.LineStart);
            this.rawBuffer.Position += this.dataBuffer.Count - this.dataBuffer.LineStart;
        }
        try {
            this.dataBuffer.Count = this.inputStream.read(this.dataBuffer.Buffer, 0, this.dataBuffer.Buffer.length);
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
        if (this.dataBuffer.Count == -1) {
            this.hasMoreData = false;
        }
        this.dataBuffer.Position = 0;
        this.dataBuffer.LineStart = 0;
        this.dataBuffer.ColumnStart = 0;
    }

    public boolean readHeaders() throws IOException {
        boolean result = this.readRecord();
        this.headersHolder.Length = this.columnsCount;
        this.headersHolder.Headers = new String[this.columnsCount];
        for (int i = 0; i < this.headersHolder.Length; ++i) {
            String columnValue;
            this.headersHolder.Headers[i] = columnValue = this.get(i);
            this.headersHolder.IndexByName.put(columnValue, new Integer(i));
        }
        if (result) {
            --this.currentRecord;
        }
        this.columnsCount = 0;
        return result;
    }

    public String getHeader(int columnIndex) throws IOException {
        this.checkClosed();
        if (columnIndex > -1 && columnIndex < this.headersHolder.Length) {
            return this.headersHolder.Headers[columnIndex];
        }
        return "";
    }

    public boolean isQualified(int columnIndex) throws IOException {
        this.checkClosed();
        if (columnIndex < this.columnsCount && columnIndex > -1) {
            return this.isQualified[columnIndex];
        }
        return false;
    }

    private void endColumn() throws IOException {
        String currentValue = "";
        if (this.startedColumn) {
            int lastLetter;
            if (this.columnBuffer.Position == 0) {
                if (this.dataBuffer.ColumnStart < this.dataBuffer.Position) {
                    if (this.userSettings.TrimWhitespace && !this.startedWithQualifier) {
                        for (lastLetter = this.dataBuffer.Position - 1; lastLetter >= this.dataBuffer.ColumnStart && (this.dataBuffer.Buffer[lastLetter] == Letters.SPACE.code || this.dataBuffer.Buffer[lastLetter] == Letters.TAB.code); --lastLetter) {
                        }
                    }
                    currentValue = new String(this.dataBuffer.Buffer, this.dataBuffer.ColumnStart, lastLetter - this.dataBuffer.ColumnStart + 1);
                }
            } else {
                this.updateCurrentValue();
                if (this.userSettings.TrimWhitespace && !this.startedWithQualifier) {
                    for (lastLetter = this.columnBuffer.Position - 1; lastLetter >= 0 && (this.columnBuffer.Buffer[lastLetter] == Letters.SPACE.code || this.columnBuffer.Buffer[lastLetter] == Letters.SPACE.code); --lastLetter) {
                    }
                }
                currentValue = new String(this.columnBuffer.Buffer, 0, lastLetter + 1);
            }
        }
        this.columnBuffer.Position = 0;
        this.startedColumn = false;
        if (this.columnsCount >= 100000 && this.userSettings.SafetySwitch) {
            this.close();
            throw new IOException("Maximum column count of 100,000 exceeded in record " + NumberFormat.getIntegerInstance().format(this.currentRecord) + ". Set the SafetySwitch property to false if you're expecting more than 100,000 columns per record to avoid this error.");
        }
        if (this.columnsCount == this.values.length) {
            int newLength = this.values.length * 2;
            String[] holder = new String[newLength];
            System.arraycopy(this.values, 0, holder, 0, this.values.length);
            this.values = holder;
            boolean[] qualifiedHolder = new boolean[newLength];
            System.arraycopy(this.isQualified, 0, qualifiedHolder, 0, this.isQualified.length);
            this.isQualified = qualifiedHolder;
        }
        this.values[this.columnsCount] = currentValue;
        this.isQualified[this.columnsCount] = this.startedWithQualifier;
        currentValue = "";
        ++this.columnsCount;
    }

    private void appendLetter(char letter) {
        if (this.columnBuffer.Position == this.columnBuffer.Buffer.length) {
            int newLength = this.columnBuffer.Buffer.length * 2;
            char[] holder = new char[newLength];
            System.arraycopy(this.columnBuffer.Buffer, 0, holder, 0, this.columnBuffer.Position);
            this.columnBuffer.Buffer = holder;
        }
        this.columnBuffer.Buffer[this.columnBuffer.Position++] = letter;
        this.dataBuffer.ColumnStart = this.dataBuffer.Position + 1;
    }

    private void updateCurrentValue() {
        if (this.startedColumn && this.dataBuffer.ColumnStart < this.dataBuffer.Position) {
            if (this.columnBuffer.Buffer.length - this.columnBuffer.Position < this.dataBuffer.Position - this.dataBuffer.ColumnStart) {
                int newLength = this.columnBuffer.Buffer.length + Math.max(this.dataBuffer.Position - this.dataBuffer.ColumnStart, this.columnBuffer.Buffer.length);
                char[] holder = new char[newLength];
                System.arraycopy(this.columnBuffer.Buffer, 0, holder, 0, this.columnBuffer.Position);
                this.columnBuffer.Buffer = holder;
            }
            System.arraycopy(this.dataBuffer.Buffer, this.dataBuffer.ColumnStart, this.columnBuffer.Buffer, this.columnBuffer.Position, this.dataBuffer.Position - this.dataBuffer.ColumnStart);
            this.columnBuffer.Position += this.dataBuffer.Position - this.dataBuffer.ColumnStart;
        }
        this.dataBuffer.ColumnStart = this.dataBuffer.Position + 1;
    }

    private void endRecord() throws IOException {
        this.hasReadNextLine = true;
        ++this.currentRecord;
    }

    public int getIndex(String headerName) throws IOException {
        this.checkClosed();
        Integer indexValue = this.headersHolder.IndexByName.get(headerName);
        if (indexValue != null) {
            return indexValue;
        }
        return -1;
    }

    public boolean skipRecord() throws IOException {
        this.checkClosed();
        boolean recordRead = false;
        if (this.hasMoreData && (recordRead = this.readRecord())) {
            --this.currentRecord;
        }
        return recordRead;
    }

    public boolean skipLine() throws IOException {
        this.checkClosed();
        this.columnsCount = 0;
        boolean skippedLine = false;
        if (this.hasMoreData) {
            boolean foundEol = false;
            do {
                if (this.dataBuffer.Position == this.dataBuffer.Count) {
                    this.checkDataLength();
                    continue;
                }
                skippedLine = true;
                char currentLetter = this.dataBuffer.Buffer[this.dataBuffer.Position];
                if (currentLetter == Letters.CR.code || currentLetter == Letters.LF.code) {
                    foundEol = true;
                }
                this.lastLetter = currentLetter;
                if (foundEol) continue;
                ++this.dataBuffer.Position;
            } while (this.hasMoreData && !foundEol);
            this.columnBuffer.Position = 0;
            this.dataBuffer.LineStart = this.dataBuffer.Position + 1;
        }
        this.rawBuffer.Position = 0;
        this.rawRecord = "";
        return skippedLine;
    }

    public void close() {
        if (!this.closed) {
            this.close(true);
            this.closed = true;
        }
    }

    private void close(boolean closing) {
        if (!this.closed) {
            if (closing) {
                this.headersHolder.Headers = null;
                this.headersHolder.IndexByName = null;
                this.dataBuffer.Buffer = null;
                this.columnBuffer.Buffer = null;
                this.rawBuffer.Buffer = null;
            }
            try {
                this.inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.inputStream = null;
            this.closed = true;
        }
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("This instance of the CsvReader class has already been closed.");
        }
    }

    protected void finalize() {
        this.close(false);
    }

    private static char hexToDec(char hex) {
        char result = hex >= 'a' ? (char)(hex - 97 + 10) : (hex >= 'A' ? (char)(hex - 65 + 10) : (char)(hex - 48));
        return result;
    }

    private class StaticSettings {
        public static final int MAX_BUFFER_SIZE = 1024;
        public static final int MAX_FILE_BUFFER_SIZE = 4096;
        public static final int INITIAL_COLUMN_COUNT = 10;
        public static final int INITIAL_COLUMN_BUFFER_SIZE = 50;

        private StaticSettings() {
        }
    }

    private class HeadersHolder {
        public String[] Headers = null;
        public int Length = 0;
        public HashMap<String, Integer> IndexByName = new HashMap();
    }

    private class UserSettings {
        public char TextQualifier;
        public boolean TrimWhitespace;
        public boolean UseTextQualifier;
        public char Delimiter;
        public char RecordDelimiter;
        public char Comment;
        public boolean UseComments;
        public int EscapeMode;
        public boolean SafetySwitch;
        public boolean SkipEmptyRecords;
        public boolean CaptureRawRecord;

        public UserSettings() {
            this.TextQualifier = Letters.QUOTE.code;
            this.TrimWhitespace = true;
            this.UseTextQualifier = true;
            this.Delimiter = Letters.SEMICOLON.code;
            this.RecordDelimiter = Letters.NULL.code;
            this.UseComments = false;
            this.EscapeMode = 1;
            this.SafetySwitch = true;
            this.SkipEmptyRecords = true;
            this.CaptureRawRecord = true;
        }
    }

    private static enum Letters {
        LF('\n'),
        CR('\r'),
        QUOTE('\"'),
        SEMICOLON(';'),
        COMMA(','),
        SPACE(' '),
        TAB('\t'),
        POUND('#'),
        BACKSLASH('\\'),
        NULL('\u0000'),
        BACKSPACE('\b'),
        FORM_FEED('\f'),
        ESCAPE('\u001b'),
        VERTICAL_TAB('\u000b'),
        ALERT('\u0007');

        public final char code;

        private Letters(char code) {
            this.code = code;
        }
    }

    private class RawRecordBuffer {
        public char[] Buffer = new char[500];
        public int Position = 0;
    }

    private class ColumnBuffer {
        public char[] Buffer = new char[50];
        public int Position = 0;
    }

    private class DataBuffer {
        public char[] Buffer = new char[1024];
        public int Position = 0;
        public int Count = 0;
        public int ColumnStart = 0;
        public int LineStart = 0;
    }

    private class ComplexEscape {
        private static final int UNICODE = 1;
        private static final int OCTAL = 2;
        private static final int DECIMAL = 3;
        private static final int HEX = 4;

        private ComplexEscape() {
        }
    }
}

