/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.exceptions;

import es.prodevelop.pui9.exceptions.PuiExceptionDto;
import es.prodevelop.pui9.utils.PuiDateUtil;
import java.text.MessageFormat;
import java.time.Instant;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class PuiException
extends Exception {
    private static final long serialVersionUID = 1L;
    private static final Integer DEFAULT_INTERNAL_CODE = -1;
    private int internalCode = DEFAULT_INTERNAL_CODE;
    private String className = "";
    private String methodName = "";
    private Instant datetime;

    private static Throwable lookForNonPuiException(Throwable cause) {
        Throwable e = cause;
        while (e instanceof PuiException) {
            e = e.getCause();
        }
        return e != null ? e : cause;
    }

    private static String getExceptionMessage(Throwable cause, String message, Object ... parameters) {
        String msg = !StringUtils.isEmpty((CharSequence)message) ? message : (cause != null ? cause.getMessage() : "");
        if (!ArrayUtils.isEmpty((Object[])parameters)) {
            msg = MessageFormat.format(msg, parameters);
        }
        return msg;
    }

    public PuiException(String message) {
        this(null, null, message, new Object[0]);
    }

    public PuiException(Throwable cause) {
        this(cause, null, null, new Object[0]);
    }

    public PuiException(Throwable cause, String message) {
        this(cause, null, message, new Object[0]);
    }

    public PuiException(Throwable cause, Integer internalCode, String message, Object ... parameters) {
        super(PuiException.getExceptionMessage(cause, message, parameters), PuiException.lookForNonPuiException(cause));
        this.internalCode = cause instanceof PuiException ? ((PuiException)cause).getInternalCode() : (internalCode != null ? internalCode : DEFAULT_INTERNAL_CODE).intValue();
        this.datetime = Instant.now();
        this.setStackData();
    }

    private void setStackData() {
        for (StackTraceElement ste : this.getStackTrace()) {
            if (ste.getClassName().contains(Thread.class.getSimpleName()) || ste.getClassName().endsWith(Exception.class.getSimpleName())) continue;
            this.className = ste.getClassName();
            this.methodName = ste.getMethodName();
            break;
        }
    }

    public int getInternalCode() {
        return this.internalCode;
    }

    protected int getStatusResponse() {
        return 500;
    }

    public boolean shouldLog() {
        return true;
    }

    public PuiExceptionDto asTransferObject() {
        PuiExceptionDto dto = new PuiExceptionDto();
        dto.setInternalCode(this.internalCode);
        dto.setStatusCode(this.getStatusResponse());
        dto.setMessage(this.getMessage());
        dto.setDatetime(this.datetime);
        if (this.getCause() != null) {
            dto.setDetailedMessage(this.getCause().getMessage());
        }
        return dto;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n#####################################################");
        sb.append("\nDate: " + PuiDateUtil.temporalAccessorToString(this.datetime));
        sb.append("\nInternalCode: " + this.internalCode);
        sb.append("\nClass: " + this.className);
        sb.append("\nMethod: " + this.methodName);
        sb.append("\nMessage: " + this.getMessage());
        if (this.getCause() != null) {
            sb.append("\nOriginalMessage: " + this.getCause().getMessage());
        }
        sb.append("\n#####################################################\n");
        return sb.toString();
    }
}

