/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.file;

import com.google.common.io.Files;
import es.prodevelop.pui9.utils.IPuiObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class FileDownload
implements IPuiObject {
    private static final long serialVersionUID = 1L;
    private File file;
    private InputStream inputStream;
    private byte[] bytes;
    private String filename;
    private boolean downloadable = true;

    public FileDownload(File file, String filename) {
        this(file, filename, true);
    }

    public FileDownload(File file, String filename, boolean downloadable) {
        this.file = file;
        this.filename = filename;
        this.downloadable = downloadable;
    }

    public FileDownload(InputStream inputStream, String filename) {
        this(inputStream, filename, true);
    }

    public FileDownload(InputStream inputStream, String filename, boolean downloadable) {
        this.inputStream = inputStream;
        this.filename = filename;
        this.downloadable = downloadable;
    }

    public FileDownload(byte[] bytes, String filename) {
        this(bytes, filename, true);
    }

    public FileDownload(byte[] bytes, String filename, boolean downloadable) {
        this.bytes = bytes;
        this.filename = filename;
        this.downloadable = downloadable;
    }

    public File getFile() {
        return this.file;
    }

    public InputStream getInputStream() {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        if (this.bytes != null) {
            return new ByteArrayInputStream(this.bytes);
        }
        if (this.file != null) {
            try {
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    public byte[] getBytes() {
        if (this.bytes != null) {
            return this.bytes;
        }
        if (this.file != null) {
            try {
                return Files.toByteArray((File)this.file);
            }
            catch (IOException e) {
                return new byte[0];
            }
        }
        if (this.inputStream != null) {
            byte[] array;
            try {
                array = new byte[this.inputStream.available()];
            }
            catch (IOException e1) {
                return new byte[0];
            }
            try {
                this.inputStream.read(array);
            }
            catch (IOException e) {
                return new byte[0];
            }
            return array;
        }
        return new byte[0];
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean isDownloadable() {
        return this.downloadable;
    }
}

