/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.json;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.bind.TypeAdapters;
import es.prodevelop.pui9.json.adapters.BigDecimalTypeAdapter;
import es.prodevelop.pui9.json.adapters.DoubleTypeAdapter;
import es.prodevelop.pui9.json.adapters.InstantTypeAdapter;
import es.prodevelop.pui9.json.adapters.IntegerTypeAdapter;
import es.prodevelop.pui9.json.adapters.LocalDateTypeAdapter;
import es.prodevelop.pui9.json.adapters.LongTypeAdapter;
import es.prodevelop.pui9.json.adapters.ObjectTypeAdapter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GsonSingleton {
    public static final String DEFAULT_ID = "default";
    private static GsonSingleton instance;
    private Map<String, GsonBuilder> cacheGsonBuilder = new HashMap<String, GsonBuilder>();
    private Map<String, Gson> cacheGson = new HashMap<String, Gson>();

    public static synchronized GsonSingleton getSingleton() {
        if (instance == null) {
            instance = new GsonSingleton();
        }
        return instance;
    }

    private GsonSingleton() {
        this.createDefaultGson();
    }

    private Gson createDefaultGson() {
        boolean isDebug;
        GsonBuilder builder = this.createGsonBuilder(DEFAULT_ID);
        builder.registerTypeAdapterFactory(TypeAdapters.newFactory(Instant.class, (TypeAdapter)new InstantTypeAdapter()));
        builder.registerTypeAdapterFactory(TypeAdapters.newFactory(LocalDate.class, (TypeAdapter)new LocalDateTypeAdapter()));
        builder.registerTypeAdapterFactory(TypeAdapters.newFactory(Long.TYPE, Long.class, (TypeAdapter)new LongTypeAdapter()));
        builder.registerTypeAdapterFactory(TypeAdapters.newFactory(Double.TYPE, Double.class, (TypeAdapter)new DoubleTypeAdapter()));
        builder.registerTypeAdapterFactory(TypeAdapters.newFactory(Integer.TYPE, Integer.class, (TypeAdapter)new IntegerTypeAdapter()));
        builder.registerTypeAdapterFactory(TypeAdapters.newFactory(BigDecimal.class, (TypeAdapter)new BigDecimalTypeAdapter()));
        builder.registerTypeAdapterFactory(ObjectTypeAdapter.FACTORY);
        builder.excludeFieldsWithModifiers(new int[]{128, 64, 8});
        builder.serializeNulls();
        boolean bl = isDebug = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("jdwp") >= 0;
        if (isDebug) {
            builder.setPrettyPrinting();
        }
        return this.createGson(DEFAULT_ID);
    }

    private synchronized GsonBuilder createGsonBuilder(String gsonId) {
        if (this.cacheGsonBuilder.containsKey(gsonId)) {
            this.cacheGsonBuilder.remove(gsonId);
        }
        GsonBuilder builder = new GsonBuilder();
        this.cacheGsonBuilder.put(gsonId, builder);
        return builder;
    }

    private synchronized Gson createGson(String gsonId) {
        if (this.cacheGson.containsKey(gsonId)) {
            this.cacheGson.remove(gsonId);
        }
        Gson gson = this.getGsonBuilder(gsonId).create();
        try {
            Field field = Gson.class.getDeclaredField("factories");
            field.setAccessible(true);
            List list = (List)field.get(gson);
            ArrayList<TypeAdapterFactory> newList = new ArrayList<TypeAdapterFactory>();
            for (TypeAdapterFactory taf : list) {
                if (taf.equals(com.google.gson.internal.bind.ObjectTypeAdapter.FACTORY)) continue;
                newList.add(taf);
            }
            field.set(gson, Collections.unmodifiableList(newList));
            field.setAccessible(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cacheGson.put(gsonId, gson);
        return gson;
    }

    private GsonBuilder getGsonBuilder(String gsonId) {
        GsonBuilder builder = this.cacheGsonBuilder.get(gsonId);
        if (builder == null) {
            builder = this.createGsonBuilder(gsonId);
        }
        return builder;
    }

    public void setSerializeNulls() {
        this.setSerializeNulls(DEFAULT_ID);
    }

    public void setSerializeNulls(String gsonId) {
        this.getGsonBuilder(gsonId).serializeNulls();
        this.createGson(gsonId);
    }

    public void setPrettyPrinting() {
        this.setPrettyPrinting(DEFAULT_ID);
    }

    public void setPrettyPrinting(String gsonId) {
        this.getGsonBuilder(gsonId).setPrettyPrinting();
        this.createGson(gsonId);
    }

    public void excludeFieldsWithModifiers(int ... modifiers) {
        this.excludeFieldsWithModifiers(DEFAULT_ID, modifiers);
    }

    public void excludeFieldsWithModifiers(String gsonId, int ... modifiers) {
        this.getGsonBuilder(gsonId).excludeFieldsWithModifiers(modifiers);
        this.createGson(gsonId);
    }

    public void registerTypeAdapter(Type type, Object typeAdapter) {
        this.registerTypeAdapter(DEFAULT_ID, type, typeAdapter);
    }

    public void registerTypeAdapter(String gsonId, Type type, Object typeAdapter) {
        this.getGsonBuilder(gsonId).registerTypeAdapter(type, typeAdapter);
        this.createGson(gsonId);
    }

    public void registerTypeAdapterFactory(TypeAdapterFactory typeAdapterFactory) {
        this.registerTypeAdapterFactory(DEFAULT_ID, typeAdapterFactory);
    }

    public void registerTypeAdapterFactory(String gsonId, TypeAdapterFactory typeAdapterFactory) {
        this.getGsonBuilder(gsonId).registerTypeAdapterFactory(typeAdapterFactory);
        this.createGson(gsonId);
    }

    public void setFieldNamingStrategy(FieldNamingStrategy strategy) {
        this.setFieldNamingStrategy(DEFAULT_ID, strategy);
    }

    public void setFieldNamingStrategy(String gsonId, FieldNamingStrategy strategy) {
        this.getGsonBuilder(gsonId).setFieldNamingStrategy(strategy);
        this.createGson(gsonId);
    }

    public void setExclusionStrategies(ExclusionStrategy strategy) {
        this.setExclusionStrategies(DEFAULT_ID, strategy);
    }

    public void setExclusionStrategies(String gsonId, ExclusionStrategy strategy) {
        this.getGsonBuilder(gsonId).setExclusionStrategies(new ExclusionStrategy[]{strategy});
        this.createGson(gsonId);
    }

    public Gson getGson() {
        return this.getGson(DEFAULT_ID);
    }

    public Gson getGson(String gsonId) {
        if (!this.cacheGson.containsKey(gsonId)) {
            this.createGson(gsonId);
        }
        return this.cacheGson.get(gsonId);
    }
}

