/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.json.adapters;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;

public class ObjectTypeAdapter
extends TypeAdapter<Object> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (type.getRawType() == Object.class) {
                return new ObjectTypeAdapter(gson);
            }
            return null;
        }
    };
    com.google.gson.internal.bind.ObjectTypeAdapter objectTypeAdapter;

    private ObjectTypeAdapter(Gson gson) {
        this.objectTypeAdapter = (com.google.gson.internal.bind.ObjectTypeAdapter)com.google.gson.internal.bind.ObjectTypeAdapter.FACTORY.create(gson, TypeToken.get(Object.class));
    }

    public Object read(JsonReader in) throws IOException {
        JsonToken token = in.peek();
        switch (token) {
            case NUMBER: {
                String value = in.nextString();
                BigDecimal bd = new BigDecimal(value);
                if (bd.scale() > 0) {
                    return bd;
                }
                return bd.intValue();
            }
        }
        return this.objectTypeAdapter.read(in);
    }

    public void write(JsonWriter out, Object value) throws IOException {
        this.objectTypeAdapter.write(out, value);
    }
}

