/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.messages;

import es.prodevelop.pui9.utils.PuiLanguage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class PuiMessagesRegistry {
    private static PuiMessagesRegistry singleton;
    private final Map<String, Map<String, ResourceBundle>> map = new HashMap<String, Map<String, ResourceBundle>>();
    private String[] AVAILABLE_LANGUAGES = new String[]{"es", "en", "ca", "fr"};
    private PuiLanguage DEFAULT_LANGUAGE = new PuiLanguage(this.AVAILABLE_LANGUAGES[0]);

    public static PuiMessagesRegistry getSingleton() {
        if (singleton == null) {
            singleton = new PuiMessagesRegistry();
        }
        return singleton;
    }

    private PuiMessagesRegistry() {
    }

    public void setAvailableLanguages(String ... langs) {
        this.AVAILABLE_LANGUAGES = langs;
        Iterator<String> it = this.map.keySet().iterator();
        while (it.hasNext()) {
            if (Arrays.asList(this.AVAILABLE_LANGUAGES).contains(it.next())) continue;
            it.remove();
        }
        for (String lang : this.AVAILABLE_LANGUAGES) {
            if (this.map.containsKey(lang)) continue;
            this.map.put(lang, new HashMap());
            Map<String, ResourceBundle> oneLang = this.map.values().iterator().next();
            for (String baseMap : oneLang.keySet()) {
                this.addFileMessages(lang, baseMap);
            }
        }
    }

    public void setDefaultLanguage(String lang) {
        this.DEFAULT_LANGUAGE = new PuiLanguage(lang);
    }

    public void registerMessages(String baseName) {
        if (baseName == null) {
            throw new IllegalArgumentException("baseName parameter cannot be null");
        }
        for (String lang : this.AVAILABLE_LANGUAGES) {
            this.addFileMessages(lang, baseName);
        }
    }

    private void addFileMessages(String lang, String baseName) {
        try {
            if (!this.map.containsKey(lang)) {
                this.map.put(lang, new HashMap());
            }
            this.map.get(lang).put(baseName, ResourceBundle.getBundle(baseName, new Locale(lang)));
        }
        catch (MissingResourceException e) {
            this.map.get(lang).put(baseName, ResourceBundle.getBundle(baseName, new Locale(this.DEFAULT_LANGUAGE.getIsocode())));
        }
    }

    public String getString(String baseName, String key) {
        return this.getString(baseName, this.DEFAULT_LANGUAGE, key);
    }

    public String getString(String baseName, PuiLanguage lang, String key) {
        if (baseName == null) {
            throw new IllegalArgumentException("baseName parameter cannot be null");
        }
        if (key == null) {
            return "";
        }
        if (lang == null || !this.map.containsKey(lang.getIsocode())) {
            lang = this.DEFAULT_LANGUAGE;
        }
        try {
            if (this.map.get(lang.getIsocode()).containsKey(baseName)) {
                return this.map.get(lang.getIsocode()).get(baseName).getString(key);
            }
            return null;
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public String getString(PuiLanguage lang, String key) {
        if (key == null) {
            return "";
        }
        if (lang == null || !this.map.containsKey(lang.getIsocode())) {
            lang = this.DEFAULT_LANGUAGE;
        }
        String val = null;
        for (ResourceBundle rb : this.map.get(lang.getIsocode()).values()) {
            try {
                val = rb.getString(key);
                break;
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        return val;
    }
}

