/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.utils;

import es.prodevelop.pui9.utils.PuiConstants;
import java.io.Serializable;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class PuiLanguage
implements Comparable<PuiLanguage>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final PuiLanguage DEFAULT_LANG = new PuiLanguage("es");
    private String isocode;
    private String country;
    private String name;
    private Integer isdefault = PuiConstants.FALSE_INT;

    public PuiLanguage() {
    }

    public PuiLanguage(Locale locale) {
        this(locale.getLanguage());
        this.country = StringUtils.isEmpty((CharSequence)locale.getCountry()) ? "" : locale.getCountry();
    }

    public PuiLanguage(String isocode) {
        this.isocode = isocode;
        this.country = "";
    }

    public String getIsocode() {
        return this.isocode;
    }

    public String getCountry() {
        return this.country;
    }

    public String getName() {
        return this.name;
    }

    public Integer getIsdefault() {
        return this.isdefault;
    }

    public void setIsdefault(Integer isdefault) {
        this.isdefault = isdefault;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.isocode.equalsIgnoreCase(((PuiLanguage)obj).isocode);
    }

    @Override
    public int compareTo(PuiLanguage o) {
        return this.isocode.compareTo(o.getIsocode());
    }

    public String toString() {
        return this.isocode;
    }
}

