/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.utils;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PuiObjectUtils {
    private static Map<Class<?>, Map<String, Field>> mapCache = new HashMap();

    public static <T> T copyObject(T orig) {
        if (orig == null) {
            return null;
        }
        try {
            Object dest = orig.getClass().newInstance();
            PuiObjectUtils.copyProperties(dest, orig);
            return (T)dest;
        }
        catch (IllegalAccessException | InstantiationException e) {
            return null;
        }
    }

    public static void copyProperties(Object dest, Object orig) {
        if (dest == null || orig == null) {
            return;
        }
        Map<String, Field> destFields = PuiObjectUtils.getFields(dest.getClass());
        Map<String, Field> origFields = PuiObjectUtils.getFields(orig.getClass());
        for (Map.Entry<String, Field> entry : destFields.entrySet()) {
            try {
                String destFieldName = entry.getKey();
                Field destField = entry.getValue();
                if (!origFields.containsKey(destFieldName)) continue;
                Field origField = origFields.get(destFieldName);
                if (!destField.getType().equals(origField.getType())) continue;
                Object value = origField.get(orig);
                destField.set(dest, value);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {}
        }
    }

    public static void populateObject(Object object, Map<String, Object> fieldValuesMap) {
        if (object == null || fieldValuesMap == null || fieldValuesMap.isEmpty()) {
            return;
        }
        Map<String, Field> fields = PuiObjectUtils.getFields(object.getClass());
        for (Map.Entry<String, Object> entry : fieldValuesMap.entrySet()) {
            if (!fields.containsKey(entry.getKey())) continue;
            Field field = fields.get(entry.getKey());
            try {
                field.set(object, entry.getValue());
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {}
        }
    }

    private static Map<String, Field> getFields(Class<?> clazz) {
        if (!mapCache.containsKey(clazz)) {
            HashMap<String, Field> map = new HashMap<String, Field>();
            for (Class<?> toRegister = clazz; toRegister != null; toRegister = toRegister.getSuperclass()) {
                List<Field> fields = Arrays.asList(toRegister.getDeclaredFields());
                for (Field field : fields) {
                    field.setAccessible(true);
                    map.put(field.getName(), field);
                }
            }
            mapCache.put(clazz, map);
        }
        return mapCache.get(clazz);
    }

    private PuiObjectUtils() {
    }
}

