/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.exceptions;

import es.prodevelop.pui9.exceptions.PuiExceptionDto;
import es.prodevelop.pui9.utils.PuiDateUtil;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.time.Instant;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class PuiException
extends Exception {
    private static final long serialVersionUID = 1L;
    public static final Integer DEFAULT_INTERNAL_CODE = -1;
    private int internalCode = DEFAULT_INTERNAL_CODE;
    private String className = "";
    private String methodName = "";
    private Instant datetime;
    private int status = 500;
    private boolean shouldLog = true;

    private static Throwable lookForNonPuiException(Throwable cause) {
        Throwable e = cause;
        while (e instanceof PuiException) {
            e = e.getCause();
        }
        return e != null ? e : cause;
    }

    private static String getExceptionMessage(Throwable cause, String message, Object ... parameters) {
        String msg = !StringUtils.isEmpty((CharSequence)message) ? message : (cause != null ? cause.getMessage() : "");
        if (!ObjectUtils.isEmpty((Object)parameters)) {
            msg = MessageFormat.format(msg, parameters);
        }
        return msg;
    }

    public static PuiException fromTransferObject(PuiExceptionDto dto) {
        PuiException ex = null;
        if (!StringUtils.isEmpty((CharSequence)dto.getErrorClassName())) {
            try {
                ex = (PuiException)Class.forName(dto.getErrorClassName()).getConstructor(new Class[0]).newInstance(new Object[0]);
                Field f = Throwable.class.getDeclaredField("detailMessage");
                f.setAccessible(true);
                f.set(ex, dto.getMessage());
            }
            catch (Exception e) {
                ex = new PuiException(dto.getMessage());
            }
        } else {
            ex = new PuiException(dto.getMessage());
        }
        try {
            ex.datetime = dto.getDatetime();
            ex.internalCode = dto.getInternalCode();
            ex.className = dto.getClassName();
            ex.methodName = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ex;
    }

    public PuiException(String message) {
        this(null, null, message, new Object[0]);
    }

    public PuiException(Throwable cause) {
        this(cause, null, null, new Object[0]);
    }

    public PuiException(Throwable cause, String message) {
        this(cause, null, message, new Object[0]);
    }

    public PuiException(Throwable cause, Integer internalCode, String message, Object ... parameters) {
        super(PuiException.getExceptionMessage(cause, message, parameters), PuiException.lookForNonPuiException(cause));
        if (cause instanceof PuiException) {
            PuiException pe = (PuiException)cause;
            this.internalCode = pe.getInternalCode();
        } else {
            this.internalCode = internalCode != null ? internalCode : DEFAULT_INTERNAL_CODE;
        }
        this.datetime = Instant.now();
        this.setStackData();
    }

    private void setStackData() {
        for (StackTraceElement ste : this.getStackTrace()) {
            if (ste.getClassName().contains(Thread.class.getSimpleName()) || ste.getClassName().endsWith(Exception.class.getSimpleName())) continue;
            this.className = ste.getClassName();
            this.methodName = ste.getMethodName();
            break;
        }
    }

    public int getInternalCode() {
        return this.internalCode;
    }

    public String getClassName() {
        return this.className;
    }

    public int getStatusResponse() {
        return this.status;
    }

    public void setStatusResponse(int status) {
        this.status = status;
    }

    public boolean shouldLog() {
        return this.shouldLog;
    }

    public void setShouldLog(boolean shouldLog) {
        this.shouldLog = shouldLog;
    }

    public PuiExceptionDto asTransferObject() {
        PuiExceptionDto dto = PuiExceptionDto.builder().withInternalCode(this.internalCode).withStatusCode(this.getStatusResponse()).withMessage(this.getMessage()).withDatetime(this.datetime);
        if (this.getCause() != null) {
            dto.withDetailedMessage(this.getCause().getMessage());
        }
        return dto;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n#####################################################");
        sb.append("\nDate: " + PuiDateUtil.temporalAccessorToString(this.datetime));
        sb.append("\nInternalCode: " + this.internalCode);
        sb.append("\nClass: " + this.className);
        sb.append("\nMethod: " + this.methodName);
        sb.append("\nMessage: " + this.getMessage());
        if (this.getCause() != null) {
            sb.append("\nOriginalMessage: " + this.getCause().getMessage());
        }
        sb.append("\n#####################################################\n");
        return sb.toString();
    }
}

