/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.file;

import com.google.common.io.Files;
import es.prodevelop.pui9.utils.IPuiObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import lombok.Generated;

public class FileDownload
implements IPuiObject {
    private File file;
    private transient InputStream inputStream;
    private byte[] bytes;
    private String filename;
    private Boolean downloadable = true;

    public FileDownload(File file, String filename) {
        this(file, filename, (Boolean)true);
    }

    public FileDownload(File file, String filename, Boolean downloadable) {
        this.file = file;
        this.filename = filename;
        this.downloadable = downloadable;
    }

    public FileDownload(InputStream inputStream, String filename) {
        this(inputStream, filename, (Boolean)true);
    }

    public FileDownload(InputStream inputStream, String filename, Boolean downloadable) {
        this.inputStream = inputStream;
        this.filename = filename;
        this.downloadable = downloadable;
    }

    public FileDownload(byte[] bytes, String filename) {
        this(bytes, filename, (Boolean)true);
    }

    public FileDownload(byte[] bytes, String filename, Boolean downloadable) {
        this.bytes = bytes;
        this.filename = filename;
        this.downloadable = downloadable;
    }

    public InputStream getInputStream() {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        if (this.bytes != null) {
            return new ByteArrayInputStream(this.bytes);
        }
        if (this.file != null) {
            try {
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    public byte[] getBytes() {
        if (this.bytes != null) {
            return this.bytes;
        }
        if (this.file != null) {
            try {
                return Files.toByteArray((File)this.file);
            }
            catch (IOException e) {
                return new byte[0];
            }
        }
        if (this.inputStream != null) {
            byte[] array;
            try {
                array = new byte[this.inputStream.available()];
            }
            catch (IOException e1) {
                return new byte[0];
            }
            try {
                while (this.inputStream.read(array) > 0) {
                }
            }
            catch (IOException e) {
                return new byte[0];
            }
            return array;
        }
        return new byte[0];
    }

    @Generated
    public File getFile() {
        return this.file;
    }

    @Generated
    public String getFilename() {
        return this.filename;
    }

    @Generated
    public Boolean getDownloadable() {
        return this.downloadable;
    }
}

