/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.json;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.ToNumberStrategy;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.stream.JsonReader;
import es.prodevelop.pui9.json.adapters.IPuiGsonTypeAdapter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class GsonSingleton {
    public static final String DEFAULT_ID = "default";
    private static GsonSingleton instance;
    private Map<String, GsonBuilder> cacheGsonBuilder = new LinkedHashMap<String, GsonBuilder>();
    private Map<String, Gson> cacheGson = new LinkedHashMap<String, Gson>();

    public static synchronized GsonSingleton getSingleton() {
        if (instance == null) {
            instance = new GsonSingleton();
        }
        return instance;
    }

    private GsonSingleton() {
        this.createDefaultGson();
    }

    private synchronized void createDefaultGson() {
        boolean isDebug;
        if (this.cacheGson.containsKey(DEFAULT_ID)) {
            return;
        }
        GsonBuilder builder = this.createGsonBuilder(DEFAULT_ID);
        Reflections ref = new Reflections("es.prodevelop", new Scanner[0]);
        Set typeAdapterClasses = ref.getSubTypesOf(IPuiGsonTypeAdapter.class);
        typeAdapterClasses.removeIf(tac -> tac.isInterface() || Modifier.isAbstract(tac.getModifiers()));
        typeAdapterClasses.removeIf(tac -> typeAdapterClasses.stream().filter(tac2 -> !tac2.equals(tac)).anyMatch(tac::isAssignableFrom));
        List<IPuiGsonTypeAdapter> typeAdapters = typeAdapterClasses.stream().map(tac -> {
            try {
                return (IPuiGsonTypeAdapter)tac.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        typeAdapters.forEach(ta -> {
            if (ta.getFactory() != null) {
                builder.registerTypeAdapterFactory(ta.getFactory());
            } else {
                builder.registerTypeAdapter(ta.getType(), ta);
            }
        });
        builder.excludeFieldsWithModifiers(new int[]{128, 64, 8});
        builder.serializeNulls();
        builder.setObjectToNumberStrategy(new ToNumberStrategy(this){

            public Number readNumber(JsonReader in) throws IOException {
                Number returnValue = null;
                String jsonValue = in.nextString();
                returnValue = new BigDecimal(jsonValue);
                if (returnValue.scale() <= 0) {
                    BigDecimal bd = returnValue;
                    returnValue = bd.longValue() > Integer.MAX_VALUE ? (Number)returnValue.longValue() : (Number)returnValue.intValue();
                }
                return returnValue;
            }
        });
        boolean bl = isDebug = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("jdwp") >= 0;
        if (isDebug) {
            builder.setPrettyPrinting();
        }
        this.createGson(DEFAULT_ID);
    }

    private synchronized GsonBuilder createGsonBuilder(String gsonId) {
        if (this.cacheGsonBuilder.containsKey(gsonId)) {
            this.cacheGsonBuilder.remove(gsonId);
        }
        GsonBuilder builder = new GsonBuilder();
        this.cacheGsonBuilder.put(gsonId, builder);
        return builder;
    }

    private synchronized void createGson(String gsonId) {
        if (this.cacheGson.containsKey(gsonId)) {
            this.cacheGson.remove(gsonId);
        }
        Gson gson = this.getGsonBuilder(gsonId).create();
        this.cacheGson.put(gsonId, gson);
    }

    private GsonBuilder getGsonBuilder(String gsonId) {
        GsonBuilder builder = this.cacheGsonBuilder.get(gsonId);
        if (builder == null) {
            builder = this.createGsonBuilder(gsonId);
        }
        return builder;
    }

    public void setSerializeNulls() {
        this.setSerializeNulls(DEFAULT_ID);
    }

    public void setSerializeNulls(String gsonId) {
        this.getGsonBuilder(gsonId).serializeNulls();
        this.createGson(gsonId);
    }

    public void setPrettyPrinting() {
        this.setPrettyPrinting(DEFAULT_ID);
    }

    public void setPrettyPrinting(String gsonId) {
        this.getGsonBuilder(gsonId).setPrettyPrinting();
        this.createGson(gsonId);
    }

    public void excludeFieldsWithModifiers(int ... modifiers) {
        this.excludeFieldsWithModifiers(DEFAULT_ID, modifiers);
    }

    public void excludeFieldsWithModifiers(String gsonId, int ... modifiers) {
        this.getGsonBuilder(gsonId).excludeFieldsWithModifiers(modifiers);
        this.createGson(gsonId);
    }

    public void registerTypeAdapter(Type type, Object typeAdapter) {
        this.registerTypeAdapter(DEFAULT_ID, type, typeAdapter);
    }

    public void registerTypeAdapter(String gsonId, Type type, Object typeAdapter) {
        this.getGsonBuilder(gsonId).registerTypeAdapter(type, typeAdapter);
        this.createGson(gsonId);
    }

    public void registerTypeAdapterFactory(TypeAdapterFactory typeAdapterFactory) {
        this.registerTypeAdapterFactory(DEFAULT_ID, typeAdapterFactory);
    }

    public void registerTypeAdapterFactory(String gsonId, TypeAdapterFactory typeAdapterFactory) {
        this.getGsonBuilder(gsonId).registerTypeAdapterFactory(typeAdapterFactory);
        this.createGson(gsonId);
    }

    public void setFieldNamingStrategy(FieldNamingStrategy strategy) {
        this.setFieldNamingStrategy(DEFAULT_ID, strategy);
    }

    public void setFieldNamingStrategy(String gsonId, FieldNamingStrategy strategy) {
        this.getGsonBuilder(gsonId).setFieldNamingStrategy(strategy);
        this.createGson(gsonId);
    }

    public void setExclusionStrategies(ExclusionStrategy strategy) {
        this.setExclusionStrategies(DEFAULT_ID, strategy);
    }

    public void setExclusionStrategies(String gsonId, ExclusionStrategy strategy) {
        this.getGsonBuilder(gsonId).setExclusionStrategies(new ExclusionStrategy[]{strategy});
        this.createGson(gsonId);
    }

    public Gson getGson() {
        return this.getGson(DEFAULT_ID);
    }

    public Gson getGson(String gsonId) {
        if (!this.cacheGson.containsKey(gsonId)) {
            this.createGson(gsonId);
        }
        return this.cacheGson.get(gsonId);
    }
}

