/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.json.adapters;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import es.prodevelop.pui9.json.adapters.AbstractPuiGsonTypeAdapter;
import es.prodevelop.pui9.utils.PuiDateUtil;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import org.apache.commons.lang3.StringUtils;

public class LocalDateTypeAdapter
extends AbstractPuiGsonTypeAdapter<LocalDate> {
    @Override
    public Class<LocalDate> getType() {
        return LocalDate.class;
    }

    public void write(JsonWriter out, LocalDate instant) throws IOException {
        String value = null;
        if (instant != null) {
            value = PuiDateUtil.temporalAccessorToString(instant);
        }
        out.value(value);
    }

    public LocalDate read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        String value = in.nextString();
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        LocalDate localDate = PuiDateUtil.stringToLocalDate(value, PuiDateUtil.utcZone);
        if (localDate == null) {
            throw new DateTimeParseException("Date format not supported", value, 0);
        }
        return localDate;
    }
}

