/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.threads;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PuiBackgroundExecutors {
    private static PuiBackgroundExecutors instance;
    private final Logger logger = LogManager.getLogger(this.getClass());
    private List<ScheduledExecutorService> executors = new ArrayList<ScheduledExecutorService>();

    public static PuiBackgroundExecutors getSingleton() {
        if (instance == null) {
            instance = new PuiBackgroundExecutors();
        }
        return instance;
    }

    private PuiBackgroundExecutors() {
    }

    public void registerNewExecutor(String name, boolean isDaemon, long initialDelay, long delay, TimeUnit unit, Runnable runnable) {
        ScheduledExecutorService ses = this.buildExecutorService(name, isDaemon, unit);
        ses.scheduleWithFixedDelay(runnable, initialDelay, delay, unit);
    }

    public void registerNewExecutorAtFixedRate(String name, boolean isDaemon, long initialDelay, long delay, TimeUnit unit, Runnable runnable) {
        ScheduledExecutorService ses = this.buildExecutorService(name, isDaemon, unit);
        ses.scheduleAtFixedRate(runnable, initialDelay, delay, unit);
    }

    private ScheduledExecutorService buildExecutorService(String name, boolean isDaemon, TimeUnit unit) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Empty executor name");
        }
        if (unit == null) {
            throw new IllegalArgumentException("No time unit for executor");
        }
        ThreadFactory tf = new ThreadFactoryBuilder().setDaemon(isDaemon).setNameFormat("PuiExecutor_" + name).setUncaughtExceptionHandler((thread, throwable) -> this.logger.error("Error in Background Executor '{}'", (Object)name, (Object)throwable)).build();
        ScheduledExecutorService ses = Executors.newSingleThreadScheduledExecutor(tf);
        this.executors.add(ses);
        return ses;
    }

    public void destroy() {
        for (ScheduledExecutorService ses : this.executors) {
            ses.shutdownNow();
        }
    }
}

