/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.classpath;

import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PuiClassLoaderUtils {
    private static final Logger logger = LogManager.getLogger(PuiClassLoaderUtils.class);
    private static ClassLoader classLoader;

    public static ClassLoader getClassLoader() {
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        return classLoader;
    }

    public static void addURL(URL url) throws Exception {
        ClassLoader classLoader = PuiClassLoaderUtils.getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            PuiClassLoaderUtils.innerAddUrl(urlClassLoader, url);
        }
    }

    private static void innerAddUrl(URLClassLoader urlClassLoader, URL url) throws Exception {
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)urlClassLoader, url);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            logger.error("Could not find 'addURL' method on ClassLoader");
            throw e;
        }
        catch (InaccessibleObjectException e) {
            logger.error("Add this to the args of tomcat: --add-opens=java.base/java.net=ALL-UNNAMED");
            throw e;
        }
    }

    private PuiClassLoaderUtils() {
    }
}

