/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.LinkedHashMap;
import java.util.Map;

public class CsvReader {
    public static final int ESCAPE_MODE_DOUBLED = 1;
    public static final int ESCAPE_MODE_BACKSLASH = 2;
    private Reader inputStream;
    private UserSettings userSettings;
    private boolean useCustomRecordDelimiter;
    private DataBuffer dataBuffer;
    private ColumnBuffer columnBuffer;
    private RawRecordBuffer rawBuffer;
    private boolean[] isQualified;
    private String rawRecord;
    private HeadersHolder headersHolder;
    private boolean startedColumn;
    private boolean startedWithQualifier;
    private boolean hasMoreData;
    private char lastLetter;
    private boolean hasReadNextLine;
    private int columnsCount;
    private long currentRecord;
    private String[] values;
    private boolean closed;

    public CsvReader(String fileName, char delimiter, Charset charset) throws FileNotFoundException {
        if (fileName == null) {
            throw new IllegalArgumentException("Parameter fileName can not be null.");
        }
        if (charset == null) {
            throw new IllegalArgumentException("Parameter charset can not be null.");
        }
        if (!new File(fileName).exists()) {
            throw new FileNotFoundException("File " + fileName + " does not exist.");
        }
        this.inputStream = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), charset), 4096);
        this.init(delimiter);
    }

    public CsvReader(String fileName, char delimiter) throws FileNotFoundException {
        this(fileName, delimiter, StandardCharsets.UTF_8);
    }

    public CsvReader(String fileName) throws FileNotFoundException {
        this(fileName, Letters.SEMICOLON.code);
    }

    public CsvReader(Reader inputStream, char delimiter) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Parameter inputStream can not be null.");
        }
        this.inputStream = inputStream;
        this.init(delimiter);
    }

    public CsvReader(Reader inputStream) {
        this(inputStream, Letters.SEMICOLON.code);
    }

    public CsvReader(InputStream inputStream, char delimiter, Charset charset) {
        this(new InputStreamReader(inputStream, charset), delimiter);
    }

    public CsvReader(InputStream inputStream, Charset charset) {
        this(new InputStreamReader(inputStream, charset));
    }

    public CsvReader(InputStream inputStream, Charset charset, boolean guessSeparator) {
        this(new InputStreamReader(inputStream, charset));
        if (guessSeparator) {
            Letters delimiter = null;
            try {
                this.readHeaders();
                if (this.getHeaderCount() == 0) {
                    return;
                }
                for (Letters letter : Letters.values()) {
                    if (this.getHeaders()[0].indexOf(letter.code) < 0) continue;
                    delimiter = letter;
                    break;
                }
                if (delimiter == null) {
                    delimiter = Letters.SEMICOLON;
                }
                this.close();
                inputStream.reset();
                this.inputStream = new InputStreamReader(inputStream, charset);
                this.init(delimiter.code);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void init(char delimiter) {
        this.userSettings = new UserSettings(this);
        this.useCustomRecordDelimiter = false;
        this.dataBuffer = new DataBuffer(this);
        this.columnBuffer = new ColumnBuffer(this);
        this.rawBuffer = new RawRecordBuffer(this);
        this.rawRecord = "";
        this.headersHolder = new HeadersHolder(this);
        this.startedColumn = false;
        this.startedWithQualifier = false;
        this.hasMoreData = true;
        this.lastLetter = '\u0000';
        this.hasReadNextLine = false;
        this.columnsCount = 0;
        this.currentRecord = 0L;
        this.values = new String[10];
        this.isQualified = new boolean[this.values.length];
        this.closed = false;
        this.userSettings.delimiter = delimiter;
    }

    public boolean getCaptureRawRecord() {
        return this.userSettings.captureRawRecord;
    }

    public void setCaptureRawRecord(boolean captureRawRecord) {
        this.userSettings.captureRawRecord = captureRawRecord;
    }

    public String getRawRecord() {
        return this.rawRecord;
    }

    public boolean getTrimWhitespace() {
        return this.userSettings.trimWhitespace;
    }

    public void setTrimWhitespace(boolean trimWhitespace) {
        this.userSettings.trimWhitespace = trimWhitespace;
    }

    public char getDelimiter() {
        return this.userSettings.delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.userSettings.delimiter = delimiter;
    }

    public char getRecordDelimiter() {
        return this.userSettings.recordDelimiter;
    }

    public void setRecordDelimiter(char recordDelimiter) {
        this.useCustomRecordDelimiter = true;
        this.userSettings.recordDelimiter = recordDelimiter;
    }

    public char getTextQualifier() {
        return this.userSettings.textQualifier;
    }

    public void setTextQualifier(char textQualifier) {
        this.userSettings.textQualifier = textQualifier;
    }

    public boolean getUseTextQualifier() {
        return this.userSettings.useTextQualifier;
    }

    public void setUseTextQualifier(boolean useTextQualifier) {
        this.userSettings.useTextQualifier = useTextQualifier;
    }

    public char getComment() {
        return this.userSettings.comment;
    }

    public void setComment(char comment) {
        this.userSettings.comment = comment;
    }

    public boolean getUseComments() {
        return this.userSettings.useComments;
    }

    public void setUseComments(boolean useComments) {
        this.userSettings.useComments = useComments;
    }

    public int getEscapeMode() {
        return this.userSettings.escapeMode;
    }

    public void setEscapeMode(int escapeMode) throws IllegalArgumentException {
        if (escapeMode != 1 && escapeMode != 2) {
            throw new IllegalArgumentException("Parameter escapeMode must be a valid value.");
        }
        this.userSettings.escapeMode = escapeMode;
    }

    public boolean getSkipEmptyRecords() {
        return this.userSettings.skipEmptyRecords;
    }

    public void setSkipEmptyRecords(boolean skipEmptyRecords) {
        this.userSettings.skipEmptyRecords = skipEmptyRecords;
    }

    public boolean getSafetySwitch() {
        return this.userSettings.safetySwitch;
    }

    public void setSafetySwitch(boolean safetySwitch) {
        this.userSettings.safetySwitch = safetySwitch;
    }

    public int getColumnCount() {
        return this.columnsCount;
    }

    public long getCurrentRecord() {
        return this.currentRecord - 1L;
    }

    public int getHeaderCount() {
        return this.headersHolder.length;
    }

    public String[] getHeaders() throws IOException {
        this.checkClosed();
        if (this.headersHolder.headers == null) {
            return null;
        }
        String[] clone = new String[this.headersHolder.length];
        System.arraycopy(this.headersHolder.headers, 0, clone, 0, this.headersHolder.length);
        return clone;
    }

    public void setHeaders(String[] headers) {
        this.headersHolder.headers = headers;
        this.headersHolder.indexByName.clear();
        this.headersHolder.length = headers != null ? headers.length : 0;
        if (headers == null) {
            return;
        }
        for (int i = 0; i < this.headersHolder.length; ++i) {
            this.headersHolder.indexByName.put(headers[i], i);
        }
    }

    public String[] getValues() throws IOException {
        this.checkClosed();
        String[] clone = new String[this.columnsCount];
        System.arraycopy(this.values, 0, clone, 0, this.columnsCount);
        return clone;
    }

    public String get(int columnIndex) throws IOException {
        this.checkClosed();
        if (columnIndex > -1 && columnIndex < this.columnsCount) {
            return this.values[columnIndex];
        }
        return "";
    }

    public String get(String headerName) throws IOException {
        this.checkClosed();
        return this.get(this.getIndex(headerName));
    }

    public static CsvReader parse(String data) {
        if (data == null) {
            throw new IllegalArgumentException("Parameter data can not be null.");
        }
        return new CsvReader(new StringReader(data));
    }

    public boolean readRecord() throws IOException {
        this.checkClosed();
        this.columnsCount = 0;
        this.rawBuffer.position = 0;
        this.dataBuffer.lineStart = this.dataBuffer.position;
        this.hasReadNextLine = false;
        if (this.hasMoreData) {
            do {
                if (this.dataBuffer.position == this.dataBuffer.count) {
                    this.checkDataLength();
                    continue;
                }
                this.startedWithQualifier = false;
                char currentLetter = this.dataBuffer.buffer[this.dataBuffer.position];
                if (this.userSettings.useTextQualifier && currentLetter == this.userSettings.textQualifier) {
                    this.lastLetter = currentLetter;
                    this.startedColumn = true;
                    this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                    this.startedWithQualifier = true;
                    boolean lastLetterWasQualifier = false;
                    char escapeChar = this.userSettings.textQualifier;
                    if (this.userSettings.escapeMode == 2) {
                        escapeChar = Letters.BACKSLASH.code;
                    }
                    boolean eatingTrailingJunk = false;
                    boolean lastLetterWasEscape = false;
                    boolean readingComplexEscape = false;
                    int escape = 1;
                    int escapeLength = 0;
                    char escapeValue = '\u0000';
                    ++this.dataBuffer.position;
                    do {
                        if (this.dataBuffer.position == this.dataBuffer.count) {
                            this.checkDataLength();
                            continue;
                        }
                        currentLetter = this.dataBuffer.buffer[this.dataBuffer.position];
                        if (eatingTrailingJunk) {
                            this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                            if (currentLetter == this.userSettings.delimiter) {
                                this.endColumn();
                            } else if (!this.useCustomRecordDelimiter && (currentLetter == Letters.CR.code || currentLetter == Letters.LF.code) || this.useCustomRecordDelimiter && currentLetter == this.userSettings.recordDelimiter) {
                                this.endColumn();
                                this.endRecord();
                            }
                        } else if (readingComplexEscape) {
                            ++escapeLength;
                            switch (escape) {
                                case 1: {
                                    escapeValue = (char)(escapeValue * 16);
                                    escapeValue = (char)(escapeValue + CsvReader.hexToDec(currentLetter));
                                    if (escapeLength != 4) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                                case 2: {
                                    escapeValue = (char)(escapeValue * 8);
                                    escapeValue = (char)(escapeValue + (char)(currentLetter - 48));
                                    if (escapeLength != 3) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                                case 3: {
                                    escapeValue = (char)(escapeValue * 10);
                                    escapeValue = (char)(escapeValue + (char)(currentLetter - 48));
                                    if (escapeLength != 3) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                                case 4: {
                                    escapeValue = (char)(escapeValue * 16);
                                    escapeValue = (char)(escapeValue + CsvReader.hexToDec(currentLetter));
                                    if (escapeLength != 2) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                            }
                            if (!readingComplexEscape) {
                                this.appendLetter(escapeValue);
                            } else {
                                this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                            }
                        } else if (currentLetter == this.userSettings.textQualifier) {
                            if (lastLetterWasEscape) {
                                lastLetterWasEscape = false;
                                lastLetterWasQualifier = false;
                            } else {
                                this.updateCurrentValue();
                                if (this.userSettings.escapeMode == 1) {
                                    lastLetterWasEscape = true;
                                }
                                lastLetterWasQualifier = true;
                            }
                        } else if (this.userSettings.escapeMode == 2 && lastLetterWasEscape) {
                            switch (currentLetter) {
                                case 'n': {
                                    this.appendLetter(Letters.LF.code);
                                    break;
                                }
                                case 'r': {
                                    this.appendLetter(Letters.CR.code);
                                    break;
                                }
                                case 't': {
                                    this.appendLetter(Letters.TAB.code);
                                    break;
                                }
                                case 'b': {
                                    this.appendLetter(Letters.BACKSPACE.code);
                                    break;
                                }
                                case 'f': {
                                    this.appendLetter(Letters.FORM_FEED.code);
                                    break;
                                }
                                case 'e': {
                                    this.appendLetter(Letters.ESCAPE.code);
                                    break;
                                }
                                case 'v': {
                                    this.appendLetter(Letters.VERTICAL_TAB.code);
                                    break;
                                }
                                case 'a': {
                                    this.appendLetter(Letters.ALERT.code);
                                    break;
                                }
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': {
                                    escape = 2;
                                    readingComplexEscape = true;
                                    escapeLength = 1;
                                    escapeValue = (char)(currentLetter - 48);
                                    this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                                    break;
                                }
                                case 'D': 
                                case 'O': 
                                case 'U': 
                                case 'X': 
                                case 'd': 
                                case 'o': 
                                case 'u': 
                                case 'x': {
                                    switch (currentLetter) {
                                        case 'U': 
                                        case 'u': {
                                            escape = 1;
                                            break;
                                        }
                                        case 'X': 
                                        case 'x': {
                                            escape = 4;
                                            break;
                                        }
                                        case 'O': 
                                        case 'o': {
                                            escape = 2;
                                            break;
                                        }
                                        case 'D': 
                                        case 'd': {
                                            escape = 3;
                                            break;
                                        }
                                    }
                                    readingComplexEscape = true;
                                    escapeLength = 0;
                                    escapeValue = '\u0000';
                                    this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                                    break;
                                }
                            }
                            lastLetterWasEscape = false;
                        } else if (currentLetter == escapeChar) {
                            this.updateCurrentValue();
                            lastLetterWasEscape = true;
                        } else if (lastLetterWasQualifier) {
                            if (currentLetter == this.userSettings.delimiter) {
                                this.endColumn();
                            } else if (!this.useCustomRecordDelimiter && (currentLetter == Letters.CR.code || currentLetter == Letters.LF.code) || this.useCustomRecordDelimiter && currentLetter == this.userSettings.recordDelimiter) {
                                this.endColumn();
                                this.endRecord();
                            } else {
                                this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                                eatingTrailingJunk = true;
                            }
                            lastLetterWasQualifier = false;
                        }
                        this.lastLetter = currentLetter;
                        if (!this.startedColumn) continue;
                        ++this.dataBuffer.position;
                        if (!this.userSettings.safetySwitch || this.dataBuffer.position - this.dataBuffer.columnStart + this.columnBuffer.position <= 100000) continue;
                        this.close();
                        throw new IOException("Maximum column length of 100,000 exceeded in column " + NumberFormat.getIntegerInstance().format(this.columnsCount) + " in record " + NumberFormat.getIntegerInstance().format(this.currentRecord) + ". Set the SafetySwitch property to false if you're expecting column lengths greater than 100,000 characters to avoid this error.");
                    } while (this.hasMoreData && this.startedColumn);
                } else if (currentLetter == this.userSettings.delimiter) {
                    this.lastLetter = currentLetter;
                    this.endColumn();
                } else if (this.useCustomRecordDelimiter && currentLetter == this.userSettings.recordDelimiter) {
                    if (this.startedColumn || this.columnsCount > 0 || !this.userSettings.skipEmptyRecords) {
                        this.endColumn();
                        this.endRecord();
                    } else {
                        this.dataBuffer.lineStart = this.dataBuffer.position + 1;
                    }
                    this.lastLetter = currentLetter;
                } else if (!(this.useCustomRecordDelimiter || currentLetter != Letters.CR.code && currentLetter != Letters.LF.code)) {
                    if (this.startedColumn || this.columnsCount > 0 || !this.userSettings.skipEmptyRecords && (currentLetter == Letters.CR.code || this.lastLetter != Letters.CR.code)) {
                        this.endColumn();
                        this.endRecord();
                    } else {
                        this.dataBuffer.lineStart = this.dataBuffer.position + 1;
                    }
                    this.lastLetter = currentLetter;
                } else if (this.userSettings.useComments && this.columnsCount == 0 && currentLetter == this.userSettings.comment) {
                    this.lastLetter = currentLetter;
                    this.skipLine();
                } else if (this.userSettings.trimWhitespace && (currentLetter == Letters.SPACE.code || currentLetter == Letters.TAB.code)) {
                    this.startedColumn = true;
                    this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                } else {
                    this.startedColumn = true;
                    this.dataBuffer.columnStart = this.dataBuffer.position;
                    boolean lastLetterWasBackslash = false;
                    boolean readingComplexEscape = false;
                    int escape = 1;
                    int escapeLength = 0;
                    char escapeValue = '\u0000';
                    boolean firstLoop = true;
                    do {
                        if (!firstLoop && this.dataBuffer.position == this.dataBuffer.count) {
                            this.checkDataLength();
                            continue;
                        }
                        if (!firstLoop) {
                            currentLetter = this.dataBuffer.buffer[this.dataBuffer.position];
                        }
                        if (!this.userSettings.useTextQualifier && this.userSettings.escapeMode == 2 && currentLetter == Letters.BACKSLASH.code) {
                            if (lastLetterWasBackslash) {
                                lastLetterWasBackslash = false;
                            } else {
                                this.updateCurrentValue();
                                lastLetterWasBackslash = true;
                            }
                        } else if (readingComplexEscape) {
                            ++escapeLength;
                            switch (escape) {
                                case 1: {
                                    escapeValue = (char)(escapeValue * 16);
                                    escapeValue = (char)(escapeValue + CsvReader.hexToDec(currentLetter));
                                    if (escapeLength != 4) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                                case 2: {
                                    escapeValue = (char)(escapeValue * 8);
                                    escapeValue = (char)(escapeValue + (char)(currentLetter - 48));
                                    if (escapeLength != 3) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                                case 3: {
                                    escapeValue = (char)(escapeValue * 10);
                                    escapeValue = (char)(escapeValue + (char)(currentLetter - 48));
                                    if (escapeLength != 3) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                                case 4: {
                                    escapeValue = (char)(escapeValue * 16);
                                    escapeValue = (char)(escapeValue + CsvReader.hexToDec(currentLetter));
                                    if (escapeLength != 2) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                            }
                            if (!readingComplexEscape) {
                                this.appendLetter(escapeValue);
                            } else {
                                this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                            }
                        } else if (this.userSettings.escapeMode == 2 && lastLetterWasBackslash) {
                            switch (currentLetter) {
                                case 'n': {
                                    this.appendLetter(Letters.LF.code);
                                    break;
                                }
                                case 'r': {
                                    this.appendLetter(Letters.CR.code);
                                    break;
                                }
                                case 't': {
                                    this.appendLetter(Letters.TAB.code);
                                    break;
                                }
                                case 'b': {
                                    this.appendLetter(Letters.BACKSPACE.code);
                                    break;
                                }
                                case 'f': {
                                    this.appendLetter(Letters.FORM_FEED.code);
                                    break;
                                }
                                case 'e': {
                                    this.appendLetter(Letters.ESCAPE.code);
                                    break;
                                }
                                case 'v': {
                                    this.appendLetter(Letters.VERTICAL_TAB.code);
                                    break;
                                }
                                case 'a': {
                                    this.appendLetter(Letters.ALERT.code);
                                    break;
                                }
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': {
                                    escape = 2;
                                    readingComplexEscape = true;
                                    escapeLength = 1;
                                    escapeValue = (char)(currentLetter - 48);
                                    this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                                    break;
                                }
                                case 'D': 
                                case 'O': 
                                case 'U': 
                                case 'X': 
                                case 'd': 
                                case 'o': 
                                case 'u': 
                                case 'x': {
                                    switch (currentLetter) {
                                        case 'U': 
                                        case 'u': {
                                            escape = 1;
                                            break;
                                        }
                                        case 'X': 
                                        case 'x': {
                                            escape = 4;
                                            break;
                                        }
                                        case 'O': 
                                        case 'o': {
                                            escape = 2;
                                            break;
                                        }
                                        case 'D': 
                                        case 'd': {
                                            escape = 3;
                                            break;
                                        }
                                    }
                                    readingComplexEscape = true;
                                    escapeLength = 0;
                                    escapeValue = '\u0000';
                                    this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                                    break;
                                }
                            }
                            lastLetterWasBackslash = false;
                        } else if (currentLetter == this.userSettings.delimiter) {
                            this.endColumn();
                        } else if (!this.useCustomRecordDelimiter && (currentLetter == Letters.CR.code || currentLetter == Letters.LF.code) || this.useCustomRecordDelimiter && currentLetter == this.userSettings.recordDelimiter) {
                            this.endColumn();
                            this.endRecord();
                        }
                        this.lastLetter = currentLetter;
                        firstLoop = false;
                        if (!this.startedColumn) continue;
                        ++this.dataBuffer.position;
                        if (!this.userSettings.safetySwitch || this.dataBuffer.position - this.dataBuffer.columnStart + this.columnBuffer.position <= 100000) continue;
                        this.close();
                        throw new IOException("Maximum column length of 100,000 exceeded in column " + NumberFormat.getIntegerInstance().format(this.columnsCount) + " in record " + NumberFormat.getIntegerInstance().format(this.currentRecord) + ". Set the SafetySwitch property to false if you're expecting column lengths greater than 100,000 characters to avoid this error.");
                    } while (this.hasMoreData && this.startedColumn);
                }
                if (!this.hasMoreData) continue;
                ++this.dataBuffer.position;
            } while (this.hasMoreData && !this.hasReadNextLine);
            if (this.startedColumn || this.lastLetter == this.userSettings.delimiter) {
                this.endColumn();
                this.endRecord();
            }
        }
        this.rawRecord = this.userSettings.captureRawRecord ? (this.hasMoreData ? (this.rawBuffer.position == 0 ? new String(this.dataBuffer.buffer, this.dataBuffer.lineStart, this.dataBuffer.position - this.dataBuffer.lineStart - 1) : new String(this.rawBuffer.buffer, 0, this.rawBuffer.position) + new String(this.dataBuffer.buffer, this.dataBuffer.lineStart, this.dataBuffer.position - this.dataBuffer.lineStart - 1)) : new String(this.rawBuffer.buffer, 0, this.rawBuffer.position)) : "";
        return this.hasReadNextLine;
    }

    private void checkDataLength() throws IOException {
        this.updateCurrentValue();
        if (this.userSettings.captureRawRecord && this.dataBuffer.count > 0) {
            if (this.rawBuffer.buffer.length - this.rawBuffer.position < this.dataBuffer.count - this.dataBuffer.lineStart) {
                int newLength = this.rawBuffer.buffer.length + Math.max(this.dataBuffer.count - this.dataBuffer.lineStart, this.rawBuffer.buffer.length);
                char[] holder = new char[newLength];
                System.arraycopy(this.rawBuffer.buffer, 0, holder, 0, this.rawBuffer.position);
                this.rawBuffer.buffer = holder;
            }
            System.arraycopy(this.dataBuffer.buffer, this.dataBuffer.lineStart, this.rawBuffer.buffer, this.rawBuffer.position, this.dataBuffer.count - this.dataBuffer.lineStart);
            this.rawBuffer.position += this.dataBuffer.count - this.dataBuffer.lineStart;
        }
        try {
            this.dataBuffer.count = this.inputStream.read(this.dataBuffer.buffer, 0, this.dataBuffer.buffer.length);
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
        if (this.dataBuffer.count == -1) {
            this.hasMoreData = false;
        }
        this.dataBuffer.position = 0;
        this.dataBuffer.lineStart = 0;
        this.dataBuffer.columnStart = 0;
    }

    public boolean readHeaders() throws IOException {
        boolean result = this.readRecord();
        this.headersHolder.length = this.columnsCount;
        this.headersHolder.headers = new String[this.columnsCount];
        for (int i = 0; i < this.headersHolder.length; ++i) {
            String columnValue;
            this.headersHolder.headers[i] = columnValue = this.get(i);
            this.headersHolder.indexByName.put(columnValue, i);
        }
        if (result) {
            --this.currentRecord;
        }
        this.columnsCount = 0;
        return result;
    }

    public String getHeader(int columnIndex) throws IOException {
        this.checkClosed();
        if (columnIndex > -1 && columnIndex < this.headersHolder.length) {
            return this.headersHolder.headers[columnIndex];
        }
        return "";
    }

    public boolean isQualified(int columnIndex) throws IOException {
        this.checkClosed();
        if (columnIndex < this.columnsCount && columnIndex > -1) {
            return this.isQualified[columnIndex];
        }
        return false;
    }

    private void endColumn() throws IOException {
        String currentValue = "";
        if (this.startedColumn) {
            if (this.columnBuffer.position == 0) {
                if (this.dataBuffer.columnStart < this.dataBuffer.position) {
                    if (this.userSettings.trimWhitespace && !this.startedWithQualifier) {
                        for (innerLastLetter = this.dataBuffer.position - 1; innerLastLetter >= this.dataBuffer.columnStart && (this.dataBuffer.buffer[innerLastLetter] == Letters.SPACE.code || this.dataBuffer.buffer[innerLastLetter] == Letters.TAB.code); --innerLastLetter) {
                        }
                    }
                    currentValue = new String(this.dataBuffer.buffer, this.dataBuffer.columnStart, innerLastLetter - this.dataBuffer.columnStart + 1);
                }
            } else {
                this.updateCurrentValue();
                if (this.userSettings.trimWhitespace && !this.startedWithQualifier) {
                    for (innerLastLetter = this.columnBuffer.position - 1; innerLastLetter >= 0 && this.columnBuffer.buffer[innerLastLetter] == Letters.SPACE.code; --innerLastLetter) {
                    }
                }
                currentValue = new String(this.columnBuffer.buffer, 0, innerLastLetter + 1);
            }
        }
        this.columnBuffer.position = 0;
        this.startedColumn = false;
        if (this.columnsCount >= 100000 && this.userSettings.safetySwitch) {
            this.close();
            throw new IOException("Maximum column count of 100,000 exceeded in record " + NumberFormat.getIntegerInstance().format(this.currentRecord) + ". Set the SafetySwitch property to false if you're expecting more than 100,000 columns per record to avoid this error.");
        }
        if (this.columnsCount == this.values.length) {
            int newLength = this.values.length * 2;
            String[] holder = new String[newLength];
            System.arraycopy(this.values, 0, holder, 0, this.values.length);
            this.values = holder;
            boolean[] qualifiedHolder = new boolean[newLength];
            System.arraycopy(this.isQualified, 0, qualifiedHolder, 0, this.isQualified.length);
            this.isQualified = qualifiedHolder;
        }
        this.values[this.columnsCount] = currentValue;
        this.isQualified[this.columnsCount] = this.startedWithQualifier;
        ++this.columnsCount;
    }

    private void appendLetter(char letter) {
        if (this.columnBuffer.position == this.columnBuffer.buffer.length) {
            int newLength = this.columnBuffer.buffer.length * 2;
            char[] holder = new char[newLength];
            System.arraycopy(this.columnBuffer.buffer, 0, holder, 0, this.columnBuffer.position);
            this.columnBuffer.buffer = holder;
        }
        this.columnBuffer.buffer[this.columnBuffer.position++] = letter;
        this.dataBuffer.columnStart = this.dataBuffer.position + 1;
    }

    private void updateCurrentValue() {
        if (this.startedColumn && this.dataBuffer.columnStart < this.dataBuffer.position) {
            if (this.columnBuffer.buffer.length - this.columnBuffer.position < this.dataBuffer.position - this.dataBuffer.columnStart) {
                int newLength = this.columnBuffer.buffer.length + Math.max(this.dataBuffer.position - this.dataBuffer.columnStart, this.columnBuffer.buffer.length);
                char[] holder = new char[newLength];
                System.arraycopy(this.columnBuffer.buffer, 0, holder, 0, this.columnBuffer.position);
                this.columnBuffer.buffer = holder;
            }
            System.arraycopy(this.dataBuffer.buffer, this.dataBuffer.columnStart, this.columnBuffer.buffer, this.columnBuffer.position, this.dataBuffer.position - this.dataBuffer.columnStart);
            this.columnBuffer.position += this.dataBuffer.position - this.dataBuffer.columnStart;
        }
        this.dataBuffer.columnStart = this.dataBuffer.position + 1;
    }

    private void endRecord() {
        this.hasReadNextLine = true;
        ++this.currentRecord;
    }

    public int getIndex(String headerName) throws IOException {
        this.checkClosed();
        Integer indexValue = this.headersHolder.indexByName.get(headerName);
        if (indexValue != null) {
            return indexValue;
        }
        return -1;
    }

    public boolean skipRecord() throws IOException {
        this.checkClosed();
        boolean recordRead = false;
        if (this.hasMoreData && (recordRead = this.readRecord())) {
            --this.currentRecord;
        }
        return recordRead;
    }

    public boolean skipLine() throws IOException {
        this.checkClosed();
        this.columnsCount = 0;
        boolean skippedLine = false;
        if (this.hasMoreData) {
            boolean foundEol = false;
            do {
                if (this.dataBuffer.position == this.dataBuffer.count) {
                    this.checkDataLength();
                    continue;
                }
                skippedLine = true;
                char currentLetter = this.dataBuffer.buffer[this.dataBuffer.position];
                if (currentLetter == Letters.CR.code || currentLetter == Letters.LF.code) {
                    foundEol = true;
                }
                this.lastLetter = currentLetter;
                if (foundEol) continue;
                ++this.dataBuffer.position;
            } while (this.hasMoreData && !foundEol);
            this.columnBuffer.position = 0;
            this.dataBuffer.lineStart = this.dataBuffer.position + 1;
        }
        this.rawBuffer.position = 0;
        this.rawRecord = "";
        return skippedLine;
    }

    public void close() {
        if (!this.closed) {
            this.close(true);
            this.closed = true;
        }
    }

    private void close(boolean closing) {
        if (!this.closed) {
            if (closing) {
                this.headersHolder.headers = null;
                this.headersHolder.indexByName = null;
                this.dataBuffer.buffer = null;
                this.columnBuffer.buffer = null;
                this.rawBuffer.buffer = null;
            }
            try {
                this.inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.inputStream = null;
            this.closed = true;
        }
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("This instance of the CsvReader class has already been closed.");
        }
    }

    private static char hexToDec(char hex) {
        char result = hex >= 'a' ? (char)(hex - 97 + 10) : (hex >= 'A' ? (char)(hex - 65 + 10) : (char)(hex - 48));
        return result;
    }

    private class StaticSettings {
        public static final int MAX_BUFFER_SIZE = 1024;
        public static final int MAX_FILE_BUFFER_SIZE = 4096;
        public static final int INITIAL_COLUMN_COUNT = 10;
        public static final int INITIAL_COLUMN_BUFFER_SIZE = 50;

        private StaticSettings(CsvReader csvReader) {
        }
    }

    private static enum Letters {
        LF('\n'),
        CR('\r'),
        QUOTE('\"'),
        SEMICOLON(';'),
        COMMA(','),
        SPACE(' '),
        TAB('\t'),
        POUND('#'),
        BACKSLASH('\\'),
        NULL('\u0000'),
        BACKSPACE('\b'),
        FORM_FEED('\f'),
        ESCAPE('\u001b'),
        VERTICAL_TAB('\u000b'),
        ALERT('\u0007');

        public final char code;

        private Letters(char code) {
            this.code = code;
        }
    }

    private class UserSettings {
        public char textQualifier;
        public boolean trimWhitespace;
        public boolean useTextQualifier;
        public char delimiter;
        public char recordDelimiter;
        public char comment;
        public boolean useComments;
        public int escapeMode;
        public boolean safetySwitch;
        public boolean skipEmptyRecords;
        public boolean captureRawRecord;

        public UserSettings(CsvReader csvReader) {
            this.textQualifier = Letters.QUOTE.code;
            this.trimWhitespace = true;
            this.useTextQualifier = true;
            this.delimiter = Letters.SEMICOLON.code;
            this.recordDelimiter = Letters.NULL.code;
            this.useComments = false;
            this.escapeMode = 1;
            this.safetySwitch = true;
            this.skipEmptyRecords = true;
            this.captureRawRecord = true;
        }
    }

    private class DataBuffer {
        public char[] buffer = new char[1024];
        public int position = 0;
        public int count = 0;
        public int columnStart = 0;
        public int lineStart = 0;

        public DataBuffer(CsvReader csvReader) {
        }
    }

    private class ColumnBuffer {
        public char[] buffer = new char[50];
        public int position = 0;

        public ColumnBuffer(CsvReader csvReader) {
        }
    }

    private class RawRecordBuffer {
        public char[] buffer = new char[500];
        public int position = 0;

        public RawRecordBuffer(CsvReader csvReader) {
        }
    }

    private class HeadersHolder {
        public String[] headers = null;
        public int length = 0;
        public Map<String, Integer> indexByName = new LinkedHashMap<String, Integer>();

        public HeadersHolder(CsvReader csvReader) {
        }
    }

    private class ComplexEscape {
        private static final int UNICODE = 1;
        private static final int OCTAL = 2;
        private static final int DECIMAL = 3;
        private static final int HEX = 4;

        private ComplexEscape(CsvReader csvReader) {
        }
    }
}

