/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.cypher;

import es.prodevelop.pui9.cypher.AesGcmCypher;
import java.util.Base64;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;

public class PuiCypherData {
    private String encodedKey;
    private String encodedIv;
    private SecretKey secretKey;
    private byte[] decodedIv;

    private PuiCypherData(String encodedKey, String encodedIv) {
        this.encodedKey = encodedKey;
        this.encodedIv = encodedIv;
    }

    public SecretKey getSecretKey() {
        if (this.secretKey == null) {
            byte[] decodedKey = Base64.getDecoder().decode(this.encodedKey);
            this.secretKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, "AES");
        }
        return this.secretKey;
    }

    public byte[] getDecodedIv() {
        if (this.decodedIv == null) {
            this.decodedIv = Base64.getDecoder().decode(this.encodedIv);
        }
        return this.decodedIv;
    }

    public String encrypt(String decrypted) {
        return AesGcmCypher.encrypt(this, decrypted);
    }

    public String decrypt(String encrypted) {
        return AesGcmCypher.decrypt(this, encrypted);
    }

    @Generated
    public static PuiCypherDataBuilder builder() {
        return new PuiCypherDataBuilder();
    }

    @Generated
    public static class PuiCypherDataBuilder {
        @Generated
        private String encodedKey;
        @Generated
        private String encodedIv;

        @Generated
        PuiCypherDataBuilder() {
        }

        @Generated
        public PuiCypherDataBuilder encodedKey(String encodedKey) {
            this.encodedKey = encodedKey;
            return this;
        }

        @Generated
        public PuiCypherDataBuilder encodedIv(String encodedIv) {
            this.encodedIv = encodedIv;
            return this;
        }

        @Generated
        public PuiCypherData build() {
            return new PuiCypherData(this.encodedKey, this.encodedIv);
        }

        @Generated
        public String toString() {
            return "PuiCypherData.PuiCypherDataBuilder(encodedKey=" + this.encodedKey + ", encodedIv=" + this.encodedIv + ")";
        }
    }
}

