/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.json.adapters;

import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import es.prodevelop.pui9.json.adapters.AbstractPuiGsonTypeAdapter;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractNumberTypeAdapter<N extends Number>
extends AbstractPuiGsonTypeAdapter<N> {
    public void write(JsonWriter out, N value) throws IOException {
        out.value(value);
    }

    public N read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        try {
            String result = in.nextString();
            if (StringUtils.isEmpty((CharSequence)result)) {
                return null;
            }
            return this.parse(result);
        }
        catch (NumberFormatException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
    }

    protected abstract N parse(String var1);
}

