/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.utils;

import es.prodevelop.pui9.utils.PuiConstants;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class PuiLanguage
implements Comparable<PuiLanguage>,
Comparator<PuiLanguage> {
    public static final PuiLanguage DEFAULT_LANG = new PuiLanguage("es");
    private String isocode;
    private String country;
    private String name;
    private Integer isdefault = PuiConstants.FALSE_INT;

    public PuiLanguage() {
    }

    public PuiLanguage(Locale locale) {
        this(locale.getLanguage());
        this.country = StringUtils.isEmpty((CharSequence)locale.getCountry()) ? "" : locale.getCountry();
    }

    public PuiLanguage(String isocode) {
        this.isocode = isocode;
        this.country = "";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        PuiLanguage other = (PuiLanguage)obj;
        return Objects.equals(this.isocode, other.isocode);
    }

    public int hashCode() {
        HashCodeBuilder hcBuilder = new HashCodeBuilder();
        hcBuilder.append((Object)this.isocode);
        return hcBuilder.toHashCode();
    }

    @Override
    public int compare(PuiLanguage o1, PuiLanguage o2) {
        return o1.isocode.compareTo(o2.isocode);
    }

    @Override
    public int compareTo(PuiLanguage o) {
        return this.isocode.compareTo(o.getIsocode());
    }

    public String toString() {
        return this.isocode;
    }

    @Generated
    public String getIsocode() {
        return this.isocode;
    }

    @Generated
    public String getCountry() {
        return this.country;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getIsdefault() {
        return this.isdefault;
    }

    @Generated
    public void setIsocode(String isocode) {
        this.isocode = isocode;
    }

    @Generated
    public void setCountry(String country) {
        this.country = country;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setIsdefault(Integer isdefault) {
        this.isdefault = isdefault;
    }
}

