/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.classpath;

import es.prodevelop.pui9.threads.PuiBackgroundExecutors;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public class PuiClassLoaderSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PuiClassLoaderSupport.class);
    private static final String CLASSPATH_FOLDER = "pui9-classpath";
    private static final String BASE_APP_FOLDER = "BOOT-INF/classes/";
    private static final String BASE_APP_JAR = "app.jar";
    private static final String NESTED_JAR = "jar:nested:";
    private static ClassLoader mainClassLoader;
    private static List<File> classPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> getClasspath() {
        List<File> list = classPath;
        synchronized (list) {
            if (classPath.isEmpty()) {
                PuiClassLoaderSupport.fillClassPath();
            }
        }
        return classPath;
    }

    public static void addFileToClasspath(File file) {
        Object urlClassPath = PuiClassLoaderSupport.getUrlClassPath(mainClassLoader != null ? mainClassLoader : Thread.currentThread().getContextClassLoader());
        if (urlClassPath == null) {
            return;
        }
        Method getURLsMethod = ReflectionUtils.findMethod(urlClassPath.getClass(), (String)"addURL", (Class[])new Class[]{URL.class});
        if (getURLsMethod == null) {
            return;
        }
        ReflectionUtils.makeAccessible((Method)getURLsMethod);
        try {
            getURLsMethod.invoke(urlClassPath, file.toURI().toURL());
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | MalformedURLException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private static void fillClassPath() {
        URL[] urls;
        for (URL url : urls = PuiClassLoaderSupport.getURLs()) {
            classPath.add(new File(url.getPath()));
        }
        if (PuiClassLoaderSupport.getClassPathTempFolder(false).exists()) {
            PuiBackgroundExecutors.getSingleton().registerNewExecutorOneShot("PURGE_CLASSPATH_TEMP_FOLDER", true, 5L, TimeUnit.MINUTES, () -> PuiClassLoaderSupport.deleteClassPathTempFolder());
        }
    }

    private static URL[] getURLs() {
        ArrayList urls = new ArrayList();
        for (ClassLoader cl = Thread.currentThread().getContextClassLoader(); cl != null; cl = cl.getParent()) {
            URL[] clUrls = PuiClassLoaderSupport.extractURLsFromClassLoader(cl);
            if (clUrls.length <= 0) continue;
            if (mainClassLoader == null && clUrls.length > 0) {
                mainClassLoader = cl;
            }
            Arrays.stream(clUrls).map(url -> PuiClassLoaderSupport.isNestedJar(url) ? PuiClassLoaderSupport.convertNestedJarUrl(url) : url).filter(Objects::nonNull).forEach(urls::add);
        }
        return urls.toArray(new URL[0]);
    }

    private static URL[] extractURLsFromClassLoader(ClassLoader cl) {
        Object urlClassPath = PuiClassLoaderSupport.getUrlClassPath(cl);
        if (urlClassPath == null) {
            return new URL[0];
        }
        Method getURLsMethod = ReflectionUtils.findMethod(urlClassPath.getClass(), (String)"getURLs");
        if (getURLsMethod == null) {
            return new URL[0];
        }
        ReflectionUtils.makeAccessible((Method)getURLsMethod);
        try {
            return (URL[])getURLsMethod.invoke(urlClassPath, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            log.error("Failed to invoke getURLs on " + urlClassPath.getClass().getName(), (Throwable)e);
            return new URL[0];
        }
    }

    private static Object getUrlClassPath(ClassLoader cl) {
        Field ucpField = ReflectionUtils.findField(cl.getClass(), (String)"ucp");
        if (ucpField == null) {
            return null;
        }
        ReflectionUtils.makeAccessible((Field)ucpField);
        try {
            return ucpField.get(cl);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static boolean isNestedJar(URL url) {
        return url.toExternalForm().startsWith(NESTED_JAR);
    }

    private static URL convertNestedJarUrl(URL url) {
        String path = url.toExternalForm();
        if (path.contains(BASE_APP_FOLDER)) {
            return PuiClassLoaderSupport.convertBaseAppFolder(url);
        }
        return PuiClassLoaderSupport.convertThirdPartyJar(url);
    }

    private static File getClassPathTempFolder(boolean create) {
        File folder = new File(FileUtils.getTempDirectory(), CLASSPATH_FOLDER);
        if (create) {
            folder.mkdir();
        }
        return folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteClassPathTempFolder() {
        File classpathTempFolder = PuiClassLoaderSupport.getClassPathTempFolder(false);
        try {
            if (classpathTempFolder.exists()) {
                FileUtils.deleteDirectory((File)classpathTempFolder);
            }
            List<File> list = classPath;
            synchronized (list) {
                classPath.clear();
            }
        }
        catch (IOException e) {
            log.error("Deleting {} directory", (Object)classpathTempFolder, (Object)e);
        }
    }

    private static URL convertBaseAppFolder(URL url) {
        URL uRL;
        File classpathTempFolder = PuiClassLoaderSupport.getClassPathTempFolder(true);
        String path = url.toExternalForm();
        String jarFilePath = path.substring(NESTED_JAR.length(), path.indexOf("/!"));
        File mainJarFile = new File(jarFilePath);
        JarFile jarFile = new JarFile(mainJarFile);
        try {
            File appJar = new File(classpathTempFolder, BASE_APP_JAR);
            try (JarOutputStream jos = new JarOutputStream(new FileOutputStream(appJar));){
                jarFile.stream().filter(e -> e.getName().startsWith(BASE_APP_FOLDER) && !e.isDirectory()).forEach(e -> {
                    try {
                        JarEntry entry = new JarEntry(e.getName().substring(BASE_APP_FOLDER.length()));
                        jos.putNextEntry(entry);
                        jarFile.getInputStream((ZipEntry)e).transferTo(jos);
                        jos.closeEntry();
                    }
                    catch (IOException ex) {
                        log.error("Reading the entry {} from JAR file", (Object)e.getName(), (Object)ex);
                    }
                });
            }
            uRL = appJar.toURI().toURL();
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e2) {
                log.error("Error creating temporal JAR file for web module", (Throwable)e2);
                return null;
            }
        }
        jarFile.close();
        return uRL;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static URL convertThirdPartyJar(URL url) {
        String subPath;
        int lastSlash;
        File classpathTempFolder = PuiClassLoaderSupport.getClassPathTempFolder(true);
        String path = url.toExternalForm();
        String fileName = "";
        int lastBang = path.lastIndexOf("!/");
        if (lastBang != -1 && (lastSlash = (subPath = path.substring(0, lastBang)).lastIndexOf(47)) != -1) {
            fileName = subPath.substring(lastSlash + 1);
        }
        if (ObjectUtils.isEmpty((Object)fileName)) {
            return null;
        }
        try (InputStream in = url.openStream();){
            File file = new File(classpathTempFolder, fileName);
            boolean created = file.createNewFile();
            if (!created) {
                URL uRL2 = null;
                return uRL2;
            }
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            URL uRL = file.toURI().toURL();
            return uRL;
        }
        catch (Exception e) {
            log.error("Error creating temporal JAR file for third party JAR", (Throwable)e);
            return null;
        }
    }

    private PuiClassLoaderSupport() {
    }

    static {
        classPath = new ArrayList<File>();
    }
}

