/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.json.adapters;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import es.prodevelop.pui9.json.adapters.AbstractPuiGsonTypeAdapter;
import es.prodevelop.pui9.utils.PuiDateUtil;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import org.springframework.util.ObjectUtils;

public class InstantTypeAdapter
extends AbstractPuiGsonTypeAdapter<Instant> {
    @Override
    public Class<Instant> getType() {
        return Instant.class;
    }

    public void write(JsonWriter out, Instant instant) throws IOException {
        String value = null;
        if (instant != null) {
            value = PuiDateUtil.temporalAccessorToString(instant);
        }
        out.value(value);
    }

    public Instant read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        String value = in.nextString();
        if (ObjectUtils.isEmpty((Object)value)) {
            return null;
        }
        Instant instant = PuiDateUtil.stringToInstant(value);
        if (instant == null) {
            throw new DateTimeParseException("Datetime format not supported. Only format yyyy-MM-dd'T'HH:mm:ss'Z' is supported", value, 0);
        }
        return instant;
    }
}

