/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.utils;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import org.springframework.util.ObjectUtils;

public class PuiDateUtil {
    public static final ZoneId utcZone = ZoneId.of("UTC");
    public static final ZoneId europeMadridZone = ZoneId.of("Europe/Madrid");
    public static final DateTimeFormatter isoInstantMilliseconds = new DateTimeFormatterBuilder().appendInstant(3).toFormatter();
    public static final DateTimeFormatter isoInstantNoMilliseconds = DateTimeFormatter.ISO_INSTANT.withZone(utcZone);
    public static final String DEFAULT_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String DEFAULT_FORMAT_WITH_MILLIS = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final String SEP = "{sep}";
    private static final String DIGITS_2 = "\\d{1,2}";
    private static final String DIGITS_2_MULTIPLE = "\\d{1,2}.*";
    private static final String DIGITS_4 = "\\d{4}";
    private static final String DIGITS_4_MULTIPLE = "\\d{4}.*";
    private static final String DAY = "dd";
    private static final String MONTH = "MM";
    private static final String YEAR = "yyyy";

    public static Instant stringToInstant(String value) {
        return PuiDateUtil.stringToInstant(value, null);
    }

    public static LocalDate stringToLocalDate(String value, ZoneId zoneId) {
        if (ObjectUtils.isEmpty((Object)value)) {
            return null;
        }
        String dateFormat = PuiDateUtil.getDateFormat(value);
        if (ObjectUtils.isEmpty((Object)dateFormat)) {
            return null;
        }
        if (zoneId == null) {
            zoneId = utcZone;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateFormat).withZone(zoneId);
        try {
            return LocalDate.parse(value, formatter);
        }
        catch (DateTimeException e) {
            return null;
        }
    }

    public static LocalDateTime stringToLocalDateTime(String value, ZoneId zoneId) {
        if (value.contains("T") && value.contains("Z")) {
            Instant instant = Instant.parse(value);
            instant = PuiDateUtil.roundInstantNanosToThreeDecimals(instant);
            return LocalDateTime.ofInstant(instant, zoneId);
        }
        String dateFormat = PuiDateUtil.getDateFormat(value);
        if (ObjectUtils.isEmpty((Object)dateFormat)) {
            return null;
        }
        String timeFormat = PuiDateUtil.getTimeFormat(value, dateFormat);
        if (ObjectUtils.isEmpty((Object)timeFormat)) {
            LocalDate ld = PuiDateUtil.stringToLocalDate(value, zoneId);
            return ld != null ? ld.atStartOfDay() : null;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateFormat + timeFormat).withZone(zoneId);
        try {
            return LocalDateTime.parse(value, formatter);
        }
        catch (DateTimeException e) {
            formatter = DateTimeFormatter.ofPattern(dateFormat + " " + timeFormat).withZone(zoneId);
            try {
                return LocalDateTime.parse(value, formatter);
            }
            catch (DateTimeException e2) {
                return null;
            }
        }
    }

    public static ZonedDateTime stringToZonedDateTime(String value, ZoneId zoneId) {
        if (value.contains("T") && value.contains("Z")) {
            Instant instant;
            try {
                instant = Instant.parse(value);
            }
            catch (Exception e) {
                instant = null;
            }
            if (instant == null) {
                return null;
            }
            instant = PuiDateUtil.roundInstantNanosToThreeDecimals(instant);
            return instant.atZone(zoneId);
        }
        String dateFormat = PuiDateUtil.getDateFormat(value);
        if (ObjectUtils.isEmpty((Object)dateFormat)) {
            return null;
        }
        String timeFormat = PuiDateUtil.getTimeFormat(value, dateFormat);
        if (ObjectUtils.isEmpty((Object)timeFormat)) {
            LocalDate ld = PuiDateUtil.stringToLocalDate(value, zoneId);
            return ld != null ? ld.atStartOfDay(zoneId) : null;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateFormat + timeFormat).withZone(zoneId);
        try {
            return ZonedDateTime.parse(value, formatter);
        }
        catch (DateTimeException e1) {
            formatter = DateTimeFormatter.ofPattern(dateFormat + " " + timeFormat).withZone(zoneId);
            try {
                return ZonedDateTime.parse(value, formatter);
            }
            catch (DateTimeException e2) {
                return null;
            }
        }
    }

    public static Instant stringToInstant(String value, DateTimeFormatter formatter) {
        if (ObjectUtils.isEmpty((Object)value)) {
            return null;
        }
        if (formatter == null) {
            try {
                return PuiDateUtil.roundInstantNanosToThreeDecimals(Instant.from(isoInstantMilliseconds.parse(value)));
            }
            catch (DateTimeException e) {
                try {
                    return PuiDateUtil.roundInstantNanosToThreeDecimals(Instant.from(isoInstantNoMilliseconds.parse(value)));
                }
                catch (DateTimeException dateTimeException) {
                    String dateFormat = PuiDateUtil.getDateFormat(value);
                    if (ObjectUtils.isEmpty((Object)dateFormat)) {
                        return null;
                    }
                    String timeFormat = PuiDateUtil.getTimeFormat(value, dateFormat);
                    if (ObjectUtils.isEmpty((Object)timeFormat)) {
                        formatter = DateTimeFormatter.ofPattern(dateFormat).withZone(utcZone);
                        try {
                            return PuiDateUtil.roundInstantNanosToThreeDecimals(LocalDate.parse(value, formatter).atStartOfDay().atZone(utcZone).toInstant());
                        }
                        catch (DateTimeException e2) {
                            return null;
                        }
                    }
                    formatter = DateTimeFormatter.ofPattern(dateFormat + timeFormat).withZone(utcZone);
                    try {
                        return PuiDateUtil.roundInstantNanosToThreeDecimals(LocalDateTime.parse(value, formatter).atZone(utcZone).toInstant());
                    }
                    catch (DateTimeException e1) {
                        formatter = DateTimeFormatter.ofPattern(dateFormat + " " + timeFormat).withZone(utcZone);
                        try {
                            return PuiDateUtil.roundInstantNanosToThreeDecimals(LocalDateTime.parse(value, formatter).atZone(utcZone).toInstant());
                        }
                        catch (DateTimeException e2) {
                            return null;
                        }
                    }
                }
            }
        }
        try {
            return PuiDateUtil.roundInstantNanosToThreeDecimals(Instant.from(formatter.parse(value)));
        }
        catch (DateTimeException e) {
            return null;
        }
    }

    public static boolean stringHasHours(String value) {
        String dateFormat = PuiDateUtil.getDateFormat(value);
        if (ObjectUtils.isEmpty((Object)dateFormat)) {
            return false;
        }
        String timeFormat = PuiDateUtil.getTimeFormat(value, dateFormat);
        if (ObjectUtils.isEmpty((Object)timeFormat)) {
            return false;
        }
        return TimeFormats.HOUR2.matchFormat(timeFormat) || TimeFormats.HOUR1.matchFormat(timeFormat) || TimeFormats.HOUR2_MINUTE.matchFormat(timeFormat) || TimeFormats.HOUR1_MINUTE.matchFormat(timeFormat) || TimeFormats.HOUR2_MINUTE_SECOND.matchFormat(timeFormat) || TimeFormats.HOUR1_MINUTE_SECOND.matchFormat(timeFormat) || TimeFormats.HOUR_MINUTE_SECOND_TZ.matchFormat(timeFormat) || TimeFormats.HOUR_MINUTE_SECOND_MILLISECOND.matchFormat(timeFormat) || TimeFormats.HOUR_MINUTE_SECOND_MILLISECOND_TZ.matchFormat(timeFormat);
    }

    public static boolean stringHasMinutes(String value) {
        String dateFormat = PuiDateUtil.getDateFormat(value);
        if (ObjectUtils.isEmpty((Object)dateFormat)) {
            return false;
        }
        String timeFormat = PuiDateUtil.getTimeFormat(value, dateFormat);
        if (ObjectUtils.isEmpty((Object)timeFormat)) {
            return false;
        }
        return TimeFormats.HOUR2_MINUTE.matchFormat(timeFormat) || TimeFormats.HOUR1_MINUTE.matchFormat(timeFormat) || TimeFormats.HOUR2_MINUTE_SECOND.matchFormat(timeFormat) || TimeFormats.HOUR1_MINUTE_SECOND.matchFormat(timeFormat) || TimeFormats.HOUR_MINUTE_SECOND_TZ.matchFormat(timeFormat) || TimeFormats.HOUR_MINUTE_SECOND_MILLISECOND.matchFormat(timeFormat) || TimeFormats.HOUR_MINUTE_SECOND_MILLISECOND_TZ.matchFormat(timeFormat);
    }

    public static boolean stringHasSeconds(String value) {
        String dateFormat = PuiDateUtil.getDateFormat(value);
        if (ObjectUtils.isEmpty((Object)dateFormat)) {
            return false;
        }
        String timeFormat = PuiDateUtil.getTimeFormat(value, dateFormat);
        if (ObjectUtils.isEmpty((Object)timeFormat)) {
            return false;
        }
        return TimeFormats.HOUR2_MINUTE_SECOND.matchFormat(timeFormat) || TimeFormats.HOUR1_MINUTE_SECOND.matchFormat(timeFormat) || TimeFormats.HOUR_MINUTE_SECOND_TZ.matchFormat(timeFormat) || TimeFormats.HOUR_MINUTE_SECOND_MILLISECOND.matchFormat(timeFormat) || TimeFormats.HOUR_MINUTE_SECOND_MILLISECOND_TZ.matchFormat(timeFormat);
    }

    public static String temporalAccessorToString(TemporalAccessor temporalAccessor) {
        return PuiDateUtil.temporalAccessorToString(temporalAccessor, null);
    }

    public static String temporalAccessorToString(TemporalAccessor temporalAccessor, DateTimeFormatter formatter) {
        if (temporalAccessor == null) {
            return null;
        }
        if (formatter == null) {
            if (temporalAccessor instanceof Instant) {
                Instant instant = (Instant)temporalAccessor;
                temporalAccessor = PuiDateUtil.roundInstantNanosToThreeDecimals(instant);
                formatter = isoInstantMilliseconds;
            } else if (temporalAccessor instanceof ZonedDateTime) {
                formatter = DateTimeFormatter.ISO_ZONED_DATE_TIME;
            } else if (temporalAccessor instanceof LocalDate) {
                formatter = DateTimeFormatter.ISO_LOCAL_DATE;
            } else if (temporalAccessor instanceof LocalDateTime) {
                formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
            } else if (temporalAccessor instanceof OffsetDateTime) {
                formatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
            }
        } else if (!(temporalAccessor instanceof ZonedDateTime) && formatter.getZone() == null) {
            formatter = formatter.withZone(utcZone);
        }
        return formatter != null ? formatter.format(temporalAccessor) : null;
    }

    public static ZonedDateTime getInstantAtZoneId(Instant instant, ZoneId zoneId) {
        if (instant == null) {
            return null;
        }
        return instant.atZone(zoneId);
    }

    public static Instant getRealInstantFromFalsyInstant(Instant falsyInstant, ZoneId zoneId) {
        return LocalDateTime.ofInstant(falsyInstant, utcZone).atZone(zoneId).toInstant();
    }

    public static Instant roundInstantNanosToThreeDecimals(Instant instant) {
        if (instant == null) {
            return null;
        }
        int nanoRoundedTo3Decimals = (int)Math.round((double)instant.getNano() / 1000000.0) * 1000000;
        nanoRoundedTo3Decimals = Math.min(nanoRoundedTo3Decimals, Instant.MAX.getNano());
        return instant.with(ChronoField.NANO_OF_SECOND, nanoRoundedTo3Decimals);
    }

    private static String getDateFormat(String value) {
        for (DateSeparators sep : DateSeparators.values()) {
            for (DateFormats df : DateFormats.values()) {
                String template = df.template.replace(SEP, sep.sep);
                if (!value.matches(template)) continue;
                return df.format.replace(SEP, sep.sep);
            }
        }
        return null;
    }

    private static String getTimeFormat(String value, String dateFormat) {
        if (dateFormat == null) {
            return null;
        }
        DateFormats df = DateFormats.getByFormat(dateFormat);
        if (df == null) {
            return null;
        }
        DateSeparators ds = DateSeparators.guessSeparator(dateFormat);
        if (ds == null) {
            return null;
        }
        String time = value.replaceAll(df.template.replace(".*", "").replace(SEP, ds.sep), "").trim();
        for (TimeFormats tf : TimeFormats.values()) {
            if (!time.matches(tf.template)) continue;
            return tf.format;
        }
        return null;
    }

    private static enum TimeFormats {
        HOUR_MINUTE_SECOND_MILLISECOND(".*\\d{2}:\\d{1,2}:\\d{1,2}.\\d{1,3}", "HH:mm:ss.SSS"),
        HOUR_MINUTE_SECOND_MILLISECOND_TZ("[T]\\d{2}:\\d{1,2}:\\d{1,2}.\\d{1,3}[Z]", "'T'HH:mm:ss.SSS'Z'"),
        HOUR_MINUTE_SECOND_TZ("[T]\\d{2}:\\d{1,2}:\\d{1,2}[Z]", "'T'HH:mm:ss'Z'"),
        HOUR2_MINUTE_SECOND(".*\\d{2}:\\d{1,2}:\\d{1,2}", "HH:mm:ss"),
        HOUR1_MINUTE_SECOND(".*\\d{1}:\\d{1,2}:\\d{1,2}", "H:mm:ss"),
        HOUR2_MINUTE(".*\\d{2}:\\d{1,2}", "HH:mm"),
        HOUR1_MINUTE(".*\\d{1}:\\d{1,2}", "H:mm"),
        HOUR2(".*\\d{2}", "HH"),
        HOUR1(".*\\d{1}", "H"),
        NO_TIME("", "");

        private final String template;
        private final String format;

        private TimeFormats(String template, String format) {
            this.template = template;
            this.format = format;
        }

        public boolean matchFormat(String format) {
            return this.format.equals(format);
        }
    }

    private static enum DateSeparators {
        SLASH("/"),
        DASH("-"),
        SPACE(" ");

        private final String sep;

        private DateSeparators(String sep) {
            this.sep = sep;
        }

        public static DateSeparators guessSeparator(String dateFormat) {
            for (DateSeparators ds : DateSeparators.values()) {
                if (!dateFormat.contains(ds.sep)) continue;
                return ds;
            }
            return null;
        }
    }

    private static enum DateFormats {
        DAY_MONTH_YEAR("\\d{1,2}{sep}\\d{1,2}{sep}\\d{4}.*", "dd{sep}MM{sep}yyyy"),
        YEAR_MONTH("\\d{4}{sep}\\d{1,2}{sep}\\d{1,2}.*", "yyyy{sep}MM{sep}dd");

        private final String template;
        private final String format;

        private DateFormats(String template, String format) {
            this.template = template;
            this.format = format;
        }

        public static DateFormats getByFormat(String format) {
            for (DateSeparators dateSeparators : DateSeparators.values()) {
                if (!format.contains(dateSeparators.sep)) continue;
                format = format.replace(dateSeparators.sep, PuiDateUtil.SEP);
                break;
            }
            for (Enum enum_ : DateFormats.values()) {
                if (!((DateFormats)enum_).format.equals(format)) continue;
                return enum_;
            }
            return null;
        }
    }
}

