/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.cypher;

import es.prodevelop.pui9.cypher.PuiCypherData;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Scanner;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class AesGcmCypher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AesGcmCypher.class);
    private static final String ENCRYPT_ALGO = "AES/GCM/NoPadding";
    private static final int TAG_LENGTH_BIT = 128;
    private static final Charset UTF_8 = StandardCharsets.UTF_8;

    public static String encrypt(PuiCypherData cypherData, String decrypted) {
        if (ObjectUtils.isEmpty((Object)decrypted)) {
            return decrypted;
        }
        try {
            byte[] encryptedText = AesGcmCypher.encryptWithPrefixIV(decrypted.getBytes(UTF_8), cypherData.getSecretKey(), cypherData.getDecodedIv());
            return CryptoUtils.encodeBytesToString(encryptedText);
        }
        catch (GeneralSecurityException e) {
            log.error(e.getMessage());
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static String decrypt(PuiCypherData cypherData, String encrypted) {
        if (ObjectUtils.isEmpty((Object)encrypted)) {
            return encrypted;
        }
        try {
            byte[] cipherBytes = CryptoUtils.decodeStringToBytes(encrypted);
            return AesGcmCypher.decryptWithPrefixIV(cipherBytes, cypherData.getSecretKey());
        }
        catch (GeneralSecurityException e) {
            log.error(e.getMessage());
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private static byte[] encryptWithPrefixIV(byte[] pText, SecretKey secret, byte[] iv) throws GeneralSecurityException {
        byte[] cipherText = AesGcmCypher.encrypt(pText, secret, iv);
        return ByteBuffer.allocate(iv.length + cipherText.length).put(iv).put(cipherText).array();
    }

    private static byte[] encrypt(byte[] pText, SecretKey secret, byte[] iv) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(ENCRYPT_ALGO);
        cipher.init(1, (Key)secret, new GCMParameterSpec(128, iv));
        return cipher.doFinal(pText);
    }

    private static String decryptWithPrefixIV(byte[] cText, SecretKey secret) throws GeneralSecurityException {
        ByteBuffer bb = ByteBuffer.wrap(cText);
        byte[] iv = new byte[12];
        bb.get(iv);
        byte[] cipherText = new byte[bb.remaining()];
        bb.get(cipherText);
        return AesGcmCypher.decrypt(cipherText, secret, iv);
    }

    private static String decrypt(byte[] cText, SecretKey secret, byte[] iv) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(ENCRYPT_ALGO);
        cipher.init(2, (Key)secret, new GCMParameterSpec(128, iv));
        byte[] plainText = cipher.doFinal(cText);
        return new String(plainText, UTF_8);
    }

    public static void main(String[] args) throws GeneralSecurityException {
        Scanner scn = new Scanner(System.in);
        System.out.print("Generate Keys (g) / Encrypt (e) / Decrypt (d): ");
        String operation = scn.nextLine();
        if (operation.equalsIgnoreCase("g")) {
            SecretKey secretKey = CryptoUtils.getAESKey();
            String encodedKey = CryptoUtils.encodeBytesToString(secretKey.getEncoded());
            byte[] iv = CryptoUtils.getRandomNonce();
            String encodedIv = CryptoUtils.encodeBytesToString(iv);
            System.out.println("Encoded Key: " + encodedKey);
            System.out.println("Encoded IV Vector: " + encodedIv);
        } else {
            System.out.print("Enter Encoded Key: ");
            String encodedKey = scn.nextLine();
            System.out.print("Enter Encoded IV: ");
            String encodedIv = scn.nextLine();
            PuiCypherData cd = PuiCypherData.builder().encodedKey(encodedKey).encodedIv(encodedIv).build();
            if (operation.equalsIgnoreCase("e")) {
                System.out.print("Enter plain text: ");
                String plainText = scn.nextLine();
                String encryptedText = AesGcmCypher.encrypt(cd, plainText);
                System.out.print("Encrypted text is: " + encryptedText);
            } else if (operation.equalsIgnoreCase("d")) {
                System.out.print("Enter encrypted text: ");
                String encryptedText = scn.nextLine();
                String decryptedText = AesGcmCypher.encrypt(cd, encryptedText);
                System.out.print("Decrypted text is: " + decryptedText);
            }
        }
        scn.close();
    }

    private static class CryptoUtils {
        private CryptoUtils() {
        }

        static byte[] getRandomNonce() {
            byte[] nonce = new byte[12];
            new SecureRandom().nextBytes(nonce);
            return nonce;
        }

        static SecretKey getAESKey() throws GeneralSecurityException {
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            keyGen.init(256, SecureRandom.getInstanceStrong());
            return keyGen.generateKey();
        }

        static String encodeBytesToString(byte[] bytes) {
            return Base64.getEncoder().encodeToString(bytes);
        }

        static byte[] decodeStringToBytes(String cipherText) {
            return Base64.getDecoder().decode(cipherText);
        }
    }
}

