/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.messages;

import es.prodevelop.pui9.utils.PuiLanguage;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class PuiMessagesRegistry {
    private static PuiMessagesRegistry singleton;
    private final Map<String, Map<String, ResourceBundle>> map = new LinkedHashMap<String, Map<String, ResourceBundle>>();
    private String[] availableLanguages = new String[]{"es", "en", "ca", "fr"};
    private PuiLanguage defaultLanguage = new PuiLanguage(this.availableLanguages[0]);

    public static PuiMessagesRegistry getSingleton() {
        if (singleton == null) {
            singleton = new PuiMessagesRegistry();
        }
        return singleton;
    }

    private PuiMessagesRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAvailableLanguages(String ... langs) {
        this.availableLanguages = langs;
        Map<String, Map<String, ResourceBundle>> map = this.map;
        synchronized (map) {
            Iterator<String> it = this.map.keySet().iterator();
            while (it.hasNext()) {
                if (Arrays.asList(this.availableLanguages).contains(it.next())) continue;
                it.remove();
            }
            for (String lang : this.availableLanguages) {
                this.map.computeIfAbsent(lang, l -> new LinkedHashMap());
                Map<String, ResourceBundle> oneLang = this.map.values().iterator().next();
                for (String baseMap : oneLang.keySet()) {
                    this.addFileMessages(lang, baseMap);
                }
            }
        }
    }

    public void setDefaultLanguage(String lang) {
        this.defaultLanguage = new PuiLanguage(lang);
    }

    public void registerMessages(String baseName) {
        if (baseName == null) {
            throw new IllegalArgumentException("baseName parameter cannot be null");
        }
        for (String lang : this.availableLanguages) {
            this.addFileMessages(lang, baseName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileMessages(String lang, String baseName) {
        Map<String, Map<String, ResourceBundle>> map = this.map;
        synchronized (map) {
            try {
                this.map.computeIfAbsent(lang, l -> new LinkedHashMap()).put(baseName, ResourceBundle.getBundle(baseName, Locale.of(lang)));
            }
            catch (MissingResourceException e) {
                this.map.get(lang).put(baseName, ResourceBundle.getBundle(baseName, Locale.of(this.defaultLanguage.getIsocode())));
            }
        }
    }

    public String getString(String baseName, String key) {
        return this.getString(baseName, this.defaultLanguage, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String baseName, PuiLanguage lang, String key) {
        if (baseName == null) {
            throw new IllegalArgumentException("baseName parameter cannot be null");
        }
        if (key == null) {
            return "";
        }
        Map<String, Map<String, ResourceBundle>> map = this.map;
        synchronized (map) {
            if (lang == null || !this.map.containsKey(lang.getIsocode())) {
                lang = this.defaultLanguage;
            }
            try {
                if (this.map.get(lang.getIsocode()).containsKey(baseName)) {
                    return this.map.get(lang.getIsocode()).get(baseName).getString(key);
                }
                return null;
            }
            catch (MissingResourceException e) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(PuiLanguage lang, String key) {
        if (key == null) {
            return "";
        }
        Map<String, Map<String, ResourceBundle>> map = this.map;
        synchronized (map) {
            if (lang == null || !this.map.containsKey(lang.getIsocode())) {
                lang = this.defaultLanguage;
            }
            String val = null;
            for (ResourceBundle rb : this.map.get(lang.getIsocode()).values()) {
                try {
                    val = rb.getString(key);
                    break;
                }
                catch (MissingResourceException missingResourceException) {
                }
            }
            return val;
        }
    }
}

