/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.threads;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PuiBackgroundExecutors {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PuiBackgroundExecutors.class);
    private static PuiBackgroundExecutors instance;
    private List<ScheduledExecutorService> executors = new ArrayList<ScheduledExecutorService>();

    public static PuiBackgroundExecutors getSingleton() {
        if (instance == null) {
            instance = new PuiBackgroundExecutors();
        }
        return instance;
    }

    private PuiBackgroundExecutors() {
    }

    public void registerNewExecutorOneShot(String name, boolean isDaemon, long initialDelay, TimeUnit unit, Runnable runnable) {
        ScheduledExecutorService ses = this.buildExecutorService(name, isDaemon);
        ses.schedule(runnable, initialDelay, unit);
    }

    public void registerNewExecutor(String name, boolean isDaemon, long initialDelay, long delay, TimeUnit unit, Runnable runnable) {
        ScheduledExecutorService ses = this.buildExecutorService(name, isDaemon);
        ses.scheduleWithFixedDelay(runnable, initialDelay, delay, unit);
    }

    public void registerNewExecutorAtFixedRate(String name, boolean isDaemon, long initialDelay, long period, TimeUnit unit, Runnable runnable) {
        ScheduledExecutorService ses = this.buildExecutorService(name, isDaemon);
        ses.scheduleAtFixedRate(runnable, initialDelay, period, unit);
    }

    private ScheduledExecutorService buildExecutorService(String name, boolean isDaemon) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Empty executor name");
        }
        ThreadFactory tf = new ThreadFactoryBuilder().setDaemon(isDaemon).setNameFormat("PuiExecutor_" + name).setUncaughtExceptionHandler((thread, throwable) -> log.error("Error in Background Executor '{}'", (Object)name, (Object)throwable)).build();
        ScheduledExecutorService ses = Executors.newSingleThreadScheduledExecutor(tf);
        this.executors.add(ses);
        return ses;
    }

    public void destroy() {
        for (ScheduledExecutorService ses : this.executors) {
            ses.shutdownNow();
        }
    }
}

