/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.utils;

import com.google.common.primitives.Primitives;
import es.prodevelop.pui9.json.GsonSingleton;
import es.prodevelop.pui9.utils.IPuiObject;
import es.prodevelop.pui9.utils.PuiDateUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class PuiObjectUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PuiObjectUtils.class);
    private static Map<Class<?>, Map<String, Field>> mapCache = new LinkedHashMap();

    public static <T> T copyObject(T orig) {
        if (orig == null) {
            return null;
        }
        try {
            Object dest = orig.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            PuiObjectUtils.copyProperties(dest, orig);
            return (T)dest;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException("No public constructor defined without parameters for Class " + orig.getClass().getName() + ". You should define one to use this method");
        }
    }

    public static <T> T copyDeepObject(T orig) {
        if (orig == null) {
            return null;
        }
        String origJson = GsonSingleton.getSingleton().getGson().toJson(orig);
        return (T)GsonSingleton.getSingleton().getGson().fromJson(origJson, orig.getClass());
    }

    public static void copyProperties(Object dest, Object orig) {
        if (dest == null || orig == null) {
            return;
        }
        Map<String, Field> destFields = PuiObjectUtils.getFields(dest.getClass());
        Map<String, Field> origFields = PuiObjectUtils.getFields(orig.getClass());
        for (Map.Entry<String, Field> entry : destFields.entrySet()) {
            try {
                String destFieldName = entry.getKey();
                Field destField = entry.getValue();
                if (!origFields.containsKey(destFieldName)) continue;
                Field origField = origFields.get(destFieldName);
                if (!destField.getType().equals(origField.getType()) && !destField.getType().isAssignableFrom(origField.getType())) continue;
                Object value = origField.get(orig);
                destField.set(dest, value);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {}
        }
    }

    public static void populateObject(Object object, Map<String, Object> fieldValuesMap) {
        if (object == null || fieldValuesMap == null || fieldValuesMap.isEmpty()) {
            return;
        }
        Map<String, Field> fields = PuiObjectUtils.getFields(object.getClass());
        for (Map.Entry<String, Object> entry : fieldValuesMap.entrySet()) {
            if (!fields.containsKey(entry.getKey())) continue;
            Field field = fields.get(entry.getKey());
            try {
                Double db;
                Object val = entry.getValue();
                Class<?> fieldType = field.getType();
                if (field.getType().equals(BigDecimal.class) && val instanceof Double) {
                    db = (Double)val;
                    val = BigDecimal.valueOf(db);
                }
                if (field.getType().equals(BigDecimal.class) && val instanceof Integer) {
                    val = BigDecimal.valueOf(((Integer)val).intValue());
                }
                if (field.getType().equals(Double.class) && val instanceof BigDecimal) {
                    BigDecimal bd = (BigDecimal)val;
                    val = bd.doubleValue();
                }
                if (field.getType().equals(Integer.class) && val instanceof Double) {
                    db = (Double)val;
                    val = db.intValue();
                }
                if (field.getType().equals(Instant.class) && val instanceof String) {
                    ?[] ins = (?[])val;
                    val = PuiDateUtil.stringToInstant(ins);
                }
                if (Enum.class.isAssignableFrom(fieldType)) {
                    for (Object enumVal : fieldType.getEnumConstants()) {
                        if (!enumVal.toString().equals(val)) continue;
                        val = enumVal;
                        break;
                    }
                }
                if (val != null && !field.getType().isAssignableFrom(val.getClass()) && val instanceof String) {
                    String valStr = (String)val;
                    val = PuiObjectUtils.guessValueType(valStr, field.getType());
                }
                if (val != null) {
                    if (Primitives.isWrapperType(fieldType) && !Primitives.isWrapperType(val.getClass())) {
                        val = PuiObjectUtils.convertToWrapper(val);
                    } else if (!Primitives.isWrapperType(fieldType) && Primitives.isWrapperType(val.getClass())) {
                        val = PuiObjectUtils.convertToPrimitive(val);
                    }
                }
                if (val != null && !field.getType().isAssignableFrom(val.getClass())) continue;
                field.set(object, val);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {}
        }
    }

    public static int computeHashCode(IPuiObject object) {
        Map<String, Field> fields = PuiObjectUtils.getFields(object.getClass());
        if (ObjectUtils.isEmpty(fields)) {
            return new SecureRandom().nextInt();
        }
        HashCodeBuilder hcBuilder = new HashCodeBuilder();
        fields.entrySet().forEach(entry -> {
            try {
                Field field = (Field)entry.getValue();
                Object value = FieldUtils.readField((Field)field, (Object)object, (boolean)true);
                if (value instanceof IPuiObject) {
                    IPuiObject po = (IPuiObject)value;
                    hcBuilder.append(PuiObjectUtils.computeHashCode(po));
                } else {
                    hcBuilder.append(value);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        });
        return hcBuilder.toHashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Field> getFields(Class<?> clazz) {
        if (!mapCache.containsKey(clazz)) {
            Map<Class<?>, Map<String, Field>> map = mapCache;
            synchronized (map) {
                if (!mapCache.containsKey(clazz)) {
                    LinkedHashMap<String, Field> map2 = new LinkedHashMap<String, Field>();
                    for (Class<?> toRegister = clazz; toRegister != null; toRegister = toRegister.getSuperclass()) {
                        List<Field> fields = Arrays.asList(toRegister.getDeclaredFields());
                        for (Field field : fields) {
                            try {
                                field.setAccessible(true);
                                map2.put(field.getName(), field);
                            }
                            catch (InaccessibleObjectException e) {
                                log.error("Could not set field {} as accessible", (Object)field, (Object)e);
                            }
                        }
                    }
                    mapCache.put(clazz, map2);
                }
            }
        }
        return mapCache.get(clazz);
    }

    private static Object convertToPrimitive(Object value) {
        if (value == null) {
            return null;
        }
        if (Integer.class.equals(value.getClass())) {
            return (int)((Integer)value);
        }
        if (Long.class.equals(value.getClass())) {
            return (long)((Long)value);
        }
        if (Float.class.equals(value.getClass())) {
            return Float.valueOf(((Float)value).floatValue());
        }
        if (Double.class.equals(value.getClass())) {
            return (double)((Double)value);
        }
        if (Boolean.class.equals(value.getClass())) {
            return (boolean)((Boolean)value);
        }
        return null;
    }

    private static Object convertToWrapper(Object value) {
        if (value == null) {
            return null;
        }
        if (Integer.TYPE.equals(value.getClass())) {
            return (int)((Integer)value);
        }
        if (Long.TYPE.equals(value.getClass())) {
            return (long)((Long)value);
        }
        if (Float.TYPE.equals(value.getClass())) {
            return Float.valueOf(((Float)value).floatValue());
        }
        if (Double.TYPE.equals(value.getClass())) {
            return (double)((Double)value);
        }
        if (Boolean.TYPE.equals(value.getClass())) {
            return (boolean)((Boolean)value);
        }
        return null;
    }

    private static Object guessValueType(String value, Class<?> type) {
        if (value == null) {
            return null;
        }
        if (Integer.class.equals(type)) {
            return Integer.valueOf(value);
        }
        if (Integer.TYPE.equals(type)) {
            return Integer.parseInt(value);
        }
        if (Long.class.equals(type)) {
            return Long.valueOf(value);
        }
        if (Long.TYPE.equals(type)) {
            return Long.parseLong(value);
        }
        if (Float.class.equals(type)) {
            return Float.valueOf(value);
        }
        if (Float.TYPE.equals(type)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (Double.class.equals(type)) {
            return Double.valueOf(value);
        }
        if (Double.TYPE.equals(type)) {
            return Double.parseDouble(value);
        }
        if (Boolean.class.equals(type)) {
            return Boolean.valueOf(value);
        }
        if (Boolean.TYPE.equals(type)) {
            return Boolean.parseBoolean(value);
        }
        if (BigDecimal.class.equals(type)) {
            return new BigDecimal(value);
        }
        return null;
    }

    private PuiObjectUtils() {
    }
}

