/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.tilecache;

import es.prodevelop.gvsig.mini.common.IContext;
import es.prodevelop.gvsig.mini.common.IEvent;
import es.prodevelop.gvsig.mini.common.impl.BaseEvent;
import es.prodevelop.gvsig.mini.exceptions.BaseException;
import es.prodevelop.gvsig.mini.geom.Extent;
import es.prodevelop.gvsig.mini.utiles.Cancellable;
import es.prodevelop.tilecache.IDownloadCallbackHandler;
import es.prodevelop.tilecache.IDownloadWaiter;
import es.prodevelop.tilecache.generator.IBufferStrategy;
import es.prodevelop.tilecache.generator.ITileBufferIntersector;
import es.prodevelop.tilecache.generator.ITileSorter;
import es.prodevelop.tilecache.generator.TileGenerator;
import es.prodevelop.tilecache.provider.filesystem.strategy.ITileFileSystemStrategy;
import es.prodevelop.tilecache.renderer.MapRenderer;

public class TileDownloaderTask
implements Runnable {
    private TileGenerator generator;
    private IDownloadWaiter downloadWaiter;
    private int fromZoomLevel = 0;
    private int toZoomLevel = 0;
    private Cancellable cancellable;

    public TileDownloaderTask(IContext context, MapRenderer aMapRenderer, int fromZoomLevel, int toZoomLevel, Cancellable cancellable, Extent extent, ITileSorter sorter, IDownloadCallbackHandler callBackHandler, ITileBufferIntersector intersector, int mode, ITileFileSystemStrategy fsStrategy, IBufferStrategy bufferStrategy, boolean notLocalCache) throws BaseException {
        this.generator = new TileGenerator(context, aMapRenderer, fromZoomLevel, toZoomLevel, cancellable, extent, sorter, callBackHandler, intersector, mode, fsStrategy, bufferStrategy, notLocalCache);
        this.downloadWaiter = callBackHandler.getDownloadWaiter();
        this.fromZoomLevel = fromZoomLevel;
        this.toZoomLevel = toZoomLevel;
        this.cancellable = cancellable;
    }

    public void run() {
        try {
            this.downloadWaiter.onStartDownload();
            for (int i = this.fromZoomLevel; i <= this.toZoomLevel; ++i) {
                this.generator.downloadLevel(i, this.cancellable);
            }
        }
        catch (Exception e) {
            this.downloadWaiter.onFatalError((IEvent)new BaseEvent("Fatal Error while executing TileDownloaderTask: " + e.getMessage()));
        }
    }
}

