/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.tilecache.generator;

import es.prodevelop.gvsig.mini.common.CompatManager;
import es.prodevelop.gvsig.mini.common.IBitmap;
import es.prodevelop.gvsig.mini.common.IContext;
import es.prodevelop.gvsig.mini.common.IEvent;
import es.prodevelop.gvsig.mini.common.IHandler;
import es.prodevelop.gvsig.mini.common.IRect;
import es.prodevelop.gvsig.mini.common.impl.BaseEvent;
import es.prodevelop.gvsig.mini.common.impl.Tile;
import es.prodevelop.gvsig.mini.exceptions.BaseException;
import es.prodevelop.gvsig.mini.geom.Extent;
import es.prodevelop.gvsig.mini.geom.Pixel;
import es.prodevelop.gvsig.mini.geom.Point;
import es.prodevelop.gvsig.mini.map.GeoMath;
import es.prodevelop.gvsig.mini.map.GeoUtils;
import es.prodevelop.gvsig.mini.map.ViewPort;
import es.prodevelop.gvsig.mini.utiles.Cancellable;
import es.prodevelop.gvsig.mini.utiles.ThreadPool;
import es.prodevelop.gvsig.mini.utiles.WorkQueue;
import es.prodevelop.tilecache.generator.IBufferStrategy;
import es.prodevelop.tilecache.generator.ITileBufferIntersector;
import es.prodevelop.tilecache.generator.ITileSorter;
import es.prodevelop.tilecache.provider.TileProvider;
import es.prodevelop.tilecache.provider.filesystem.strategy.ITileFileSystemStrategy;
import es.prodevelop.tilecache.renderer.MapRenderer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TileGenerator
implements GeoUtils {
    private static final Logger log = Logger.getLogger("TileGenerator");
    private MapRenderer mapRenderer;
    private int mapWidth;
    private int mapHeight;
    private int fromZoomLevel;
    private int toZoomLevel;
    private int centerPixelX;
    private int centerPixelY;
    private TileProvider mTileProvider;
    private IContext context;
    private Cancellable cancellable;
    private Extent extent;
    private boolean downloadAllExtent = false;
    private IBufferStrategy bufferStrategy;
    private ITileSorter tileSorter;
    private ITileBufferIntersector tileBufferIntersector;
    private IHandler callBackHandler;

    public TileGenerator(IContext context, MapRenderer aMapRenderer, int fromZoomLevel, int toZoomLevel, Cancellable cancellable, Extent extent, ITileSorter sorter, IHandler callBackHandler, ITileBufferIntersector intersector, int mode, ITileFileSystemStrategy fsStrategy, IBufferStrategy bufferStrategy, boolean notLocalCache) throws BaseException {
        this.mTileProvider = new TileProvider(context, callBackHandler, 1, 1, aMapRenderer.getMAPTILE_SIZEPX(), mode, fsStrategy, notLocalCache);
        this.bufferStrategy = bufferStrategy;
        this.mapRenderer = aMapRenderer;
        this.fromZoomLevel = fromZoomLevel;
        this.toZoomLevel = toZoomLevel;
        this.tileBufferIntersector = intersector;
        this.tileSorter = sorter;
        this.cancellable = cancellable;
        this.extent = (Extent)extent.clone();
        this.downloadAllExtent = true;
        this.callBackHandler = callBackHandler;
        this.recalcWidthHeightOfAreaToDownload(fromZoomLevel);
        this.checkParams();
        context.sendMessage(callBackHandler, (IEvent)new BaseEvent(String.valueOf(this.calculateTotalNumTilesToDownload())), -2);
    }

    public TileGenerator(IContext context, MapRenderer aMapRenderer, ITileSorter sorter, IHandler callBackHandler, ITileBufferIntersector intersector, int mode, ITileFileSystemStrategy fsStrategy, IBufferStrategy bufferStrategy, int mapWidth, int mapHeight) throws BaseException {
        this.mTileProvider = new TileProvider(context, callBackHandler, mapWidth, mapHeight, aMapRenderer.getMAPTILE_SIZEPX(), mode, fsStrategy);
        this.bufferStrategy = bufferStrategy;
        this.mapRenderer = aMapRenderer;
        this.tileBufferIntersector = intersector;
        this.tileSorter = sorter;
        this.downloadAllExtent = true;
        this.callBackHandler = callBackHandler;
        this.mapHeight = mapHeight;
        this.mapWidth = mapWidth;
        this.centerPixelX = mapWidth / 2;
        this.centerPixelY = mapHeight / 2;
    }

    private void recalcWidthHeightOfAreaToDownload(int zoomLevel) {
        double eWidth = this.extent.getWidth();
        double eHeight = this.extent.getHeight();
        this.mapWidth = Math.max((int)(eWidth / this.mapRenderer.resolutions[zoomLevel]), 1);
        this.mapHeight = Math.max((int)(eHeight / this.mapRenderer.resolutions[zoomLevel]), 1);
        this.centerPixelX = this.mapWidth / 2;
        this.centerPixelY = this.mapHeight / 2;
        ViewPort.mapHeight = this.mapHeight;
        ViewPort.mapWidth = this.mapWidth;
    }

    private void checkParams() throws BaseException {
        if (this.fromZoomLevel > this.toZoomLevel) {
            throw new BaseException("Error: FromZoomlevel " + this.fromZoomLevel + " > toZoomLevel " + this.toZoomLevel);
        }
        if (this.mapWidth == 0 || this.mapHeight == 0) {
            throw new BaseException("Error width or height == 0: mapWidth " + this.mapWidth + " mapHeight " + this.mapHeight);
        }
    }

    private boolean checkHasBeenCancelled() {
        boolean cancelled = this.cancellable.getCanceled();
        if (cancelled) {
            this.mTileProvider.clearPendingQueue();
            WorkQueue.getInstance().clearPendingTasks();
            this.context.sendMessage(this.callBackHandler, (IEvent)new BaseEvent("Tile provider canceled"), -1);
        }
        return cancelled;
    }

    public IBitmap getMapTile(Tile tile, Cancellable cancellable) {
        return this.mTileProvider.getMapTileFromCache(tile, cancellable);
    }

    public void downloadExtentAsynch(final int zoomLevel, Extent extent, Cancellable cancellable) {
        this.cancellable = cancellable;
        this.extent = extent;
        ThreadPool.getInstance((int)1).assign(new Runnable(){

            public void run() {
                try {
                    TileGenerator.this.checkHasBeenCancelled();
                    MapRenderer renderer = TileGenerator.this.mapRenderer;
                    int tileSizePx = renderer.getMAPTILE_SIZEPX();
                    int[] centerMapTileCoords = renderer.getMapTileFromCenter();
                    Pixel upperLeftCornerOfCenterMapTile = renderer.getUpperLeftCornerOfCenterMapTileInScreen(null);
                    int centerMapTileScreenLeft = upperLeftCornerOfCenterMapTile.getX();
                    int centerMapTileScreenTop = upperLeftCornerOfCenterMapTile.getY();
                    int centerMapTileScreenRight = centerMapTileScreenLeft + tileSizePx;
                    int centerMapTileScreenBottom = centerMapTileScreenTop + tileSizePx;
                    int[] additionalTiles = TileGenerator.this.bufferStrategy.calculateBufferAroundCenterTile((int)ViewPort.mapWidth, (int)ViewPort.mapHeight, tileSizePx, centerMapTileScreenLeft, centerMapTileScreenRight, centerMapTileScreenTop, centerMapTileScreenBottom);
                    int additionalTilesNeededToLeftOfCenter = additionalTiles[0];
                    int additionalTilesNeededToRightOfCenter = additionalTiles[1];
                    int additionalTilesNeededToTopOfCenter = additionalTiles[2];
                    int additionalTilesNeededToBottomOfCenter = additionalTiles[3];
                    int[] mapTileCoords = new int[]{centerMapTileCoords[0], centerMapTileCoords[1]};
                    int size = (additionalTilesNeededToBottomOfCenter + additionalTilesNeededToTopOfCenter + 1) * (additionalTilesNeededToRightOfCenter + additionalTilesNeededToLeftOfCenter + 1);
                    Tile[] tiles = new Tile[size];
                    int cont = 0;
                    Extent maxExtent = renderer.getExtent();
                    Extent viewExtent = ViewPort.calculateExtent((Point)renderer.getCenter(), (double)renderer.resolutions[zoomLevel], (double)ViewPort.mapWidth, (double)ViewPort.mapHeight);
                    double[] coords = new double[]{maxExtent.getLefBottomCoordinate().getX(), maxExtent.getLefBottomCoordinate().getY()};
                    int[] leftBottom = renderer.toPixels(coords);
                    coords = new double[]{maxExtent.getRightTopCoordinate().getX(), maxExtent.getRightTopCoordinate().getY()};
                    int[] rightTop = renderer.toPixels(coords);
                    IRect r = TileGenerator.this.getContext().getRectangle();
                    r.set(leftBottom[0], rightTop[1], rightTop[0], leftBottom[1]);
                    boolean process = true;
                    for (int y = -additionalTilesNeededToTopOfCenter; y <= additionalTilesNeededToBottomOfCenter; ++y) {
                        for (int x = -additionalTilesNeededToLeftOfCenter; x <= additionalTilesNeededToRightOfCenter; ++x) {
                            process = true;
                            TileGenerator.this.checkHasBeenCancelled();
                            if (viewExtent.intersect(maxExtent)) {
                                int tileLeft = ViewPort.mTouchMapOffsetX + centerMapTileScreenLeft + x * tileSizePx;
                                int tileTop = ViewPort.mTouchMapOffsetY + centerMapTileScreenTop + y * tileSizePx;
                                process &= r.intersects(tileLeft, tileTop, tileLeft + tileSizePx / 2, tileTop + tileSizePx / 2);
                            }
                            if (process) {
                                mapTileCoords[0] = centerMapTileCoords[0] + renderer.isTMS() * y;
                                mapTileCoords[1] = centerMapTileCoords[1] + x;
                                String tileURLString = renderer.getTileURLString(mapTileCoords, zoomLevel);
                                int[] tile = new int[]{mapTileCoords[0], mapTileCoords[1]};
                                int tileLeft = ViewPort.mTouchMapOffsetX + centerMapTileScreenLeft + x * tileSizePx;
                                int tileTop = ViewPort.mTouchMapOffsetY + centerMapTileScreenTop + y * tileSizePx;
                                Tile t = new Tile(tileURLString, tile, new Pixel(tileLeft, tileTop), zoomLevel, renderer.getNAME(), TileGenerator.this.cancellable, null);
                                if (TileGenerator.this.tileSorter == null) {
                                    TileGenerator.this.mTileProvider.getMapTile(t.clone(), TileGenerator.this.cancellable);
                                } else if (cont < tiles.length) {
                                    tiles[cont] = t;
                                }
                            } else {
                                TileGenerator.this.context.sendMessage(TileGenerator.this.callBackHandler, (IEvent)new BaseEvent("Tile skipped"), -3);
                            }
                            ++cont;
                        }
                    }
                    if (TileGenerator.this.tileSorter != null) {
                        TileGenerator.this.tileSorter.sortTiles(tiles, TileGenerator.this.centerPixelX, TileGenerator.this.centerPixelY, tileSizePx);
                        for (Tile temp : tiles) {
                            if (temp == null) continue;
                            TileGenerator.this.mTileProvider.getMapTile(temp.clone(), TileGenerator.this.cancellable);
                        }
                    }
                    tiles = null;
                }
                catch (Exception e) {
                    log.log(Level.FINE, "onDraw", e);
                }
            }
        });
    }

    public void downloadLevel(int zoomLevel, Cancellable cancellable) {
        try {
            MapRenderer renderer = this.mapRenderer;
            renderer.setZoomLevel(zoomLevel);
            int tileSizePx = renderer.getMAPTILE_SIZEPX();
            if (this.downloadAllExtent) {
                this.recalcWidthHeightOfAreaToDownload(zoomLevel);
            }
            int[] centerMapTileCoords = renderer.getMapTileFromCenter();
            Pixel upperLeftCornerOfCenterMapTile = renderer.getUpperLeftCornerOfCenterMapTileInScreen(null);
            int centerMapTileScreenLeft = upperLeftCornerOfCenterMapTile.getX();
            int centerMapTileScreenTop = upperLeftCornerOfCenterMapTile.getY();
            int centerMapTileScreenRight = centerMapTileScreenLeft + tileSizePx;
            int centerMapTileScreenBottom = centerMapTileScreenTop + tileSizePx;
            int[] additionalTiles = this.bufferStrategy.calculateBufferAroundCenterTile(this.mapWidth, this.mapHeight, tileSizePx, centerMapTileScreenLeft, centerMapTileScreenRight, centerMapTileScreenTop, centerMapTileScreenBottom);
            int additionalTilesNeededToLeftOfCenter = additionalTiles[0];
            int additionalTilesNeededToRightOfCenter = additionalTiles[1];
            int additionalTilesNeededToTopOfCenter = additionalTiles[2];
            int additionalTilesNeededToBottomOfCenter = additionalTiles[3];
            int mapTileUpperBound = this.bufferStrategy.calculateTileUpperBound(zoomLevel);
            int[] mapTileCoords = new int[]{centerMapTileCoords[0], centerMapTileCoords[1]};
            int size = (additionalTilesNeededToBottomOfCenter + additionalTilesNeededToTopOfCenter + 1) * (additionalTilesNeededToRightOfCenter + additionalTilesNeededToLeftOfCenter + 1);
            Tile[] tiles = new Tile[size];
            int cont = 0;
            Extent maxExtent = renderer.getExtent();
            if (this.mapWidth < this.mapRenderer.getMAPTILE_SIZEPX() || this.mapHeight == this.mapRenderer.getMAPTILE_SIZEPX()) {
                maxExtent = this.mapRenderer.getExtentIncludingCenter(this.extent.getCenter(), zoomLevel, new Point(this.mapRenderer.getOriginX(), this.mapRenderer.getOriginY()));
                double eWidth = maxExtent.getWidth();
                double eHeight = maxExtent.getHeight();
                this.mapWidth = Math.max((int)(eWidth / this.mapRenderer.resolutions[zoomLevel]), 1);
                this.mapHeight = Math.max((int)(eHeight / this.mapRenderer.resolutions[zoomLevel]), 1);
            }
            Extent viewExtent = ViewPort.calculateExtent((Point)renderer.getCenter(), (double)renderer.resolutions[zoomLevel], (double)this.mapWidth, (double)this.mapHeight);
            double[] coords = new double[]{maxExtent.getLefBottomCoordinate().getX(), maxExtent.getLefBottomCoordinate().getY()};
            int[] leftBottom = renderer.toPixels(coords);
            coords = new double[]{maxExtent.getRightTopCoordinate().getX(), maxExtent.getRightTopCoordinate().getY()};
            int[] rightTop = renderer.toPixels(coords);
            IRect r = this.getContext().getRectangle();
            r.set(leftBottom[0], rightTop[1], rightTop[0], leftBottom[1]);
            boolean process = true;
            for (int y = -additionalTilesNeededToTopOfCenter; y <= additionalTilesNeededToBottomOfCenter; ++y) {
                for (int x = -additionalTilesNeededToLeftOfCenter; x <= additionalTilesNeededToRightOfCenter; ++x) {
                    process = true;
                    if (cancellable.getCanceled()) {
                        this.mTileProvider.clearPendingQueue();
                        WorkQueue.getInstance().clearPendingTasks();
                        this.context.sendMessage(this.callBackHandler, (IEvent)new BaseEvent("Tile provider canceled"), -1);
                        return;
                    }
                    if (viewExtent.intersect(maxExtent)) {
                        int tileLeft = ViewPort.mTouchMapOffsetX + centerMapTileScreenLeft + x * tileSizePx;
                        int tileTop = ViewPort.mTouchMapOffsetY + centerMapTileScreenTop + y * tileSizePx;
                        process &= r.intersects(tileLeft, tileTop, tileLeft + tileSizePx / 2, tileTop + tileSizePx / 2);
                    }
                    if (process) {
                        mapTileCoords[0] = GeoMath.mod((int)(centerMapTileCoords[0] + renderer.isTMS() * y), (int)mapTileUpperBound);
                        mapTileCoords[1] = GeoMath.mod((int)(centerMapTileCoords[1] + x), (int)mapTileUpperBound);
                        String tileURLString = renderer.getTileURLString(mapTileCoords, zoomLevel);
                        int[] tile = new int[]{mapTileCoords[0], mapTileCoords[1]};
                        int tileLeft = ViewPort.mTouchMapOffsetX + centerMapTileScreenLeft + x * tileSizePx;
                        int tileTop = ViewPort.mTouchMapOffsetY + centerMapTileScreenTop + y * tileSizePx;
                        if (this.checkIntersects(tile, renderer, zoomLevel)) {
                            Tile t = new Tile(tileURLString, tile, new Pixel(tileLeft, tileTop), zoomLevel, renderer.getNAME(), cancellable, null);
                            if (this.tileSorter == null) {
                                this.mTileProvider.getMapTile(t.clone(), cancellable);
                            } else if (cont < tiles.length) {
                                tiles[cont] = t;
                            }
                        } else {
                            this.context.sendMessage(this.callBackHandler, (IEvent)new BaseEvent("Tile skipped because tile does not intersect with Geometry: " + tileURLString), -3);
                        }
                    } else {
                        this.context.sendMessage(this.callBackHandler, (IEvent)new BaseEvent("Tile skipped"), -3);
                    }
                    ++cont;
                }
            }
            if (this.tileSorter != null) {
                this.tileSorter.sortTiles(tiles, this.centerPixelX, this.centerPixelY, tileSizePx);
                for (Tile temp : tiles) {
                    if (temp == null) continue;
                    this.mTileProvider.getMapTile(temp.clone(), cancellable);
                }
            }
            tiles = null;
        }
        catch (Exception e) {
            log.log(Level.FINE, "onDraw", e);
        }
    }

    protected boolean checkIntersects(int[] tile, MapRenderer renderer, int zoomLevel) {
        boolean result = true;
        if (this.tileBufferIntersector != null) {
            double originX = renderer.getOriginX();
            double originY = renderer.getOriginY();
            Extent tileExtent = renderer.getTileExtent(tile[1], tile[0], renderer.resolutions[zoomLevel], originX, originY);
            result = this.tileBufferIntersector.intersects(tileExtent);
        }
        return result;
    }

    public long calculateTotalNumTilesToDownload() {
        MapRenderer renderer = this.mapRenderer;
        int tileSizePx = renderer.getMAPTILE_SIZEPX();
        long totalTiles = 0L;
        for (int zoomLevel = this.fromZoomLevel; zoomLevel <= this.toZoomLevel; ++zoomLevel) {
            renderer.setZoomLevel(zoomLevel);
            if (this.downloadAllExtent) {
                this.recalcWidthHeightOfAreaToDownload(zoomLevel);
            }
            Pixel upperLeftCornerOfCenterMapTile = renderer.getUpperLeftCornerOfCenterMapTileInScreen(null);
            int centerMapTileScreenLeft = upperLeftCornerOfCenterMapTile.getX();
            int centerMapTileScreenTop = upperLeftCornerOfCenterMapTile.getY();
            int centerMapTileScreenRight = centerMapTileScreenLeft + tileSizePx;
            int centerMapTileScreenBottom = centerMapTileScreenTop + tileSizePx;
            int[] additionalTiles = this.bufferStrategy.calculateBufferAroundCenterTile(this.mapWidth, this.mapHeight, tileSizePx, centerMapTileScreenLeft, centerMapTileScreenRight, centerMapTileScreenTop, centerMapTileScreenBottom);
            int additionalTilesNeededToLeftOfCenter = additionalTiles[0];
            int additionalTilesNeededToRightOfCenter = additionalTiles[1];
            int additionalTilesNeededToTopOfCenter = additionalTiles[2];
            int additionalTilesNeededToBottomOfCenter = additionalTiles[3];
            totalTiles += (long)((additionalTilesNeededToBottomOfCenter + additionalTilesNeededToTopOfCenter + 1) * (additionalTilesNeededToRightOfCenter + additionalTilesNeededToLeftOfCenter + 1));
        }
        return totalTiles;
    }

    public TileProvider getTileProvider() {
        return this.mTileProvider;
    }

    public void setTileProvider(TileProvider tileProvider) {
        this.mTileProvider = tileProvider;
    }

    private IContext getContext() throws BaseException {
        if (this.context == null) {
            this.context = CompatManager.getInstance().getRegisteredContext();
        }
        return this.context;
    }

    public void setBufferStrategy(IBufferStrategy bufferStrategy) {
        this.bufferStrategy = bufferStrategy;
    }

    public IBufferStrategy getBufferStrategy() {
        return this.bufferStrategy;
    }

    public void setTileSorter(ITileSorter tileSorter) {
        this.tileSorter = tileSorter;
    }

    public ITileSorter getTileSorter() {
        return this.tileSorter;
    }

    public void destroy() {
        this.mTileProvider.destroy();
    }

    public void clearQueue(boolean cancel) {
        if (cancel) {
            this.cancellable.setCanceled(true);
        }
        this.mTileProvider.clearPendingQueue();
    }

    public void onLowMemory() {
        this.clearQueue(true);
    }
}

