/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.tilecache.layers;

import es.prodevelop.gvsig.mini.common.CompatManager;
import es.prodevelop.gvsig.mini.common.IContext;
import es.prodevelop.gvsig.mini.exceptions.BaseException;
import es.prodevelop.gvsig.mini.utiles.Constants;
import es.prodevelop.gvsig.mini.utiles.LayersSorter;
import es.prodevelop.tilecache.renderer.MapRenderer;
import es.prodevelop.tilecache.renderer.MapRendererManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Layers {
    private static final Logger logger = Logger.getLogger("Layers");
    private static Layers instance;
    private Hashtable properties;
    private Hashtable<Integer, Vector> layers;
    private static final String fileName = "layers.txt";
    private LayersSorter mLayersSorter;
    private IContext context;

    public static Layers getInstance() {
        try {
            if (instance == null) {
                instance = new Layers();
                instance.setLayersSorter(new LayersSorter());
                try {
                    CompatManager.getInstance().getRegisteredLogHandler().configureLogger((Object)logger);
                }
                catch (BaseException e) {
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return instance;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "getInstance: ", e);
            return null;
        }
    }

    public IContext getContext() throws BaseException {
        if (this.context == null) {
            this.context = CompatManager.getInstance().getRegisteredContext();
        }
        return this.context;
    }

    public void initialize(boolean persist) throws BaseException {
        try {
            File layerFile = new File(this.getContext().getBaseLayerFilePath());
            boolean exists = layerFile.exists();
            this.loadProperties(this.getContext().getBaseLayerFilePath());
            if (!exists && persist) {
                instance.persist();
            }
        }
        catch (BaseException e) {
            logger.log(Level.SEVERE, "IOException on load layers", e);
            this.loadProperties(null);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadProperties(String filePath) throws BaseException {
        block8: {
            reader = null;
            is /* !! */  = null;
            layerFile = null;
            try {
                Layers.logger.log(Level.FINE, "loadProperties");
                if (filePath != null) ** GOTO lbl31
                Layers.logger.log(Level.FINE, "filePath is null");
                this.properties = new Hashtable<K, V>();
                this.layers = new Hashtable<K, V>();
                layerFile = new File(this.getContext().getBaseLayerFilePath());
                exists = layerFile.exists();
                if (exists) {
                    Layers.logger.log(Level.FINE, layerFile.getAbsolutePath());
                    this.loadProperties(this.getContext().getBaseLayerFilePath());
                }
                ** GOTO lbl-1000
            }
            catch (IOException e) {
                try {
                    throw new BaseException(e.getCause());
                    catch (Exception e) {
                        Layers.logger.log(Level.SEVERE, "loadProperties: ", e);
                        throw new BaseException(e.getCause());
                    }
                }
                catch (Throwable var6_8) {
                    Constants.closeStream(is /* !! */ );
                    throw var6_8;
                }
            }
            Constants.closeStream((Closeable)is /* !! */ );
            return;
lbl-1000:
            // 1 sources

            {
                Layers.logger.log(Level.FINE, "load layers.txt from assets");
                is /* !! */  = this.getContext().openAssetFile("layers.txt");
                ** GOTO lbl41
lbl31:
                // 1 sources

                Layers.logger.log(Level.FINE, "filePath: " + filePath);
                this.properties = new Hashtable<K, V>();
                this.layers = new Hashtable<K, V>();
                layerFile = new File(filePath);
                if (layerFile.exists()) ** GOTO lbl-1000
                Layers.logger.log(Level.FINE, "layerFile not exists");
                this.loadProperties(null);
            }
            Constants.closeStream((Closeable)is /* !! */ );
            return;
lbl-1000:
            // 1 sources

            {
                is /* !! */  = new FileInputStream(layerFile);
lbl41:
                // 2 sources

                reader = new BufferedReader(new InputStreamReader(is /* !! */ ));
                failed = this.parseLayersFile(reader);
                if (!failed) break block8;
                Layers.logger.log(Level.FINE, "parse layers file failed. Invalid version");
                Layers.instance.persist("layersback.txt");
                Layers.logger.log(Level.FINE, "previous layer file persisted");
                Layers.logger.log(Level.FINE, "loading last layers file version");
                this.loadLayersAssets();
                Layers.instance.persist();
                Layers.logger.log(Level.FINE, "last layers file version persisted");
            }
        }
        Constants.closeStream((Closeable)is /* !! */ );
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadLayersAssets() throws Exception {
        BufferedReader reader = null;
        InputStream is = null;
        try {
            logger.log(Level.FINE, "load layers.txt from assets");
            is = this.getContext().openAssetFile(fileName);
            reader = new BufferedReader(new InputStreamReader(is));
            this.parseLayersFile(reader);
        }
        catch (IOException e) {
            try {
                throw e;
                catch (Exception e2) {
                    logger.log(Level.SEVERE, "loadProperties: ", e2);
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                Constants.closeStream(is);
                throw throwable;
            }
        }
        Constants.closeStream((Closeable)is);
    }

    public void clearProperties() {
        try {
            logger.log(Level.FINE, "clearProperties");
            this.properties = new Hashtable();
            this.layers = new Hashtable();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "clearProperties", e);
        }
    }

    public void addLayer(String layer) {
        try {
            try {
                layer = CompatManager.getInstance().getRegisteredEncIEncryptor().tryDecrypt(layer);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!layer.contains(";")) {
                return;
            }
            String[] part = layer.split(";");
            this.properties.put(part[0], part[1]);
            Integer in = new Integer(part[1].substring(0, 1));
            in = in >= 0 && in < 5 || in >= 7 ? (part[0].contains(">") ? new Integer(2) : new Integer(0)) : (part[0].contains(">") ? new Integer(2) : new Integer(1));
            Vector<String> v = this.layers.get(in);
            if (v == null) {
                v = new Vector<String>();
            }
            v.add(part[0]);
            this.layers.put(in, v);
            logger.log(Level.FINE, "Found: " + part[0] + " with value: " + part[1]);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "addLayer: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseLayersFile(BufferedReader reader) {
        boolean failed = false;
        try {
            String line = null;
            int i = 0;
            while ((line = reader.readLine()) != null) {
                if (i == 0 && line.compareToIgnoreCase("v0.2.2") != 0) {
                    failed = true;
                }
                if (++i == 0) continue;
                this.addLayer(line);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "parseLayersFile: ", e);
            failed = true;
            return failed;
        }
        finally {
            Constants.closeStream((Closeable)reader);
            return failed;
        }
    }

    public Hashtable getLayers() {
        return this.properties;
    }

    private String getLayerKeyFromName(String layerName) {
        try {
            Enumeration keys = this.properties.keys();
            String key = null;
            String temp = null;
            while (keys.hasMoreElements()) {
                try {
                    key = keys.nextElement().toString();
                    temp = key.substring(key.lastIndexOf("|") + 1, key.length());
                    if (!temp.equals(layerName)) continue;
                    return key;
                }
                catch (Exception ignore) {
                }
            }
            return layerName;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "layerkeyname", e);
            return null;
        }
    }

    public MapRenderer getRenderer(String layerTitle) throws IOException {
        MapRenderer renderer = null;
        try {
            String layer = this.properties.get(this.getLayerKeyFromName(layerTitle)).toString();
            String[] layerProps = layer.split(",");
            int size = layerProps.length;
            if (layerProps.length == 0) {
                logger.log(Level.FINE, "Bad layers file!");
                throw new IOException("Bad layers file");
            }
            renderer = MapRendererManager.getInstance().getMapRendererFactory().getMapRenderer(layerTitle, layerProps);
            return renderer;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "getRenderer: ", e);
            return renderer;
        }
    }

    public Hashtable getLayersForView() {
        try {
            Enumeration<Integer> keys = this.layers.keys();
            Integer key = null;
            Vector keyLayers = null;
            while (keys.hasMoreElements()) {
                key = keys.nextElement();
                keyLayers = this.layers.get(key);
                keyLayers = (Vector)this.mLayersSorter.sort((Collection)keyLayers);
                this.layers.put(key, keyLayers);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "getLayersforview", e);
        }
        return this.layers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void persist(String directoryAbsolutPath, String fileName) {
        BufferedWriter out = null;
        FileWriter logwriter = null;
        try {
            if (this.properties != null) {
                String dirPath = directoryAbsolutPath + File.separator;
                File f = new File(dirPath + fileName);
                if (!f.exists()) {
                    File dirFile = new File(dirPath);
                    dirFile.mkdirs();
                    f.createNewFile();
                } else {
                    f.delete();
                    f.createNewFile();
                }
                logwriter = new FileWriter(f, true);
                out = new BufferedWriter(logwriter);
                Enumeration keys = this.properties.keys();
                String layerTitle = null;
                MapRenderer renderer = null;
                out.write("v0.2.2\n");
                while (keys.hasMoreElements()) {
                    try {
                        layerTitle = keys.nextElement().toString();
                        if (layerTitle == null || (renderer = Layers.getInstance().getRenderer(layerTitle)) == null) continue;
                        logger.log(Level.FINE, layerTitle + " persisted");
                        String persist = renderer.toString();
                        if (renderer.isOffline()) {
                            persist = this.encryptLayer(persist);
                        }
                        out.write(persist + "\n");
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "error while writing: " + layerTitle);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "persist: ", e);
        }
        finally {
            Constants.closeStream(out);
            Constants.closeStream(logwriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist(String fileName) {
        BufferedWriter out = null;
        FileWriter logwriter = null;
        try {
            if (this.properties != null) {
                String dirPath = this.getContext().getBaseLayerPersistFilePath();
                File dir = new File(dirPath).getParentFile();
                File f = new File(dir.getAbsolutePath() + File.separator + fileName);
                if (!f.exists()) {
                    f.getParentFile().mkdirs();
                    f.createNewFile();
                } else {
                    f.delete();
                    f.createNewFile();
                }
                logwriter = new FileWriter(f, true);
                out = new BufferedWriter(logwriter);
                Enumeration keys = this.properties.keys();
                String layerTitle = null;
                MapRenderer renderer = null;
                out.write("v0.2.2\n");
                while (keys.hasMoreElements()) {
                    try {
                        layerTitle = keys.nextElement().toString();
                        if (layerTitle == null || (renderer = Layers.getInstance().getRenderer(layerTitle)) == null) continue;
                        logger.log(Level.FINE, layerTitle + " persisted");
                        String persist = renderer.toString();
                        if (renderer.isOffline()) {
                            persist = this.encryptLayer(persist);
                        }
                        out.write(persist + "\n");
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "error while writing: " + layerTitle);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "persist: ", e);
        }
        finally {
            Constants.closeStream(out);
            Constants.closeStream(logwriter);
        }
    }

    private String encryptLayer(String layer) throws BaseException, Exception {
        layer = CompatManager.getInstance().getRegisteredEncIEncryptor().encrypt(layer, CompatManager.getInstance().getRegisteredEncIEncryptor().getUniqueID());
        layer = "_DEVID_" + layer;
        return layer;
    }

    public void persist() {
        this.persist(fileName);
    }

    public void setLayersSorter(LayersSorter aLayersSorter) {
        this.mLayersSorter = aLayersSorter;
    }
}

