/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.tilecache.layers;

import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayersSorter {
    private static final Logger log = Logger.getLogger("LayersSorter");

    public Vector<String> sort(Vector<String> layers) {
        try {
            int size = layers.size();
            String[] temp = new String[size];
            for (int i = 0; i < size; ++i) {
                temp[i] = layers.elementAt(i);
            }
            LayersSorter.quicksort(temp);
            Vector<String> temp2 = new Vector<String>(size);
            String layerName = null;
            for (int i = 0; i < size; ++i) {
                layerName = temp[i];
                try {
                    int index = layerName.indexOf("|");
                    layerName = layerName.substring(index + 1, layerName.length());
                    temp2.add(layerName);
                    continue;
                }
                catch (Exception e) {
                    temp2.addElement(temp[i]);
                }
            }
            return temp2;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "sort", e);
            return null;
        }
    }

    public static void quicksort(String[] a) {
        LayersSorter.quicksort(a, 0, a.length - 1);
    }

    private static void quicksort(String[] a, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = LayersSorter.partition(a, left, right);
        LayersSorter.quicksort(a, left, i - 1);
        LayersSorter.quicksort(a, i + 1, right);
    }

    private static int partition(String[] a, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (LayersSorter.less(a[++i], a[right])) {
                continue;
            }
            while (LayersSorter.less(a[right], a[right]) && j != left) {
            }
            if (i >= j) break;
            LayersSorter.exch(a, i, j);
        }
        LayersSorter.exch(a, i, right);
        return i;
    }

    private static boolean less(String x, String y) {
        try {
            int position2;
            int index = x.indexOf("|");
            int index2 = y.indexOf("|");
            if (index == -1) {
                return false;
            }
            if (index2 == -1) {
                return false;
            }
            String num = x.substring(0, index);
            String num2 = y.substring(0, index2);
            int position = Integer.valueOf(num);
            return position < (position2 = Integer.valueOf(num2).intValue());
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void exch(String[] a, int i, int j) {
        String swap = a[i];
        a[i] = a[j];
        a[j] = swap;
    }
}

