/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.tilecache.provider;

import es.prodevelop.gvsig.mini.common.IBitmap;
import es.prodevelop.gvsig.mini.common.IContext;
import es.prodevelop.gvsig.mini.common.IEvent;
import es.prodevelop.gvsig.mini.common.IHandler;
import es.prodevelop.gvsig.mini.common.impl.BaseEvent;
import es.prodevelop.gvsig.mini.common.impl.Tile;
import es.prodevelop.gvsig.mini.geom.Extent;
import es.prodevelop.gvsig.mini.map.GeoUtils;
import es.prodevelop.gvsig.mini.utiles.Cancellable;
import es.prodevelop.gvsig.mini.utiles.Constants;
import es.prodevelop.gvsig.mini.utiles.WorkQueue;
import es.prodevelop.tilecache.draw.TileDrawer;
import es.prodevelop.tilecache.provider.TileCache;
import es.prodevelop.tilecache.provider.TileProvider;
import es.prodevelop.tilecache.provider.event.TileEvent;
import es.prodevelop.tilecache.provider.filesystem.ITileFileSystemProvider;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Downloader
implements GeoUtils {
    private static final Logger log = Logger.getLogger("Downloader");
    protected TileCache mTileCache;
    protected HashSet<String> mPending = new HashSet();
    protected IContext mCtx;
    public int transfer = 0;
    String datalog = null;
    protected ITileFileSystemProvider mMapTileFSProvider;
    private Extent viewExtent;

    public Downloader(IContext ctx, ITileFileSystemProvider aMapTileFSProvider) {
        try {
            this.mCtx = ctx;
            this.mMapTileFSProvider = aMapTileFSProvider;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Downloader constructor: ", e);
        }
    }

    public synchronized void getRemoteImageAsync(final Tile aTile, final IHandler callback, final String cacheURL, final Cancellable cancellable, final TileDrawer drawer, boolean prepend) {
        try {
            WorkQueue.getInstance().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    BufferedInputStream in = null;
                    BufferedOutputStream out = null;
                    boolean succeed = false;
                    int retryCount = 0;
                    while (retryCount <= TileProvider.NUM_RETRY && !succeed) {
                        block12: {
                            if (!cancellable.getCanceled()) break block12;
                            Downloader.this.mPending.clear();
                            WorkQueue.getInstance().clearPendingTasks();
                            Downloader.this.mCtx.sendMessage(callback, (IEvent)Downloader.this.instantiateEvent(aTile), -1);
                            Constants.closeStream((Closeable)in);
                            Constants.closeStream((Closeable)out);
                            ++retryCount;
                            return;
                        }
                        try {
                            in = new BufferedInputStream(Downloader.openConnection(aTile.mURL), 8192);
                            ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
                            out = new BufferedOutputStream(dataStream, 8192);
                            Constants.copy((InputStream)in, (OutputStream)out);
                            ((OutputStream)out).flush();
                            byte[] data = dataStream.toByteArray();
                            IBitmap bmp = Downloader.this.mCtx.decodeByteArray(data, 0, data.length);
                            if (Downloader.this.mMapTileFSProvider.getTileCache() != null) {
                                Downloader.this.mMapTileFSProvider.getTileCache().putTile(cacheURL, bmp);
                            }
                            if (Downloader.this.mCtx.isSDMounted()) {
                                Downloader.this.mMapTileFSProvider.saveFile(data, aTile);
                            }
                            Downloader.this.transfer = data.length + Downloader.this.transfer;
                            int transfer2 = Downloader.this.transfer / 1024;
                            Downloader.this.mCtx.sendMessage(callback, (IEvent)new BaseEvent(String.valueOf(data.length)), 3);
                            Downloader.this.mCtx.sendMessage(callback, (IEvent)Downloader.this.instantiateEvent(aTile), 0);
                            succeed = true;
                            if (drawer != null) {
                                drawer.drawTile(aTile.clone(), bmp);
                            }
                            Downloader.this.mPending.remove(cacheURL);
                        }
                        catch (OutOfMemoryError oe) {
                            block13: {
                                System.gc();
                                log.log(Level.SEVERE, aTile.mURL);
                                log.log(Level.SEVERE, "OutOfMemory: ", oe);
                                Downloader.this.mMapTileFSProvider.getTileCache().onLowMemory();
                                if (retryCount != TileProvider.NUM_RETRY) break block13;
                                Downloader.this.mCtx.sendMessage(callback, (IEvent)Downloader.this.instantiateEvent(aTile), 2);
                            }
                            Constants.closeStream((Closeable)in);
                            Constants.closeStream((Closeable)out);
                            ++retryCount;
                            continue;
                        }
                        catch (Exception e) {
                            if (retryCount == TileProvider.NUM_RETRY) {
                                Downloader.this.mCtx.sendMessage(callback, (IEvent)Downloader.this.instantiateEvent(aTile), 1);
                            }
                            log.log(Level.SEVERE, "Tile Loading Error " + aTile.mURL);
                            log.log(Level.SEVERE, e.getMessage());
                            {
                                catch (Throwable throwable) {
                                    Constants.closeStream(in);
                                    Constants.closeStream(out);
                                    ++retryCount;
                                    throw throwable;
                                }
                            }
                            Constants.closeStream((Closeable)in);
                            Constants.closeStream((Closeable)out);
                            ++retryCount;
                            continue;
                        }
                        Constants.closeStream((Closeable)in);
                        Constants.closeStream((Closeable)out);
                        ++retryCount;
                    }
                }
            }, prepend);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "getRemoteImageAsync: ", e);
        }
    }

    public synchronized void requestMapTileAsync(Tile aTile, IHandler callback, String cacheURL, Cancellable cancellable, TileDrawer drawer, boolean prepend) {
        try {
            if (this.mPending.contains(cacheURL)) {
                return;
            }
            this.mPending.add(cacheURL);
            this.getRemoteImageAsync(aTile, callback, cacheURL, cancellable, drawer, prepend);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "requestMapTileAsync: ", e);
        }
    }

    public TileEvent instantiateEvent(Tile aTile) {
        return new TileEvent(aTile.clone(), "", this.mMapTileFSProvider.getMode(), this.mMapTileFSProvider.getStrategy().getName(), 2);
    }

    public void setViewExtent(Extent viewExtent) {
        this.viewExtent = viewExtent;
    }

    public Extent getViewExtent() {
        return this.viewExtent;
    }

    public boolean checkDiscard(Tile tile) {
        try {
            if (tile.extent == null || this.getViewExtent() == null) {
                return false;
            }
            return !this.getViewExtent().intersect(tile.extent);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void removeFromPending(String cacheURL) {
        this.mPending.remove(cacheURL);
    }

    public Set getPendingQueue() {
        return this.mPending;
    }

    public static InputStream openConnection(String query) throws IOException {
        URL url = new URL(query.replace(" ", "%20"));
        URLConnection urlconnec = url.openConnection();
        urlconnec.setConnectTimeout(15000);
        urlconnec.setReadTimeout(15000);
        return urlconnec.getInputStream();
    }
}

