/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.tilecache.provider;

import es.prodevelop.gvsig.mini.common.IBitmap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUTileCache
extends HashMap<String, IBitmap> {
    private static final long serialVersionUID = 0x5ED5E5L;
    private final int maxCacheSize;
    private final LinkedList<String> list;
    private static final Logger log = Logger.getLogger("LRUTileCache");

    public LRUTileCache(int maxCacheSize) {
        super(maxCacheSize);
        this.maxCacheSize = Math.max(0, maxCacheSize);
        this.list = new LinkedList();
    }

    @Override
    public synchronized void clear() {
        try {
            for (IBitmap b : this.values()) {
                if (b == null) continue;
                b.recycle();
            }
            super.clear();
            this.list.clear();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "clear cache: ", e);
        }
    }

    @Override
    public synchronized IBitmap put(String key, IBitmap value) {
        try {
            String deadKey;
            IBitmap bitmap;
            if (this.maxCacheSize == 0) {
                return null;
            }
            if (!super.containsKey(key) && !this.list.isEmpty() && this.list.size() + 1 > this.maxCacheSize && (bitmap = (IBitmap)super.remove(deadKey = this.list.removeLast())) != null) {
                bitmap.recycle();
            }
            this.updateKey(key);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "put", e);
        }
        return super.put(key, value);
    }

    public synchronized IBitmap get(String key) {
        try {
            IBitmap value = (IBitmap)super.get(key);
            if (value != null) {
                this.updateKey(key);
            }
            return value;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "get", e);
            return null;
        }
    }

    public synchronized void remove(String key) {
        try {
            this.list.remove(key);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "remove", e);
        }
        IBitmap bitmap = (IBitmap)super.remove(key);
        if (bitmap != null) {
            bitmap.recycle();
        }
    }

    private void updateKey(String key) {
        try {
            this.list.remove(key);
            this.list.addFirst(key);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "updatekey", e);
        }
    }
}

