/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.tilecache.provider;

import es.prodevelop.gvsig.mini.common.IBitmap;
import es.prodevelop.gvsig.mini.map.GeoUtils;
import es.prodevelop.gvsig.mini.utiles.Constants;
import es.prodevelop.tilecache.provider.LRUTileCache;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TileCache
implements GeoUtils {
    protected HashMap<String, IBitmap> mCachedTiles;
    private static final Logger log = Logger.getLogger("TileCache");

    public TileCache(int width, int height, int tileSize) {
        try {
            int num = this.calculateNumTiles(width, height, tileSize, tileSize);
            log.log(Level.FINE, "tile cache size: " + num);
            this.mCachedTiles = num != 0 ? new LRUTileCache(num * 2 * Constants.BUFFER_SIZE) : new LRUTileCache(16 * 2 * Constants.BUFFER_SIZE);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "constructor", e);
        }
    }

    private int calculateRowCol(int width, int tileWidth) {
        int tilesPerRow = 0;
        try {
            int fullRow = width / tileWidth;
            if (fullRow == 0) {
                tilesPerRow = 2;
            } else {
                int moduloRow = width % tileWidth;
                if (moduloRow == 0) {
                    tilesPerRow = fullRow + 1;
                } else if (moduloRow == 1) {
                    tilesPerRow = fullRow + moduloRow;
                } else if (moduloRow >= 2) {
                    tilesPerRow = fullRow + 2;
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "calcrowcol", e);
        }
        return tilesPerRow;
    }

    private int calculateNumTiles(int width, int height, int tileWidth, int tileHeight) {
        try {
            if (height != 0 && width != 0) {
                int col = this.calculateRowCol(width, tileWidth);
                int row = this.calculateRowCol(height, tileHeight);
                return col * row;
            }
            return 0;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "calcnumtiles", e);
            return 0;
        }
    }

    public TileCache(int aMaximumCacheSize) {
        this.mCachedTiles = new LRUTileCache(aMaximumCacheSize);
    }

    public synchronized IBitmap getMapTile(String aTileURLString) {
        return this.mCachedTiles.get(aTileURLString);
    }

    public synchronized void putTile(String aTileURLString, IBitmap aTile) {
        this.mCachedTiles.put(aTileURLString, aTile);
    }

    public static String format(String aTileURLString) {
        return aTileURLString.substring(7).replace("/", "_");
    }

    public synchronized void onLowMemory() {
        try {
            log.log(Level.FINE, "onLowMemory");
            for (IBitmap b : this.mCachedTiles.values()) {
                if (b == null) continue;
                b.recycle();
            }
            this.mCachedTiles.clear();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "onLowMemory", e);
        }
    }

    public void destroy() {
        try {
            this.onLowMemory();
            this.mCachedTiles = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "destroy", e);
        }
    }
}

